/*************************************************************************
*
*
*	Name:  sfdata.c
*
*	Description:  Global data for SForm routines.
*
*
*	History:
*	Date		By		Comments
*
*	03/16/84	waf
*	06/08/84	waf		** Rev. 2.0 **
*
*
*
*  Copyright (c) 1983, 1984 by Digital Communication Assoc..
*  This document contains confidential/proprietary information.
*
*************************************************************************
*  SForm routines module.  */




/*  Notes -

*/

#include	"/sform/src/sfint.h"



/************************************/
/*		User definable variables	*/
/************************************/

/* Note that most of these vars/ptrs are set by sfinit(), so they should
   be changed after sfinit() is called. */


unsigned sf_inatros ;
/* This value is added to the display attribute value to derive the 'input
display attribute'. This is used to 'highlight' the current input field.
The default value, set by sfinit(), is SF_ATINPOS. */

int		sf_nrmcur, sf_inscur ;
/* These vars define the cursor 'type' during normal fld editing (sf_nrmcur)
and while in INSERT mode (sf_inscur). On systems which support different cursor
displays, the cursor type can be changed to flag INSERT mode. */

int	(*sf_usrhelp)() ;
/* This is the address of the function to be invoked when the user hits the
'Help' fn key. The default fn, set by sfinit(), displays a 'Not Implemented'
message. */

int	(*sf_usrerr)() ;
/* This is the address of the function which is called when a usr error
occurs. The default value, set by sfinit(), shows an error message. */

/********************************/
/*		User accesable vars		*/
/********************************/

/* These vars contain information which may be useful to the user's pgm */


int		sf_fldmod ;
/* This var is set by sf_winio() & sf_fldio() if the user modified any
data field(s). sf_winio() returns the fld # of the LAST modified fld,
sf_fldio() returns '-1' if the field was modified. */

/********************************/
/*		Internal variables		*/
/********************************/


struct SF_FIELD		sf_nullfld = 	/* define a 'null' field desc */
SF_ENDFLD ;
/* This structure MUST be used to terminate the field desc structure list. */

struct SF_WINDOW	*sf_curwin 	= (struct SF_WINDOW *) SF_NULL ;
/* This is the addr of the current window. It is set by the sf_winio() fn. */

int		sf_hifld	= 0 ;
/* This is the fld # of the highest field number in the current window. It is
set by sf_winio(). */

struct SF_FIELD		*sf_curfd ;
/* This is a ptr to the current fld descriptor. It is set by winio.c code,
and referenced primarily by errs.c code to reposition the cursor after an 
error msg. */

int		sfmsgflg	= 0 ;
/* Set if a message has been displayed using sfmsg(). The error/status message
is automatically cleared, using this flag. */

int		sfmioflg	= 0 ;
/* If set, don't report 'user' errors. This flag is set only during sfmsgio()
calls. Error reporting during sfmsgio() is minimized. */
