/*************************************************************************
*
*
*	Name:  prat.c
*
*	Description:  System dependent terminal control.
*
*					sfprat()	- BB 'print @' functionality.
*
*
*	History:
*	Date		By		Comments
*
*	03/14/84	waf
*
*
*
*  This document contains confidential/proprietary information.
*
*  Copyright (c) 1983, 1984 by Digital Communication Assoc..
*
*************************************************************************
*  SForm routines module.  */




/*  Notes -

	  Terminal control is currently implemented via the 'sfprat()' function.
	This fn mimics the BB 'PRINT @' functionality. This is currently
	workable, but may need to be changed in the future.

*/

#include	"/sform/src/sfint.h"
#if	(SF_PC && !ANSI)
#include	"dcatip.h"	/* get TIP codes */
#endif

char	*sfcntrl[] ;	/* control code strings */



sfprat ( arg1, arg2 )

int		arg1, arg2 ;

/* Implements BB's 'print @(code)' functionality.
   The arg1 & arg2 values are exactly the same as BB's.
*/

{
	register char	*cp ;


	if ( arg1 >= 0 ) {

		/* cursor positioning */
		poscur(arg1, arg2) ;
		return ;
		}
	
	else {

		/* Control code */
		cntrlcod(arg1, arg2) ;
		}
	}



static	badcode ()

/* Bad control code */

{

	sfpanic("prat: Illegal control code.") ;
	}

#if	SF_ALTOS

		/*********************
		**		ALTOS		**
		*********************/

/* The following table was taken from the /bb/run/src/crts.c module,
   and is used for controlling the 6053 terminal on an Altos system.
*/

/* terminal attributes */
char *sfcntrl[] = {		/* terminal type 6 */
	"\010",			/* -20 home cursor */
	"\030",			/* -21 cursor right */
	"\032",			/* -22 cursor down */
	"\031",			/* -23 cursor left */
	"\027",			/* -24 cursor up */
	"\007",			/* -25 bell */
	"\011",			/* -26 tab */
	"\015",			/* -27 return (no line-feed) */
	"\012",			/* -28 new-line */
	"\377",			/* -29 back tab */
	"\014",			/* -30 clear all to spaces */
	"\377",			/* -31 clear unprotected to spaces */
	"\013",			/* -32 clear to end of line */
	"\377",			/* -33 clear to end of page */
	"\377",			/* -34 keyboard lock */
	"\377",			/* -35 keyboard unlock */
	"\377",			/* -36 insert line */
	"\377",			/* -37 delete line */
	"\034",			/* -38 start protect (low intensity) */
	"\035",			/* -39 start unprotect (high intensity) */
	"\016",			/* -40 start blink */
	"\017",			/* -41 end blink */
	"\023",			/* -42 set format mode */
	"\022",			/* -43 end format mode */
	"\377",			/* -44 set program mode */
	"\377",			/* -45 end program mode */
	"\377",			/* -46 set block mode */
	"\377",			/* -47 set conversation mode */
	"\377",			/* -48 set flag 1 */
	"\377",			/* -49 clear flag 1 */
	"\377",			/* -50 send line (field) unprotected */
	"\377",			/* -51 send line (field) all */
	"\024",			/* -52 start underscore */
	"\025",			/* -53 end under score */
	"\035\024",		/* -54 start field (bright & underscore ) */
	"\025\034",		/* -55 end field (dim & normal ) */
	"\025\035\017\022",	/* -56 return to normal */
	} ;

/* This function was taken from the BB src file 'crts.c'.
   It is used to position the cursor.
*/

/*							 */
/*   terminal type 6 - Data General 6053, D/100, D/200   */
/*							 */

#define	bufst	0
#define C_WR6   '\020'
#define C_LEFT6 '\031'
#define C_UP6   '\027'
#define MAXROW6 24
#define MAXCOL6 80

static	poscur(row, col)		/* cursor position function */

int row, col;

/* waf - Modified to output the control char sequence
		and to use 0 based values. 
*/
{
	register unsigned	arg1,arg2;
	int	colflag;
	int	rowflag;
	char	buf[16];


	/* waf - save current pos */

	/* waf - convert to 1 based args */
	arg1 = row ; arg2 = col ;	/* use reg vars */
	arg1++ ; arg2++ ;

	colflag = rowflag = 0 ;

	buf[bufst+0] = C_WR6;		/* cursor-write lead in */

	/* adjust for screen size */
	arg1 = ((arg1 > MAXROW6)? MAXROW6 : arg1) - 1 ;
	arg2 = ((arg2 > MAXCOL6)? MAXCOL6 : arg2) - 1 ;

	/* chk for strangeness at certain pixels.
	   Xenix will not accept certain binary strings, so we have to
	   fool it by going past the desired position, and then
	   backing up.
	   Note - assumes arg1 & arg2 have 0 hi bytes. */
	if ( arg2 == 9 || arg2 == 4 || arg2 == 10 || arg2 == 13 ) {
		arg2++;
		colflag++;	/* set col flag */
		}
	buf[bufst+1] = arg2 | 0200;
	if ( arg1 == 9 || arg1 == 4 || arg1 == 10 || arg1 == 13 ) {
		arg1++;
		rowflag++;	/* set row flag */
		}
	buf[bufst+2] = arg1 | 0200;
	/* backup, if necessary */
	arg1 = bufst + 3 ;		/* buf len before correction chars added */
	if ( colflag )
		buf[arg1++] = C_LEFT6;
	if ( rowflag )
		buf[arg1++] = C_UP6;


	/* waf - Output control string */
	sfoutns(buf, arg1) ;

	}

static	cntrlcod ( arg1, arg2 )

int		arg1, arg2 ;

/* Process control code.
*/

{
	register char	*cp ;



	arg1 = -arg1 ;		/* make code positive */
	if ( arg1 > 56 ) {
		badcode() ;		/* too big */	
		}
	if ( arg1 >= 20 ) {

		/* Use cntrl string */
		cp = sfcntrl[arg1 - 20] ;	/* control string */
		if ( *cp != '\377' )	/* if control string defined */
			sfouts(cp) ;
		}
	
	else {

		/* Do control */
		switch ( arg1 ) {

			case 18 :
				if ( arg2 == 3 ) {
					/* Disable scroll */
					sfoutc('\23') ;
					}
				else if ( arg2 == -3 ) {
					/* Enable scroll */
					sfoutc('\22') ;
					}
				else
					badcode() ;
				break ;
			
			default :
				badcode() ;
			}
		}
	}

#endif

#if	SF_PC

		/*****************
		**		PC		**
		*****************/

#if	ANSI

/* Control strings for PC w/ ANSI.SYS */
char	*sfcntrl[] = {
	"\33[H",		/* -20 home cursor */
	"\33[1C",		/* -21 cursor right */
	"\33[1B",		/* -22 cursor down */
	"\33[1D",		/* -23 cursor left */
	"\33[1A",		/* -24 cursor up */
	"\7",			/* -25 bell */
	"\9",			/* -26 tab */
	"\15",			/* -27 return (no line-feed) */
	"\12",			/* -28 new-line */
	"\377",			/* -29 back tab */
	"\33[2J",		/* -30 clear all to spaces */
	"\377",			/* -31 clear unprotected to spaces */
	"\33[k",		/* -32 clear to end of line */
	"\377",			/* -33 clear to end of page */
	"\377",			/* -34 keyboard lock */
	"\377",			/* -35 keyboard unlock */
	"\377",			/* -36 insert line */
	"\377",			/* -37 delete line */
	"\377",			/* -38 start protect (low intensity) */
	"\377",			/* -39 start unprotect (high intensity) */
	"\33[5m",		/* -40 start blink */
	"\377",			/* -41 end blink */
	"\377",			/* -42 set format mode */
	"\377",			/* -43 end format mode */
	"\377",			/* -44 set program mode */
	"\377",			/* -45 end program mode */
	"\377",			/* -46 set block mode */
	"\377",			/* -47 set conversation mode */
	"\377",			/* -48 set flag 1 */
	"\377",			/* -49 clear flag 1 */
	"\377",			/* -50 send line (field) unprotected */
	"\377",			/* -51 send line (field) all */
	"\33[4m",		/* -52 start underscore */
	"\377",			/* -53 end under score */
	"\33[0;1;4m",	/* -54 start field (bright & underscore ) */
	"\33[0m",		/* -55 end field (dim & normal ) */
	"\33[0;1m", 	/* -56 return to normal */
	} ;

#else

/* Control strings for TIP.
   ** NOTE ** - display attributes are not fully implemented. */
int		sfcntrl[] = {
	"\TO_MCH",		/* -20 home cursor */
	"\TO_MCR",		/* -21 cursor right */
	"\TO_MCD",		/* -22 cursor down */
	"\TO_MCL",		/* -23 cursor left */
	"\TO_MCU",		/* -24 cursor up */
	"\7",			/* -25 bell */
	"\9",			/* -26 tab */
	"\13",			/* -27 return (no line-feed) */
	"\10",			/* -28 new-line */
	"\377",			/* -29 back tab */
	"\TO_CS",		/* -30 clear all to spaces */
	"\377",			/* -31 clear unprotected to spaces */
	"\TO_ERL",		/* -32 clear to end of line */
	"\377",			/* -33 clear to end of page */
	"\377",			/* -34 keyboard lock */
	"\377",			/* -35 keyboard unlock */
	"\TO_INS",		/* -36 insert line */
	"\TO_DEL",		/* -37 delete line */
	"\TO_SDIM",		/* -38 start protect (low intensity) */
	"\TO_EDIM",		/* -39 start unprotect (high intensity) */
	"\TO_SBLNK",	/* -40 start blink */
	"\TO_EBLNK",	/* -41 end blink */
	"\377",			/* -42 set format mode */
	"\377",			/* -43 end format mode */
	"\377",			/* -44 set program mode */
	"\377",			/* -45 end program mode */
	"\377",			/* -46 set block mode */
	"\377",			/* -47 set conversation mode */
	"\377",			/* -48 set flag 1 */
	"\377",			/* -49 clear flag 1 */
	"\377",			/* -50 send line (field) unprotected */
	"\377",			/* -51 send line (field) all */
	"\TO_SUNDL",	/* -52 start underscore */
	"\TO_EUNDL",	/* -53 end under score */
	"\377",			/* -54 start field (bright & underscore ) */
	"\TO_VN",		/* -55 end field (dim & normal ) */
	"\TO_VN",	 	/* -56 return to normal */
	} ;
#endif

static	poscur ( row, col )

int		row, col ;

/* Position cursor (PC version).
   Params are zero based.
*/

{


#if	ANSI
	???
#else
	tputc(TO_MC, row, col) ;
#endif

	}

static	cntrlcod ( arg1, arg2 )

int		arg1, arg2 ;

/* Process control code.
*/

{



	arg1 = -arg1 ;		/* make code positive */
	if ( arg1 > 56 ) {
		badcode() ;		/* too big */	
		}
	if ( arg1 >= 20 ) {

		/* Use cntrl string */
		cp = sfcntrl[arg1 - 20] ;		/* control string */
		if ( *cp != '\377' )
			sfouts(cp) ;
		}
	
	else {

		/* Do control */
		switch ( arg1 ) {

			case 18 :
				if ( arg2 == 3 ) {
					/* Disable scroll */
					/* >>> ??? */
					}
				else if ( arg2 == -3 ) {
					/* Enable scroll */
					/* >>> ??? */
					}
				else
					badcode() ;
				break ;
			
			default :
				badcode ;
			}
		}
	}

#endif
