
/*                                                           */
/*       Copyright 1983 Technical Analysis Corporation       */
/*                                                           */


#include   "/bb/include/ptype.h"
#include   "/bb/include/vartab.h"		/* defines vtab as global */

#define VOFFSET 3				/* skip first ? variables */

int nvar, one_up;
char progname[133];

main(argc, argv)
int  argc;
char *argv[];
{

   setvar(argc, argv);

   sortvar();

   dispvar();

} /* end-main */

setvar(argc, argv)
int  argc;
char *argv[];
{
   struct phead  pcdhead;
   char   tmp[133];
   int    n, fd;


   if (argc < 2 || argc > 3) {
      printf("Usage: bbvar [-1] bb_program\n");
      exit(-1);
   }

   if (argc == 3) {
      strcpy(tmp, *++argv);
      if (strcmp(tmp, "-1") == 0)
	 one_up = 1;
      else {
	 printf("Usage: bbvar [-1] bb_program\n");
	 exit(-1);
      }
   } else
      one_up = 0;

   strcpy(progname, *++argv);
   strcpy(tmp, progname);
   strcat(tmp, ".bp");
   resolve(tmp, tmp);
   if ((fd = open(tmp, 2)) < 0) {
      resolve(progname, tmp);
      if ((fd = open(tmp, 2)) < 0) {
	 printf("bbvar: can't open %s\n", progname);
	 exit(-2);
      }
   }

   read(fd, &pcdhead, sizeof(pcdhead));
   n = 512 + pcdhead.codsiz + pcdhead.ltabsiz;
   lseek(fd, (long) n, 0);
   if((n = read(fd, &vtab, pcdhead.symsiz)) != pcdhead.symsiz) {
      printf( "bbvar: symbol table read error\n" );
      exit( -1 );
   }

   for (nvar = 0; vtab[nvar+VOFFSET].vname[0] != '\0' && nvar < 348; nvar++)
      ;

} /* end-setvar */

dispvar()
{
   int  i, v, p, s;
   char var[16];

   printf("%s: %d variables\n\n", progname, nvar);

   for (v = VOFFSET, i = 0; i < nvar; i++, v++) {

      for (p = 0; vtab[v].vname[p] != '\0' && p < 8; p++)
	 var[p] = vtab[v].vname[p];
      
      switch (vtab[v].vtype) {

	 case typeJ:
	 case typeL:
	    if (vtab[v].numsubs != 0) {
	       var[p++] = '[';
	       for (s = 1; s <= vtab[v].numsubs; s++) {
		  var[p++] = '*';
		  var[p++] = (s != vtab[v].numsubs) ? ',' : ']';
	       }
	    }
	    break;

	 case typeA:
	    break;

	 default:
	    printf("bbvar: unknown variable type %d on %s\n", vtab[v].vtype, vtab[v].vname);
	    exit(-1);

      } /* end-switch */

      for (; p < 16; p++)
	 var[p] = (p == 15) ? '\0' : ' ';

      printf("%s   ", var);

      if (one_up == 1)
	 printf("\n\n");
      else if ((v-VOFFSET+1)%4 == 0)
	 printf("\n");

   } /* end-for */

   printf("\n\n");

} /* end-dispvar */

sortvar()
{
   int span, nsets, iset, lower, upper;

   span = 0;

   while (span < nvar)
      span = span + span + 1;

   while ((span = span/2) > 0) {

      nsets = nvar - span;

      for (iset = 0; iset <= nsets; iset++)
	 for (lower = iset; lower >= 1; lower -= span) {
	    upper = lower + span;
	    if (strncmp(vtab[upper+VOFFSET-1].vname, vtab[lower+VOFFSET-1].vname, 8) < 0)
	       swap(upper+VOFFSET-1, lower+VOFFSET-1);
	 }

   } /* end-while */

} /* end-sortvar */

swap(n1, n2)
int n1, n2;
{
   struct VTAB vtmp;

   vtmp = vtab[n1];
   vtab[n1] = vtab[n2];
   vtab[n2] = vtmp;

} /* end-swap */

resolve(linknam, reslnam)
char	*linknam, *reslnam;
{
   int  i, n, fd, depth;
   char	tmp[PATHSIZE+1];

   strcpy(reslnam, linknam);
   for (depth = 10; depth > 0; depth--) {
      strcpy(tmp, reslnam);
      strcat(tmp, ".lk");
      if ((fd = open(tmp, 0)) < 0)
	 return(0);
      if ((n = read(fd, reslnam, 133)) <= 0) {
	 close(fd);
	 return(-1);
      }
      for (i = 0; i < n; i++)
	 if (reslnam[i] == '\n' || reslnam[i] == '\r' ||
	                           reslnam[i] == '\f' ||
			           reslnam[i] == '\0') {
	     reslnam[i] = '\0';
	     break;
	 }
      strcpy(tmp, reslnam);
      close(fd);
   }
   return(-2);
} /* end-resolve */
