:! VAL - Convert a string to a number     (BBIII double & triple)
:#
:     VAL converts a string in X$ to a number in X.  It will convert
:     signed or unsigned numbers with or without a decimal point.
:     WARNING - VAL only handles number of Double precision magnitude
:     See VALT.SL as al alternative for triple precision.
:> CALLING SEQUENCE
:     X$ - String to be converted
:     GOSUB 7600
:     X  - Value of X$
:     Z% - EXPONENT (DEC LOC-POWER OF 10 OR NEG IF NO DEC FOUND)
:     Y% - Error code (0 or ASC(terminating char))
:
:     GOSUB 7608 : If no decimal is allowed
:     GOSUB 7610 : If no sign is allowed
:$ STORAGE USED
:     I% - INPUT STR CHAR POINTER
:     X% - SIGN ( 1=POS, -1=NEG )
::
7600 REM \ VAL 
7602 LET X%=0             :Clear sign
7604 GOTO 7612
7608 LET X%=-1            :Pre-set sign
7609 GOTO 7612
7610 LET X%=1             :Pre-set sign
7612 LET Z%=0             :Pre-set decimal loc
7614 LET X=0              :Clear X (returned value)
7615 LET Y%=0             :Clear Y% (error)
7616 VALUE X,X$,Y%,Z%
7617 LET I%=ABS(Y%)       :Get pointer to terminating char
7618 IF X%=1 THEN IF X<0 THEN GOTO 7650  :Neg - Error
7620 IF X% THEN IF Z%>=0 THEN GOTO 7650  :Non-integer - Error
7622 LET X%=SGN(X)        :Return proper sign
7624 LET Y%=MAX(ABS(Y%),0)           :Return terminating char
7626 IF Y% THEN LET Y%=ASC(X$[Y%,Y%]):   if one exists
7628 RETURN
7650 LET Y%=-1            :Return error
7652 RETURN 
7674 REM * END VAL.SL 10/06/78
