:! SHELLSORT.SL - Sort an array or string
:#
:     Subroutine for sorting an array <A> or string <A$> in core.
:     statement substitutions are given to allow the routine to sort
:     a single dimension array, A[R]; a two dimension array, A[R,C];
:     and a string, A$[R*C] where A$ consists of <R> substrings <C>
:     characters in length. for A[R,C] only, the first <K> elements
:     of the second dimension are compared to check sequence, but all
:     <C> elements are swapped on an OUT-OF-SEQUENCE condition.
:     for A$[R*C] only the first <K> characters of the <C> character
:     substring are compared to check sequence, but all <c> characters
:     are swapped on an OUT-OF-SEQUENCE condition.
:> CALLING SEQUENCE
:     A  - Array to be sorted, or
:     A$ - String to be sorted
:     R  - Number of rows (substrings) in A (A$)
:     C  - Number of columns (characters) wide A or A$
:     K  - Number of columns to be used as key for comparison
:     GOSUB 9000
:$ STORAGE USED
:     SPAN   - Distance between elements being compared
:     NSETS  - Number of sets of elements SPAN elements apart
:     ISETS  - Pointer to lower set of elements
:     LOWER  - Temporary pointer to lower element
:     UPPER  - Temporary pointer to upper element
:     LOWERP - Temporary pointer to lower element (A$)
:     UPPERP - Temporary pointer to upper element (A$)
:     I%     - Temporary index to second subscript of A
:     TMP    - Temporary for exchanging elements of A
:     TMP$   - Temporary for exchanging elements of A$
::
9000 REM \ SHELLSORT ACM ALGORITHM #201
9001 LET SPAN=0
9002 LET SPAN=SPAN+SPAN+1
9003 IF SPAN<R THEN GOTO 9002
9004 LET SPAN=SPAN/2
9005 IF SPAN<=0 THEN RETURN
9007 LET NSETS=R-SPAN
9010 FOR ISET=0 TO NSETS
9011   FOR LOWER=ISET TO 1 STEP -SPAN
9013     LET UPPER=LOWER+SPAN
9014     FOR I%=0 TO K
9015       ON SGN(A[LOWER,I%]-A[UPPER,I%])+2 THEN GOTO 9028, 9016, 9018
9016     NEXT I%
9017     GOTO 9028
9018     FOR I%=0 TO C
9019       LET TMP=A[LOWER,I%]
9020       LET A[LOWER,I%]=A[UPPER,I%]
9021       LET A[UPPER,I%]=TMP
9022     NEXT I%
9026   NEXT LOWER
9028 NEXT ISET
9032 GOTO 9004 
:
: * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
: FOR SORTING A SINGLE DIMENSION ARRAY, A[R]:
:
:      SUBSTITUTE FOLLOWING STATEMENTS FOR 9014-22
: 9015   IF A[LOWER]<=A[UPPER] THEN GOTO 9028
: 9019   LET TMP=A[LOWER]
: 9020   LET A[LOWER]=A[UPPER]
: 9021   LET A[UPPER]=TMP
:
: * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
: FOR SORTING A STRING, A$[R*C]:
:
:      SUBSITUTE FOLLOWING FOR 9014-22
: 9015   LET LOWERP=(LOWER-1)*C+1
: 9016   LET UPPERP=(UPPER-1)*C+1
: 9017   IF A$[LOWERP,LOWERP+C-1]<=A$[UPPERP,UPPERP+C-1] THEN GOTO 9028
: 9018   LET TMP$=A$[LOWERP,LOWERP+C-1]
: 9019   LET A$[LOWERP,LOWERP+C-1]=A$[UPPERP,UPPERP+C-1]
: 9020   LET A$[UPPERP,UPPERP+C-1]=TMP$
9049 REM * END OF SHELLSORT 11/15/76
