:! POSFL - POSITION A LOGICAL SUBFILE
:#
:     POSFL positions the file on logical channel F% to record R1.
:     It returns in C% the physical channel that the file is open on.
:     An ERROR 16 occurs at statement 9615 if R1 is less than zero.
:     An ERROR 16 occurs at statement 9620 if R1 is beyond the end of
:     the file.
:> CALLING SEQUENCE
:     F%  - Logical file number
:     R1  - Logical record number
:     GOSUB 9610
:     C%  - Physical channel number
:     R8  - Logical byte position (for LOCK)
:
:> ALTERNATE CALLING SEQUENCE
:     F%  - Logical file number
:     R1  - logical record number
:     V%  - Beginning byte within the record
:     GOSUB 9612
:     C%  - Physical channel number
:     R8  - Logical byte position (for LOCK)
:$ STORAGE USED
:     V%  - OFFSET INTO RECORD
:     R9  - BYTE POSITION OF RECORD R1
:     C1  - FILE CHARACTERISTICS ARRAY
:           C1[F%,0] - PHYSICAL CHANNEL #
:           C1[F%,1] - BYTE OFFSET TO REC 0
:           C1[F%,2] - MAX # OF RECORDS
:           C1[F%,3] - # BYTES/RECORD
::
9610 REM \ POSFL 
9611 LET V%=0                :FOR POSITION TO BEGINNING OF RECORD
9612 REM \ POSFL WITH OFFSET V%
9613 LET C%=C1[F%,0]         :CHANNEL #
9615 IF R1<0 THEN LET V%=1/0 :INVALID REC #
9620 IF R1>=C1[F%,2] THEN LET V%=1/0  :ILLEGAL REC # - PANIC ! ! !
9625 LET R8=R1*C1[F%,3]      :LOGICAL FILE BYTE POINTER
9630 LET R9=C1[F%,1]+R8+V%   :BYTE POSITION OF R1 IN PHY FILE
9640 POSITION FILE[C%,R9]
9645 RETURN
9649 REM * END POSFL.SL 12/06/77
