:! FLOAT - Convert X from an integer to a real format number.
:#
:     FLOAT converts a Business BASIC integer in X to a floating point
:     number optionally dividing X by Y allowing scaling to correct
:     for implied decimals used in the integer format.
:     This routine allows the producing real numbers to be read
:     by DG FORTRAN, ALGOL, & Extended BASIC.
:     WARNING - when scaling, as the value of Y increases the
:     accuracy of the resulting X decreases.
:> CALLING SEQUENCE
:     X = Integer X
:     GOSUB 8750             :X=FLOAT(X)
:     X - Real number in DG floating point format
:> ALTERNATE CALLING SEQUENCE
:     X = Integer X
:     Y = Value by which to scale X  ( X / Y )
:     GOSUB 8754             :X=FLOAT(X)/Y
:     X = Real number in DG floating point format
:$ STORAGE USED
:     Y% - Exponent of X as a real
::
8750 REM \ FLOAT UNSCALED INTEGER->REAL
8752 LET Y=1                           :Scaling factor for X
8754 REM \ SFLOAT SCALED INTEGER->REAL
8756 IF X=0 THEN RETURN                :Zero is zero
8758 LET Y%=140                        :Exponent*2 for an integer
8760 LET Y%=OR(Y%,SHFT(X,-31))         :Keep sign in low order bit
8762 LET X=ABS(X)                      :Mantissa is positive only
8764 IF AND(X,-268435456) THEN GOTO 8772         :Shift for max significance during division
8766 LET X=SHFT(X,4)
8768 LET Y%=Y%-2                       :Exponent must reflect shift
8770 GOTO 8764
8772 LET X=X/Y                         :Scale by Y
8774 IF X=0 THEN RETURN                :Forget zeros
:     Begin normalization of mantissa
8776 IF AND(X,-16777216)=0 THEN GOTO 8784        :Shift significant bits out of exponent location
8778 LET X=SHFT(X,-4)
8780 LET Y%=Y%+2                       :Make exponent reflect shift
8782 GOTO 8776
8784 IF AND(X,16711680) THEN GOTO 8792 :Shift significant bits into high order nibble if not already there
8786 LET X=SHFT(X,4)
8788 LET Y%=Y%-2                       :Keep exponent in step with shift
8790 GOTO 8784
8792 LET X=OR(OR(X,SHFT(Y%/2,24)),SHFT(Y%,31))   :Combine mantissa with exponent and sign
8794 RETURN 
8796 REM * END FLOAT 8/30/78
