:! FIX - Convert X from a floating point number to an integer.
:#
:     FIX converts a floating point number in X to an integer
:     optionally multiplying X by Y allowing scaling to correct
:     for implied decimals in the integer format.
:     This routine allows the reading of real numbers as produced
:     by DG FORTRAN, ALGOL, & Extended BASIC.
:     WARNING - when scaling, a value of Y>100 is likely to cause
:     arithmetic overflow.
:> CALLING SEQUENCE
:     X = Real number in DG floating point format
:     GOSUB 8700             :X=INT(X)
:     X - Integer portion of X only
:> ALTERNATE CALLING SEQUENCE
:     X = Real number in DG floating point format
:     Y = Value by which to scale X  ( X * Y )
:     GOSUB 8704             :X=INT(X*Y)
:     X - Integer value of scaled X
:$ STORAGE USED
:     Y% - Exponent of X as a real
::
8700 REM \ FIX (UNSCALED REAL->INTEGER)
8702 LET Y=1                           :Value by which to scale X
8704 REM \ SFIX :SCALED REAL->INTEGER
8706 LET Y%=SHFT(X,-24)                :Get exponent and sign
8708 LET X=AND(X,16777215)*Y           :Mask to 24 bits & scale by Y
8710 LET X=SHFT(X,4*(AND(Y%,127)-70))  :Shift implied decimal to bit 0
8712 IF AND(Y%,128) THEN LET X=-X      :Correct sign if negative
8714 RETURN 
8716 REM * END FIX.SL 8/30/78
