/*************************************************************************
*
*
*   Name: Val
*
*   Description:  VAL function and VALUE ucall.
*
*
*   History:
*   Date         By      Comments
*
*   2/28/83      WAF   
*	4/26/83		waf Local version of cdbl() (embedded sign & char max).
*	6/27/83		mas	added registers where possible
*
*
*
*  This document contains confidential/proprietary information.
*
*  Copyright 1983, 1984 by Digital Communications Assoc.
*
*************************************************************************
* BB/Xenix Runtime Module */




/*  Notes -

> vall function - pos info & embedded signs fix.


.SH
*/

#include		"/bb/include/ptype.h"



			/**  VAL function  **/

/*	Return value = converted value of string.
	Also returns decimal pos or -1 in error variable */


long  vall ( strdes, ervar )

/*  Input Args  */
STRDES   strdes;		/*  string argument desc  */
NUMDES   ervar;		/*  error var desc  */
   {

   /*  Local Vars  */
   long   val;       /* return value */
   register int	 pos;			/* position info */
   char *ptr;

   /* get value */
	ptr = strdes.data ;
   pos = cdbln( &ptr, &val, 0, strdes.curlth );

   /* return position info */
	if ( pos == 0 )
		if ( ptr - strdes.data != strdes.curlth )
			/* did not stop at end of $ */
			pos = -1 ;		/* flag error */
	putvj( &ervar, pos );

   /* return val */
   return ( val ) ;

   }


/* 
.SH
			**  VALUE statement  **

*/

value ( valvar, strdes, posvar, scalevar )

/*  Arguments  */
NUMDES	valvar;
STRDES	strdes;
NUMDES	posvar, scalevar;
	{

	/* local vars */
	register long	val;			/* value of $ */
	int	pos;		/* position */
	int	scale;		/* scale */
	
	/** convert string **/
	cdblv( strdes.data, &val, strdes.curlth, &scale, &pos );

	/** return value **/
	putvl( &valvar, val );		/* put value in val var */

	/** return position info **/
	/* position = rel pos of terminating char */
	if ( isvar(&posvar) == FALSE )
		return;		/* no position var used */
	putvl( &posvar, (long) pos );
	
	/** return scale info **/
	if ( isvar(&scalevar) == FALSE )
		return;		/* no scale var used */
	putvl( &scalevar, (long) scale );

	}

/* 
.SH */

cdblv ( strptr, retval, nchars, retscale, retpos )

/* Dedicated version of cdbl().
	Allows max # chars to be defined.
	Returns info in 'value format'.
	Allows embedded signs.
	Ret val = position info in 'val function format'. */

char	*strptr ;		/* ptr to input str */
long	*retval ;		/* value of string */
int	nchars ;			/* # chars to be scanned */
int	*retscale ;		/* scaling info */
int	*retpos ;		/* pos info ( value format ) */

	{
	register char	c ;
	int	sign ;		/* 0 = no sign, 1 = '+', -1 = '-' */
	register int	pos, scale ;	/* pos & scale info (value format) */
	long	lval, tval;

	/** initialize **/
	sign = 0 ;			/* no sign */
	lval = 0L ;			/* ret value accumulator */
	pos = 1 ;			/* init pos = 1 */
	scale = -32767 ;	/* (can't use '32768' in 'c' code) */

	/** skip leading spaces **/
	while ( *strptr == ' ' )
		{
		strptr++ ;
		nchars-- ;
		}

	while ( nchars != 0 )
		{
		c = *strptr++ ;		/* next char */

		/** chk for sign **/
		if ( c == '+' || c == '-' )
			{

			/* sign found. chk for sign already defined */
			if ( sign != 0 )
				goto cdvdone ;		/* this is second sign - return here */
			/* save sign */
			if ( c == '+' )
				sign = 1 ;
			else
				sign = -1 ;
			}

		/** chk for digit **/
		else if ( c >= '0' && c <= '9' )
			{

			/* add next digit to acc */
			tval = lval ;								/* orig val */
			lval <<= 1 ;									/* x 2 */
			if ( lval < 0 )  goto cdvovf ;		/* overflow */
			lval <<= 1 ;									/* x 4 */
			if ( lval < 0 )  goto cdvovf ;
			lval += tval ;								/* x 5 */
			if ( lval < 0 )  goto cdvovf ;
			lval <<= 1 ;									/* x 10 */
			if ( lval < 0 )  goto cdvovf ;
			lval += (long) ( c - '0' ) ;			/* orig x 10 + digit */
			if ( lval < 0 )  goto cdvovf ;

			scale++ ;		/* inc scale for digits only */
			}

		/** chk for '.' **/
		else if ( c == '.' )
			{

			/* chk for '.' already found */
			if ( scale >= 0 )
				goto cdvdone ;		/* second '.' */

			/* record '.' pos */
			scale = 0 ;
			}

		else goto cdvdone ;		/* not legal char */

		/** adjust pos info **/
		pos++ ;

		nchars-- ;
		}		/* repeat while char = digit or sign or '.' */

	/** scan term'ed by end of $ **/
	pos = 0 ;

	cdvdone:		/** conversion ended - ret info **/

	/** chk for ' ' or ',' at end **/
	if ( pos != -1 )		/* if overflow did not occur */
		if ( c != ' ' && c != ',' )
			pos = -pos ;		/* return neg pos */

	/** get sign of result **/
	if ( sign != 0 )
		lval *= (long) sign ;

	/** return info **/
	*retval = lval ;
	if ( scale < 0 )
		scale = scale - 1 ;		/* (starts at -32768) */
	*retscale = scale ;
	*retpos = pos ;
	return ;


	cdvovf:		/** overflow occured **/

	/* restore val of lval before last digit */
	lval = tval ;

	goto cdvdone ;
	}
