/*************************************************************************
*
*
*	Name:  sys.c
*
*	Description:  sys functions
*
*
*	History:
*	Date		By		Comments
*
*	04/01/83	WEB
*	04/14/83	WEB	changes '/bbsyslib' to '/bb/syslib'
*	04/25/83	mas	added support for sys(11)
*	04/29/83	mas	fixed sys(18) and sys(19)
*	05/12/83	mas	changed sys(20) to call pctoline with
*				mode = 0 
*	06/10/83	WEB	added termno variable
*	06/22/83	mas	changed sys(29) to use numfd
*	6/27/83		mas	added registers where possible
*	08/26/83	waf	Added cond. code for BB/PC.
*					SYS(4) returns constant '0' in BB/PC.
*
*
*
*  This document contains confidential/proprietary information.
*
*  Copyright 1983, 1984 by Digital Communications Assoc.
*
*************************************************************************
* BB/Xenix Runtime Module */




/*  Notes -


.SH*/

#include <time.h>
#include "/bb/include/ptype.h"
#include "/bb/include/pextern.h"
#include "/bb/include/bberms.h"
#include "/bb/include/syerms.h"

#define LOCK 1
#define UNLOCK 0
#define ALL 0L
#define HERTZ 60			/* fudge factor for times() */

extern int errno;			/* system error code */
extern struct tm *localtime();
extern long lseek();
extern long pctoline();

static long termno = -1L;

long sys(value)
int value;
{
   struct tbuffer {			/* buffer for times() */
      long proc_user_time;
      long proc_system_time;
      long child_user_time;
      long child_system_time;
   	} ptimes;
   struct tm timebuf;
   union {
      long lnum;
      char buff[4];
   	} specno;
   long ltmp, uniqueno,l;
   int n, specfile;
   register unsigned x,y;

   if (value < 0 || value > 31)		/* error if value out of range */
      bberr(BEFAR);

   switch (value) {

      case 0:
	 gtime(&timebuf);
	 ltmp = (long) timebuf.tm_hour*3600+timebuf.tm_min*60+timebuf.tm_sec;
	 return(ltmp);

      case 1:
	 gtime(&timebuf);
	 return((long) timebuf.tm_mday);

      case 2:
	 gtime(&timebuf);
	 return((long) (timebuf.tm_mon+1));

      case 3:
	 gtime(&timebuf);
	 return((long) (timebuf.tm_year+1900));

      case 4:
#if	BB_X86		/* BB/X86 returns term# */
	 if (termno == -1L)
	    termno = (long) ttyslot();
	 return(termno);
#endif
#if	BB_PC		/* BB/PC returns constant 0 */
	 return(0);
#endif

      case 5:
	 times(&ptimes);
	 ltmp = (long) (ptimes.proc_user_time+ptimes.child_user_time)*10/HERTZ;
	 return((long) ltmp);

      case 7:
	 return((long) lasterrno);

      case 8:
	 return((long) lastfileno);

      case 9:
	 return((long) ust.pjobno);

      case 10:
	 return((long) ust.flag2);

      case 11:
	 return(globsw);

      case 12:
	 gtime(&timebuf);
	 return((long) timebuf.tm_sec);

      case 13:
	 gtime(&timebuf);
	 return((long) (timebuf.tm_min));

      case 14:
	 gtime(&timebuf);
	 return((long) (timebuf.tm_hour));


      case 16:
	 ltmp =  (long) ust.flag2<<15;
	 ltmp += (long) ust.noikey<<10;
	 ltmp += (long) ust.nomsgs<<6;
	 ltmp += (long) ust.nocolumns<<4;
	 ltmp += (long) ust.ctlchar<<2;
	 ltmp += (long) ust.lower<<1;
	 ltmp += (long) ust.noecho;
	 return(ltmp);

      case 17:
	 x = (unsigned)BFP;
	 y = (unsigned)begmem;
	 l = x - y;
	 l &= 0xffff;
	 return(l);

      case 18:
	 x = (unsigned)GFP->BSP.B;
	 y = (unsigned)BFP;
	 l = x - y;
	 l &= 0xffff;
	 return(l);

      case 19:
	 x = (unsigned)endmem;
	 y = (unsigned)begmem;
	 l = x - y;
	 l &= 0xffff;
	 return(l);

      case 20:
	 return(pctoline(sys20pc,0));

      case 22:
	 return((long) timeleft);

      case 23:
	 timebuf = *localtime(&ust.logintime);
	 ltmp = (long) timebuf.tm_hour*60+timebuf.tm_min;
	 if (timebuf.tm_sec >= 30)
	    ltmp += 1;
	 return((long) ltmp);

      case 24:
	 return((long) ust.pushcnt);

      case 25:
	 return(0L);

      case 26:
	 return((long) ust.stmtx.ikey);

      case 27:
	 gtime(&timebuf);
	 ltmp = (long) timebuf.tm_hour*10000+timebuf.tm_min*100+timebuf.tm_sec;
	 return(ltmp);

      case 28:
	 gtime(&timebuf);
	 ltmp = (long) (timebuf.tm_mon+1)*10000+timebuf.tm_mday*100
						  	       +timebuf.tm_year;
	 return(ltmp);

      case 29:
	 if (numfd == IDLE) {
		 if ((numfd = open(xnumfile, 2)) < 0) {
		    numfd = IDLE;
		    bberr(BENAC);
		 	}
	 	}
	 lseek(errfd,0L,0);
	 if (locking(numfd, LOCK, ALL) == -1)
	    bbxerrno();
	 lseek(numfd, 0L, 0);
	 read(numfd, specno.buff, 4);
	 swab(specno.buff, specno.buff, 4);
	 uniqueno = specno.lnum;
	 specno.lnum = uniqueno+1;
	 swab(specno.buff, specno.buff, 4);
	 lseek(numfd, 0L, 0);
	 write(numfd, specno.buff, 4);
	 lseek(numfd, 0L, 0);
	 locking(numfd, UNLOCK, ALL);
	 return(uniqueno);

      case 30:
	 return((long) penviron);

      case 31:
	 return((long) errno);

      default:
	 bberr(BEFAR);			/* all others get an error */

   } /* end-switch */

} /* end-sys */

gtime(bufptr)				/* fill in a time_buffer */
struct tm *bufptr;
{
   long clock;
   time(&clock);
   *bufptr = *localtime(&clock);
	} /* end-gtime */

