/*************************************************************************
*
*
*	Name:  strpos.c
*
*	Description:  POS function and STRPOS statement.
*
*
*	History:
*	Date		By		Comments
*
*	3/18/83	waf
*	04/05/83	mas		added inc to posj
*	4/20/83	waf	null search str = return '1'.
*	6/27/83		mas	added registers where possible
*
*
*
*  This document contains confidential/proprietary information.
*
*  Copyright 1983, 1984 by Digital Communications Assoc.
*
*************************************************************************
* BB/Xenix Runtime Module */




/*  Notes -



.SH */

#include	"/bb/include/ptype.h"

/*
			** POS function **
*/

posj( str1, str2, start, inc )

STRDES	str1, str2;
int	start,inc;
	{

	return( strsrch( str1, str2, (start - 1), inc ) + 1 );
	}


/* 
.SH
			** STRPOS statement **
*/

strpos( retvar, str1, str2, start, inc )

/* search str1 for occurance of str2 */

NUMDES	retvar;
STRDES	str1, str2;
int		start, inc;
	{

	putvj( &retvar, strsrch( str1, str2, (start-1), inc) + 1 );
	}


/* 
.SH
			* search string for match *
*/

strsrch( str1, str2, start, inc )

/**  search str1 for occurance of str2.
		Return pos of match or -1 if no match.  **/
/*		Note: uses c string conventions.
		e.g. $ starts at '0'  */

STRDES	str1, str2;
int		start, inc;

	{
	register char	*ptr1, *ptr2;
	int	flag, i;
	int	os;

	
	/** chk null str **/
	if ( str1.curlth == 0 )  return( -1 );		/* null target str */
	if ( str2.curlth == 0 )  return( 0 );		/* null search str */

	/** search str **/
	for ( os = start ; os < str1.curlth ; os += inc )
		{

		/** chk for #chars left in str1 <= #chars in str2 **/
		if ( (str1.curlth - os) < str2.curlth )
			return( -1 );

		/* compare strings */
		ptr1 = str1.data + os ;
		ptr2 = str2.data ;
		flag = TRUE;
		for ( i=0 ; i < str2.curlth ; i++, ptr1++, ptr2++ )
			{
			if ( *ptr1 != *ptr2 )
				{
				flag = FALSE;
				break;
				}
			}
		if ( flag == TRUE )  return( os );		/* found */
		}

	return( -1 );		/* not found */
	}
