
/*************************************************************************
*
*
*	Name:  stmc1.c
*
*	Description:  STMC 1 (.CDIR) statement.
*
*
*	History:
*	Date		By		Comments
*
*				mas
*	7/25/83	waf	Added BB/PC conditional code -
*						MSDOS specific mkdir() fn used to create dir.
*
*
*  This document contains confidential/proprietary information.
*
*  Copyright 1983, 1984 by Digital Communications Assoc.
*
*************************************************************************
* BB/Xenix Runtime Module */




/*  Notes -

 */

#include <sys/types.h>
#include <sys/stat.h>

#include "/bb/include/ptype.h"
#include "/bb/include/pextern.h"
#include "/bb/include/bberms.h"
#include "/bb/include/syerms.h"



/*************************************************************/
/*                                                           */
/*                          N O T E                          */
/*                          -------                          */
/*							     */
/*	This routine uses several section (3) items	     */
/*	which increase the size of the object module	     */
/*	significantly.                                       */
/*                                                           */
/*************************************************************/


stmc1 (err,dirname)

NUMDES	err;
STRDES	dirname;

{
   extern int errno;
   char dirnam1[129],buf[260];
   register int e;

   e = movdb(&dirname, dirnam1, 128);	/* copy dirname */


#if	BB_X86		/* BB/X86 uses system() call */
   buf[0]=0;				/* clear buffer string */
   strcat(buf,"mkdir ");strcat(buf,dirnam1);	/* compose command */
   strcat(buf," >&- 2>&-");		/* close stdout stderr */
   if ((e = system(buf)) != 0)		/* create dirname */
      e = ERCAN;			/* Failed - can't do it error */
   else {
      e = NOERC;			/* otherwise use NOERR */
   }
#endif

#if	BB_PC			/* BB/PC uses MSDOS specific mkdir() fn */
	if ( (e = mkdir(dirnam1)) == MSNOERR )
		e = NOERC;		/* no err */
	else
		e = ERCAN;		/* error */
#endif


   putvj(&err,-e);			/* return error flag */

} /* end-stmc1 */


