/*************************************************************************
*
*
*	Name:  stma20.c
*
*	Description:  STMA 20  statement.
*
*
*	History:
*	Date		By	Comments
*
*	6/27/83
*	10/27/83	waf	Use BBCHANS param.
*	10/28/83	waf	Use badchan()/badfchan() macros to chk legal channel #.
*
*
*
*  This document contains confidential/proprietary information.
*
*  Copyright (c) 1983, 1984 by Digital Communications Assoc.
*
*************************************************************************
* BB/Xenix Runtime Module */




/*  Notes -

*/

#include <sys/types.h>
#include <sys/stat.h>

#include "/bb/include/ptype.h"
#include "/bb/include/pextern.h"
#include "/bb/include/pdefine.h"
#include "/bb/include/bberms.h"
#include "/bb/include/syerms.h"

stma20 (channel)

int	channel;

{
	extern int errno;
	register int e,terr;

	if ( channel == -1 ) {
		close( ust.ulibfd );		/* No channel - close user library */
		ust.ulibfd = -1;			/* Clear user lib channel */
		} 

	else if ( badfchan(channel) )
		bberr(ERFNO);			/* Illegal File Number */
	
	else if ( ust.ftab[channel].opmode & RD_FM != RD_FM )
		bberr(BEWRM); 			/* Wrong Mode of Open */

	else {
		ust.ulibfd = ust.ftab[channel].xfd;	/* Set lib chan to user chan */
		ust.ftab[channel].xfd = -1;	/* Close user channel */
		lseek(ust.ulibfd, 0L, 0);	/* Position to beginning (frame size) */
		terr = read(ust.ulibfd, &ust.ulibhash, sizeof(int));	/* Read frame size */
		if ( terr == 0)
			bberr(EREOF);			/* End of file on read */
		else if ( terr < 0)
			bbxerrno();		/* Read error */
		swab((char *)&ust.ulibhash, (char *)&ust.ulibhash, sizeof(int));	/* Swap bytes */
		}

	} /* end-stma20 */
