
/*************************************************************************
*
*
*	Name: rename.c
*
*	Description:  rename a file
*
*
*	History:
*	Date		By		Comments
*
*	7/21/83	waf	Added conditional code for BB/PC.
*						Changed the P-machine's 'rename()' fn to 'brename()',
*						so as not to conflict with the new MSDOS 'rename()' fn.
*
*
*
*  This document contains confidential/proprietary information.
*
*  Copyright 1983, 1984 by Digital Communications Assoc.
*
*************************************************************************
* BB/Xenix Runtime Module */




/*  Notes -


*/

#include "/bb/include/bberms.h"
#include "/bb/include/ptype.h"

brename (err, oldfile, newfile)

/*
	synopsis -
		Rename 'oldfile' to 'newfile'.
		Used for RENAME statement and .RENAME stmc call.

	action -
		link() and unlink() are used by Xenix to rename a file.
		MSDOS uses the rename() function.

	return -
		return val	= <null>
		error status is returned in optional error variable 'err'. 
*/

NUMDES err;
STRDES oldfile, newfile;
{
   extern int errno;
   char ofilnam[129], nfilnam[129];
   int e;


	/** get filenames **/
   e = movdb(&oldfile, ofilnam, 128);		/* copy old filename */
   e = movdb(&newfile, nfilnam, 128);		/* copy new filename */


	/** rename file **/


#if	BB_X86		/* Xenix version uses link() & unlink() */
   if ((e = link(ofilnam, nfilnam)) != NOERR) {	/* add new file */
      e = errxlt(errno);			/* translate error */
		goto rnxit;
   }

   if (e = unlink(ofilnam))			/* remove old file */
      e = errxlt(errno);			/* translate if error */
   else
      e = NOERR;				/* otherwise use NOERR */
#endif


#if	BB_PC			/* PC vers. uses 'rename' system call */
	if ( (e = rename(ofilnam, nfilnam)) == MDNOERR )
		e = NOERR ;		/* no error */
	else
		e = errxlt(errno);
#endif


	rnxit:
	/** return error code **/
   errchk(&err, e);				/* check error */
	return;

} /* end-rename */
