/*************************************************************************
*
*
*	Name:  pruset, pruend & chkpru
*
*	Description:  set-up for and clean-up after print-using
*
*
*	History:
*	Date		By	Comments
*
*	03/09/83	WEB
*	06/16/83	mas	memory and speed squeeze
*	06/30/83	WEB	fix problem with zero suppress (O)
*
*
*
*  This document contains confidential/proprietary information.
*
*  Copyright 1983, 1984 by Digital Communications Assoc.
*
*************************************************************************
* BB/Xenix Runtime Module */




/*  Notes -

*/

#include "/bb/include/ptype.h"
#include "/bb/include/pextern.h"
#include "/bb/include/bberms.h"


char *pruset(sp)
POINTER sp;
{
   int channel, n;
   PRUDES pbuf;

   pbuf.prfmtdes = *--sp.S;		/* pop format descriptor */
   channel = *--sp.J;			/* pop channel number */

   iostat.iocount = 0;			/* initialize i/o structure */
   iostat.iopos = 0;
   iost.status = 0;
   for (n = 0; n < IOSIZE; n++)
      iobuf[n] = ' ';

   n = xlt2bchan(channel, &iostat.ofd);
   if (n == 0)
      bberr(BEWRM);			/* error if open-mode is wrong */
   if (n == 16)
      iostat.ofd = 1;			/* use stdout for channel 16 */

   					/* initialize PRINT-USING buffer */
   pbuf.prfmtptr = pbuf.prfmtdes.data;
   pbuf.prfmtend = pbuf.prfmtptr + pbuf.prfmtdes.curlth;
   pbuf.prioptr = iobuf;
   pbuf.prioend = pbuf.prioptr + IOSIZE;
   pbuf.proverwrite = ' ';
   pbuf.prfillchar = ' ';
   pbuf.prterminator = '\n';
   pbuf.prlastactive = iobuf;
   pbuf.przerosuppress = FALSE;
   pbuf.practivecount = 0;
   pbuf.prrptcnt = 0;
   pbuf.prrptptr = pbuf.prfmtptr;
   pbuf.prgrplevel = 0;			/* initialize repeat stack */
   pbuf.prgroup[0].prgrpcnt = INFINITY;
   pbuf.prgroup[0].prgrpptr = pbuf.prfmtptr;

   chkpru(&pbuf);			/* process literals, etc. */

   *(((PRUDES *) sp.B)++) = pbuf;	/* push buffer on stack */

   return(sp.B);			/* return updated stack pointer */

} /* end-pruset */

char *pruend(sp)			/* clean up after PRINT-USING */
POINTER sp;
{
   PRUDES pbuf;

   pbuf = *(--((PRUDES *) sp.B));	/* pop buffer off stack */

   *pbuf.prioptr = pbuf.prterminator;	/* set terminator */

					/* set character count */
   iostat.iocount = pbuf.prioptr - iobuf + 1;

   termout();				/* output print line */

   termflush();				/* flush i/o buffer */

   iostat.ofd = 1;			/* reset file-descriptor to stdout */

   return(sp.B);			/* return updated stack pointer */

} /* end-pruend */

getnum(pbuf, count)
PRUDES *pbuf;
int *count;
{
   int l = 0, s = 1;

   *count = 0;

   if (*pbuf->prfmtptr == '-') {	/* check sign */
      s = -1;
      pbuf->prfmtptr++;
   }

   while (*pbuf->prfmtptr >= '0' && *pbuf->prfmtptr <= '9'
				 && pbuf->prfmtptr < pbuf->prfmtend) {
      l = l * 10 + *pbuf->prfmtptr - '0';
      pbuf->prfmtptr++;
      (*count)++;
   }

   return(s*l);

} /* end-getnum */

char getfmt(pbuf)			/* get next format character */
PRUDES *pbuf;
{
      if (pbuf->prfmtptr >= pbuf->prfmtend)
	 bberr(BEIFS);			/* error if past end */

      return(*pbuf->prfmtptr++);

} /* end-getfmt */

pruskip(pbufx)				/* skip ' ' & ',' */
PRUDES *pbufx;
{
   register PRUDES *pbuf;

   pbuf = pbufx;

   while ((*pbuf->prfmtptr == ' ' || *pbuf->prfmtptr == ',')
				  && pbuf->prfmtptr < pbuf->prfmtend)
      pbuf->prfmtptr++;

} /* end-pruskip */

chkpru(pbufx)				/* process literals, etc. */
PRUDES *pbufx;
{
   register PRUDES *pbuf;
   register int num, count;
   char fmtchar, getfmt();

   pbuf = pbufx;

   if (pbuf->prrptcnt-- > 0) {		/* reset pointer if repeating */

      pbuf->prfmtptr = pbuf->prrptptr;

      pruskip(pbuf);			/* skip chaff */

   } else {

      pruskip(pbuf);			/* skip leading chaff */

      if (pbuf->prfmtptr >= pbuf->prfmtend)
	 return;			/* exit if nothing left in format */

      num = getnum(pbuf, &count);	/* get potential repeat count */

      pruskip(pbuf);			/* skip chaff again */

      if (pbuf->prfmtptr >= pbuf->prfmtend)
	 return;			/* exit if nothing left in format */

      if (count > 0) {

	 pbuf->prrptcnt = num - 1;	/* save count & pointer for repeat */

	 pbuf->prrptptr = pbuf->prfmtptr;

      } else

	 pbuf->prrptcnt = 0;		/* default is 0 */

   }

   fmtchar = *pbuf->prfmtptr;

   if (fmtchar != 'X')			/* all except X are only positive */
      pbuf->prrptcnt = abs(pbuf->prrptcnt);

   switch (fmtchar) {

      case '\'':			/* literal string */
					/* save i/o pointer as last active */
	 pbuf->prlastactive = pbuf->prioptr;

	 pbuf->prfmtptr++;		/* move over initial ' */

	 count = 0;

	 while (*pbuf->prfmtptr != '\'' &&
		 pbuf->prfmtptr < pbuf->prfmtend &&
		 pbuf->prioptr < pbuf->prioend) {
	    *pbuf->prioptr++ = *pbuf->prfmtptr++;
	    count++;
	 }

	 if (pbuf->prioptr >= pbuf->prioend)
	    bberr(BELTL);

	 if (pbuf->prfmtptr >= pbuf->prfmtend)
	    bberr(BEIFS);

	 pbuf->prfmtptr++;		/* move over final ' */

	 break;

      case 'Z':				/* end line with null */
	 pbuf->prterminator = '\0';

	 pbuf->prfmtptr++;		/* move over format */

	 break;

      case 'P':				/* end line with form-feed */
	 pbuf->prterminator = '\f';

	 pbuf->prfmtptr++;		/* move over format */

	 break;

      case 'O':				/* zero suppression */
	 pbuf->przerosuppress = TRUE;

	 pbuf->prfmtptr++;		/* move over format */

	 break;

      case 'X':				/* relative positioning */
	 num = pbuf->prrptcnt+1;	/* use repeat count with 1 added back */

	 pbuf->prrptcnt = 0;		/* reset repeat count to 0 */

	 pbuf->prioptr += num;		/* move i/o pointer */

	 if (pbuf->prioptr < iobuf || pbuf->prioptr > pbuf->prioend)
	    bberr(BELTL);		/* error if goes out of bounds */

	 pbuf->prfmtptr++;		/* move over format */

	 break;

      case 'T':				/* absolute positioning (tab) */
	 pbuf->prfmtptr++;		/* move over format */

	 num = abs(getnum(pbuf, &count));

	 if (count == 0)
	    num = 1;			/* default to 1 if no number */

	 if (num >= IOSIZE)
	    bberr(BEIFS);		/* error if goes out of bounds */

	 if (num == 0)			/* reset to last active field on T0 */
	    pbuf->prioptr = pbuf->prlastactive;
	 else
	    pbuf->prioptr = iobuf + num - 1;

	 break;

      case '(':				/* start grouping operator */
	 pbuf->prfmtptr++;		/* move over format */

					/* push a nesting level */
	 if (++pbuf->prgrplevel >= PRMAXLEVEL)
	    bberr(BEPRN);		/* error if nested too deeply */

	 pbuf->prgroup[pbuf->prgrplevel].prgrpcnt = pbuf->prrptcnt;
	 pbuf->prgroup[pbuf->prgrplevel].prgrpptr = pbuf->prfmtptr;

	 pbuf->prrptcnt = 0;		/* set non-group count to 0 */

	 break;

      case ')':				/* end grouping operator */
	 pbuf->prfmtptr++;		/* move over format */

	 if (pbuf->prgrplevel <= 0)
	       bberr(BEPRN);		/* error if too many ) */

					/* repeat current level ? */
	 if (pbuf->prgroup[pbuf->prgrplevel].prgrpcnt-- <= 0)
	    
	    pbuf->prgrplevel--;		/* no, pop a nesting level */

	 else
					/* yes, reset format pointer */
	    pbuf->prfmtptr = pbuf->prgroup[pbuf->prgrplevel].prgrpptr;

	 pbuf->prrptcnt = 0;		/* set non-group count to 0 */

	 break;

      case 'L':				/* format modifiers */
	 switch (*(pbuf->prfmtptr+1)) {	/* select sub-case */

	    case '7':			/* overwrite character */
	       pbuf->prfmtptr += 2;	/* move over format and digit */

	       if (*pbuf->prfmtptr == '_')
		  pbuf->prfmtptr++;	/* skip over underscore */

	       pbuf->proverwrite = getfmt(pbuf);

	       break;

	    case '8':			/* fill character */
	       pbuf->prfmtptr += 2;	/* move over format and digit */

	       if (*pbuf->prfmtptr == '_')
		  pbuf->prfmtptr++;	/* skip over underscore */

	       pbuf->prfillchar = getfmt(pbuf);

	       break;

	    default:
	       return;			/* others are handled elsewhere */

	 } /* end-switch */

	 break;

      default:				/* exit if no match */
	 return;
   
   } /* end-switch */

   chkpru(pbuf);			/* do it again in case there are more */

} /* end-chkpru */
