/*************************************************************************
*
*
*	Name:  pmach1.c
*
*	Description:  Executes p-codes with a lead-in code of 1
*
*
*	History:
*	Date		By	Comments
*
*	03/10/83	mas
*	05/09/83	mas	added call to phinc();
*
*
*
*  This document contains confidential/proprietary information.
*
*  Copyright 1983, 1984 by Digital Communications Assoc.
*
*************************************************************************
* BB/Xenix Runtime Module */




/*  Notes -

*/




#include "/bb/include/ptype.h"
#include "/bb/include/pextern.h"
#include "/bb/include/pfunc.h"
#include "/bb/include/bberms.h"
#include "/bb/include/opcodes.h"

#include "/bb/include/pcondcomp.h"

pmach1(pc,sp)
POINTER	pc,sp;
{

	STRDES	*sptr;
	PSTRDES	*psptr;
	ARRDES	*aptr;
register POINTER PC;
register POINTER SP;
	int	i;
	unsigned u;
	long	templ,templ1;

	PC = pc;
	SP = sp;

#ifdef PHIST
	phinc(*PC.B,1);
#endif

	switch (((*PC.B++)&0x00ff)+256) {
		case MAXL:
			--SP.L;
			if (*SP.L > *(SP.L-1))
				*(SP.L-1) = *SP.L;
			break;
		case MINL:
			--SP.L;
			if (*SP.L < *(SP.L-1))
				*(SP.L-1) = *SP.L;
			break;
		case MODL:
			--SP.L;
			*(SP.L-1) %= *SP.L;
		case ABSL:
			if (*--SP.L < 0)
				*SP.L = -*SP.L;
			++SP.L;
			break;
		case ABSJ:
			if (*--SP.J < 0)
				*SP.J = -*SP.J;
			++SP.J;
			break;
		case SGNL:
		/*	--SP.L; */
		/*	if (*SP.L > 0) */
		/*		*SP.J++ = 1; */
		/*	else if (*SP.L < 0) */
		/*		*SP.J++ = -1; */
		/*	else */
		/*		*SP.J++ = 0; */
			if (*--SP.L != 0) {
				if (*SP.J < 0)
					*SP.J = -1;
				else
					*SP.J = 1;
			}
			++SP.J;
			break;
		case SHFL:
			--SP.J;
			if (*SP.J > 0) {
				*(SP.L-1) <<= *SP.J;
				break;
			}
			if (*SP.J < 0) {
				*SP.J = -*SP.J;
				*(SP.L-1) >>= 1;
				(*SP.J)--;
				*(SP.L-1) &= 0x7fffffffL;
				while (*SP.J > 0) {
					*(SP.L-1) >>=1;
					(*SP.J)--;
				}
			}
			break;
		case SQRL:
			*SP.L++ = sqrl(*--SP.L);
			break;
		case RNDL:
			*SP.L++ = rndl(*--SP.L);
			break;
		case VALL:
			*SP.L++ = vall(*--SP.S,*--SP.N);
			break;
		case EXPJ:
			*SP.J++ = expj(*--SP.J,*--SP.J);
			break;
		case EXPL:
			*SP.L++ = expl(*--SP.L,*--SP.L);
			break;
		case ANDJ:
			--SP.J;
			*(SP.J-1) &= *SP.J;
			break;
		case ANDL:
			--SP.L;
			*(SP.L-1) &= *SP.L;
			break;
		case ORJ:
			--SP.J;
			*(SP.J-1) |= *SP.J;
			break;
		case ORL:
			--SP.L;
			*(SP.L-1) |= *SP.L;
			break;
		case XORJ:
			--SP.J;
			*(SP.J-1) ^= *SP.J;
			break;
		case XORL:
			--SP.L;
			*(SP.L-1) ^= *SP.L;
			break;
		case NOTJ:
			*SP.J++ = -1 ^ *--SP.J;
			break;
		case NOTL:
			*SP.L++ = -1 ^ *--SP.L;
			break;
		case ASCL:
			*SP.L++ = ascl(*--SP.S);
			break;
		case LENJ:
			--SP.S;
			*SP.J++ = SP.S->curlth;
			break;
		case SYSL:
			*SP.L++ = sys(*--SP.J);
			break;
		case STRJ:
			templ = (long)*--SP.J;
			*SP.L++ = templ;
		case STRL:
			strl(SP.S-1, *--SP.L);
			break;
		case CHRL:
			chrl(SP.S-1, *--SP.L, *--SP.J);
			break;
		case ERM:
			erm(SP.S-1, *--SP.L);
			break;
		case FILL:
			fill(SP.S-1, *--SP.J, *--SP.J);
			break;
		case TRUN:
			trun(SP.S-1, *--SP.S, *--SP.J);
			break;
		case GPOSL:
			*SP.L++ = gpos(*--SP.J);  /* get position */
			break;
		case EOFJ:
			*SP.J++ = eof(*--SP.J);	  /* test for eof */
			break;
		case POSJ:
			*SP.J++ = posj(*--SP.S,*--SP.S,*--SP.J,*--SP.J);
			break;
		case CRM:
			crma(SP.S-1,*--SP.S);
			break;
		case UCM:
			ucma(SP.S-1,*--SP.S);
			break;
		default:
			panic();
	}
	TPC = PC.B;
	TSP = SP.B;
	return;
}
