/*************************************************************************
*
*
*	Name:  openpc.c
*
*	Description:  Opens the pcode file and positions to it if in .pl
*
*
*	History:
*	Date		By	Comments
*
*	04/13/83	mas
*	05/16/83	mas	added routine to drop .bp extension
*	05/18/83	mas	added routine to drop trailing spaces and
*				control characters
*	05/20/83	mas	added call to chkpath to search BBPATH for 
*				the pcode file
*	06/06/83	mas	changed to always try current directory with
*				no links first on pcode files not in program 
*				library
*	06/15/83	mas	changed to leave a sector for the header so
*				that the buckets start on sector boundaries
*	07/12/83	mas	changed to compute hash frame same using 
*				16 bit words instead of characters
*	04/10/84	waf		Fixed bug in bucket # calculation.
*						Fixed bug in pgm name buffer allocation.
*
*
*
*  This document contains confidential/proprietary information.
*
*  Copyright 1983, 1984 by Digital Communications Assoc.
*
*************************************************************************
* BB/Xenix Runtime Module */




/*  Notes -

*/


#include "/bb/include/ptype.h"
#include "/bb/include/pextern.h"
#include "/bb/include/syerms.h"

#define BUCKCNT 	32
#define BUCKSTART 	512L
#define	MAXPGMC		10		/* max # chars in pgm root name */
#define	HBSIZE		(MAXPGMC+1)	/* pgm name buffer size */

extern int errno;

openpc(name)
char	*name;
{
register int	i;
	int	fd;
	char	*cptr,pname[PATHSIZE],hbuf[HBSIZE];
register unsigned u;
	unsigned hash;
	PLHEADER plh;
	PLENT	plbuck[BUCKCNT];	/* BUCKCNT entries per bucket */
	long	l,plpos,*lptr,lseek();

	bpscan(name);		/* throw away .bp extension */

	if (name[0] != '#' && name[0] != '%')
		return(openpx(name));

	if (name[0] == '#') {
		fd = ust.slibfd;
		hash = ust.slibhash;
	} else {
		fd = ust.ulibfd;
		hash = ust.ulibhash;
	}

	if (fd == IDLE)
		return(openpx(name+1));

	lseek(fd,0L,0);
	if (read(fd,&plh,sizeof(PLHEADER)) < 0)
		return(openpx(name+1));

	swab((char *)&plh,(char *)&plh,sizeof(PLHEADER));
		
	plpos = lseek(fd,BUCKSTART,0);	/* seek to buckets */

	for (i=0; i<HBSIZE; ++i)
		hbuf[i] = '\0';
	strcpy(hbuf,name+1);
	swab(hbuf,hbuf,MAXPGMC);	/* convert for numeric uses */
	for (i=0, u=0; i<MAXPGMC; i += 2)
		u += *((unsigned *)&hbuf[i]);
	u %= hash;

	/* l = plpos + (long)(u * sizeof(plbuck));	<<< 4/10/84 */
	l = (long) u * (long) sizeof(plbuck) ;
	l += plpos ;

	lseek(fd,l,0);	/* seek to bucket */
	if (read(fd, (char *)&plbuck, sizeof(plbuck)) < 0)
		return(openpx(name+1));

	for(i = 0; i < plh.entrycnt; ++i) {
		cptr = plbuck[i].plname;
		if (*cptr == '\0')
			continue;
		if (strcmp(name+1,cptr) == 0) {
			lptr = &plbuck[i].plloc;
			swab((char *)lptr,(char *)lptr,sizeof(long));
			lseek(fd,plbuck[i].plloc,0);	/* seek to it */
			return(fd);	/* return fd */
		}
	}
	/* not found */
	return(openpx(name+1));
}


openpx(name)
char	*name;
{
	char	pname[PATHSIZE];
	char	pname1[PATHSIZE];
	int	e;

	strcpy(pname,name);
	strcat(pname,".bp");

	if ((e = open(pname,0)) >= 0)	/* try current directory no links */
		return(e);

	if ((e = chkpath(pname,pname1)) != 0)
		bberr(e);
	return(open(pname1,0));
}

bpscan(name)
char	*name;
{
	register int	i;
	register char	*cptr;

	spscan(name);

	i = strlen(name);	/* set i to null at end of string */
	if (i == 0)
		return;

	cptr = &name[--i];	/* point to last character */

	for (; *cptr != '.' && cptr > name; --cptr)
		;		/* scan back to period */

	if (cptr == name)
		return;
	
	if (strcmp(cptr,".bp") == 0)
		*cptr = '\0';	/* null terminate at period */
	
	return;
}


spscan(name)
char	*name;
{
	register int	i;
	register char	*cptr;

	i = strlen(name);	/* set i to null at end of string */
	if (i == 0)
		return;

	cptr = &name[--i];	/* point to last character */

	for (; *cptr <= ' ' && cptr > name; --cptr)
		;		/* scan back past junk */

	*(++cptr) = '\0';	/* null terminate */
	
	return;
}
