/*************************************************************************
*
*
*	Name:  ikeyz.c
*
*	Description:	ikeyz() - 
*			Check Global Frame for IKEY vector and return new PC
*			if found. Otherwise print IKEY message and exit
*			Also used to find next statement during input. (mode 1)
*
*			dostmt() -  Checks for ikey and/or trace bit set
*
*
*
*	History:
*	Date		By	Comments
*
*	03/02/83	mas
*	03/10/83	mas	Reset iostat.ifd/ofd to standard i/o
*	05/06/83	mas	Changed to not make a .pm file on ikey
*	05/12/83	mas	changed to call wline w/character pointer
*				using new wline
*	05/16/83	mas	removed unused automatics and used registers
*				where possible
*	08/12/83	waf		Do not reset IKEY vector when handling ikey.
*	09/19/83	waf		Set pcint to value of PC on entry to ikeyz().
*	11/07/83	waf		Put 'beep' in ikey message.
*
*
*
*  This document contains confidential/proprietary information.
*
*  Copyright (c) 1983, 1984 by Digital Communications Assoc.
*
*************************************************************************
* BB/Xenix Runtime Module */




/*  Notes -

09/19/83	waf
	Previously, pcint was set to the value of 'pclast' in the ikeyz() fn.
  (pcint is used to find the stmt at which to continue execution after int
  handler code is executed. It is used by RETINT via the nextstmt() fn.)
	This is fine if the previous stmt did not allow interrups (e.g. valikey
  was FALSE) since pclast is the addr of the beginning of the current stmt.
  However, if the last stmt allowed interrupts (e.g. valikey was TRUE),
  assigning the value of pclast to pcint will cause the stmt which was 
  ikey'ed to be RE-executed.
	To fix this, pcint is assigned the address of the p-code CURRENTLY BEING
  executed. This will be the address of the beginning of the stmt if ikeyz()
  is invoked by dostmt(), else it will be the address of some p-code in the
  body of the stmt if ikeyz() is invoked by the ikey handler code.
	RETINT will resume execution at the current stmt in the former case,
  and at the next stmt in the latter case.

*/

#include "/bb/include/ptype.h"
#include "/bb/include/pextern.h"

extern long pctoline();

dostmt(PC,SP)
POINTER	PC,SP;
{
	TPC = PC.B;
	TSP = SP.B;

	if (ust.stxfl.ikey == TRUE && ust.noikey == FALSE) {
		ikeyz(PC,SP);
		return;
		}

	if (ust.stxfl.debug == TRUE) {
		ust.stxfl.debug = FALSE;
		pbreak(PC,SP);
		} 
	else
		if (ust.stxfl.singstep == TRUE)
			pbreak(PC,SP);

	if (ust.stxfl.trace == TRUE)
		ptrace();

	return;
	}


ikeyz(PC,SP)
POINTER	PC,SP;
{
	register struct	GFRAME *gfp;

	ust.stxfl.ikey = FALSE;

	termflush();	/* flush terminal buffer */

	/* reset iostat.ifd/ofd */
	iostat.ifd = 0;		/* set to standard input */
	iostat.ofd = 1;		/* set to standard output */

	/*> sys20pc = pcint = pclast;	/* save pc for RETINT  9/19 waf */
	pcint = PC.B - 1 ;		/* save pc of current p-code for RETINT */
	sys20pc = pclast ;		/* save pc of current stmt for IKEY stmt# */

	SP.B = TSP = GFP->BSP.B;
	FP.B = (char *)GFP;

	gfp = GFP;
	while (gfp->INTVEC.B == (char *)-1)
		gfp = (struct GFRAME *)gfp->SGFP.B;

	if (gfp->INTVEC.B != (char *)-2) {
		TPC = gfp->INTVEC.B;		/* get new pc */
		/***	gfp->INTVEC.B = (char *)-1;	/* reset int vector */
		return;				/* return new pc */
		}

	iostat.iocount = 0;
	iocpy("\7\nIKEY AT ",10);
	wline(pclast);
	iocpy("\n",1);
	termout();
	termflush();

	if (pmdsw == TRUE && debugsw == TRUE) {
		pcheader.dikey = TRUE;
		pcheader.dbreak = FALSE;
		pcheader.derror = FALSE;
		pbreak(PC,SP);
		return;
		}

	pend();		/* swap back if possible */
	return;
	}

