/*************************************************************************
*
*
*	Name:  framinit.c
*
*	Description:  Initializes the global frames
*
*
*	History:
*	Date		By	Comments
*
*	03/01/83	mas
*	05/16/83	mas	removed unused automatics and used registers
*				where possible
*	
*
*
*
*  This document contains confidential/proprietary information.
*
*  Copyright 1983, 1984 by Digital Communications Assoc.
*
*************************************************************************
* BB/Xenix Runtime Module */




/*  Notes -

*/


#include "/bb/include/ptype.h"
#include "/bb/include/pextern.h"

char *framinit(SP)
POINTER	SP;
{
register struct GFRAME	*gfp;
register struct SFRAME	*bfp;
	char	*cptr;
	int	i;

	bfp = (struct SFRAME *)SP.B;

	bfp->PCD.B  = 0;
	bfp->FPD.B  = 0;
	bfp->GFPD.B = 0;
	bfp->IFPD.B = 0;
	bfp->SERRVEC.B = (char *)-2;
	bfp->SINTVEC.B = (char *)-2;

	gfp = (struct GFRAME *)(bfp + 1);

	FP.B = (char *)gfp;	/* set FP and gfp to global frame */

	for (i=0, cptr = (char *)gfp; i < sizeof(struct GFRAMEA); ++i) 
		*cptr++ = 0;		/* clear frame+gosub/for/next desc*/

	gfp->SPC.B  = begmem;
	gfp->SFP.B  = SP.B;
	gfp->SGFP.B = (char *)bfp;
	gfp->ERRVEC.B = (char *)-1;
	gfp->INTVEC.B = (char *)-1;
	gfp->BSP.B = (char *)gfp + pcheader.stksiz;

	GFP = gfp;		/* set real GFP after setting err+int vecs */
	BFP = bfp;		/* set real BFP */

	return((char *)(gfp+1));
}
