/*************************************************************************
*
*
*	Name:  expl.c
*
*	Description:  Returns arg1 raised to arg2 power
*
*
*	History:
*	Date		By	Comments
*
*	03/09/83	mas
*	04/27/83	mas	added expj routine which calls expl
*	05/16/83	mas	removed unused automatics and used registers
*				where possible
*	06/16/83	mas	memory and speed squeeze
*
*
*
*  This document contains confidential/proprietary information.
*
*  Copyright 1983, 1984 by Digital Communications Assoc.
*
*************************************************************************
* BB/Xenix Runtime Module */




/*  Notes -

*/


#include "/bb/include/bberms.h"

expj(arg1,arg2)
int	arg1,arg2;
{
	long	expl();

	return( (int) (expl( (long) arg1, (long) arg2) ) );
}

long expl(arg1,arg2)
long	arg1,arg2;
{
	long	l;
	long	result;
register int	sign;

	/* set sign */
	if (arg1 < 0 && arg2 % 2 == 1)
		sign = -1;
	else
		sign = 1;

	/* get absolute value of arg1 */
	if (arg1 < 0)
		arg1 = -arg1;

	/* eliminate obvious cases */
	if (arg1 == 0 && arg2 == 0)
		bberr(BEARI);

	if (arg1 == 1)
		return(sign);

	if (arg2 == 0)
		return(1);

	if (arg2 < 0)
		return(0);

	if (arg2 > 32)
		bberr(BEARI);

	if (arg2 == 1)
		return(sign*arg1);

	if (arg1 == 2)
		return((1 << arg2) * sign);
	
	/* multiply it out */
	for (result = 1;;) {
		if (arg2 % 2 == 1) {
			l = result * arg1;
			if (l / result != arg1) {
				bberr(BEARI); /* mult will overflow */
			}else
				result = l;
		}
		arg2 >>= 1;
		if (arg2 == 0)
			break;

		if ((arg1 & ~0x7fff) != 0) {
			bberr(BEARI);	/* squaring will overflow */
		}else
			arg1 *= arg1;
	}
	return(sign * result);
}
