/*************************************************************************
*
*
*	Name:  errz.c
*
*	Description:	errz() - traces back through the GFP's looking
*			for the PC for any user error routine. If one
*			is not found it prints the error message and the
*			line number in error
*
*
*	History:
*	Date		By	Comments
*
*	03/01/83	mas	
*	03/10/83	mas		Made errors reset iostat.ofd/ifd
*	04/13/83	mas		Changed to check for negative errors
*					and readjust them. see bberr().
*	04/24/83	mas		changed to turn off pmdsw in case of an error
*					during pmdump or pbreak
*	05/12/83	mas		changed to call wline w/character pointer using
*					new wline.
*	05/16/83	mas		removed unused automatics and used registers
*					where possible.
*	06/22/83	mas		changed to close errfd and numfd on error
*	09/02/83	waf		Return status code SYSER_XIT to pexit() if BESYS error.
*	09/19/83	waf		Assign (pclast+1) to pcerr.
*	11/7/83		waf		Output 'beep' (\07) in error msg.
*	11/10/83	waf		If panic (BESYS error), dump addr of panic & TPC.
*	12/02/83	waf		Panic if GFP = 0. 
*
*
*
*  This document contains confidential/proprietary information.
*
*  Copyright (c) 1983, 1984 by Digital Communications Assoc.
*
*************************************************************************
* BB/Xenix Runtime Module */



/*  Notes -

09/19/83	waf
	Previously, pcerr was assigned the value of pclast (the address of the
  beginning of the stmt) in errz(). This caused the error stmt to be re-
  executed after return from error handler code (because nextstmt(), which
  is used by RETERR, no longer skips unconditionally to the next stmt).
	I would like to assign (PC.B - 1) to pcerr, which would be the addr of
  the p-code being executed, but the PC value passed into errz() by the
  setjmp() code in pmach.c will always be '0'. 
	Instead, the value (pclast+1) is used. This is the addr of the 2nd p-code
  in the current stmt. The fn nextstmt(pclast+1) will always return the addr
  of the next stmt.

11/10/83	waf
	If error code = BESYS, a panic() is assumed to have happened, and 'panicpc'
  is assumed to contain the ret addr of the code which called panic().
  This addr and the value of the threaded program counter are dumped after
  the error message.
  (Note that BESYS can not be trapped by user).


.SH*/

#include "/bb/include/ptype.h"
#include "/bb/include/bberms.h"
#include "/bb/include/pextern.h"
#include "/bb/include/pexit.h"

extern int	panicpc;	/* pc of panic(), saved by panic() */

errz (bberrno,PC,SP)
int	bberrno;
POINTER	PC,SP;
{
	char	nbuf[32],mbuf[65];
	register int	erno;
	register struct	GFRAME *gfp;

	valikey = FALSE;	/* in case it was set when the error occurred*/
	termflush();		/* flush terminal buffer */

	/* reset iostat.ofd/ifd */
	iostat.ifd = 0;		/* set to standard input */
	iostat.ofd = 1;		/* set to standard output */

	if (bberrno < 0)
		++bberrno;	/* readjust negative errs */

	lasterrno = bberrno;

	/*> sys20pc = pcerr = pclast;  /* set pcerr for RETERR  9/19 waf*/
	sys20pc = pclast ;		/* save addr of current stmt for sys(20) */
	pcerr = pclast + 1 ;	/* save 'addr of current p-code' for RETERR */

	/* reset the stack and frame pointer */
	SP.B = TSP = GFP->BSP.B;
	FP.B = (char *)GFP;


	/** chk for error vector **/
	if ( bberrno != BESYS ) {		/* can't trap BESYS error */
		if ( GFP == 0 )
			panic();	/* GFP should always be set to something */
		gfp = GFP;
		while (gfp->ERRVEC.B == (char *)-1)
			gfp = (struct GFRAME *)(gfp->SGFP.B);
		if ( gfp->ERRVEC.B != (char *)-2 ) {
			TPC = gfp->ERRVEC.B;	/* get error vector */
			gfp->ERRVEC.B = (char *)-1;	/* reset error vector */
			return; 		/* return new PC */
			}
		}


	/** Show error message **/

	/* show /n and beep */
	iostat.iocount = 0 ;
	iocpy("\n",1);
	iocpy( "\7", 1 );	/* 'beep' */

	if (bberrno < 0) {
		iocpy("SYSTEM ",7);
		erno = -bberrno;
		} 
	else
		erno = bberrno;
	iocpy("ERROR ",6);

	/* show error # */
	cbdl(nbuf,(long)erno,0);
	iocpy(nbuf,strlen(nbuf));

	/* show line# */
	iocpy(" AT ",4);
	wline(pcerr);
	iocpy(" ",1);

	/* show error msg */
	mbuf[64] = '\0';
	germ(mbuf,(long)bberrno);	/* get error message */
	iocpy(mbuf,strlen(mbuf));

	/* display it */
	iocpy("\n",1);
	termout(); termflush();		/* display error message */

	/* if BESYS, dump trap info */
	if ( bberrno == BESYS ) {

		/* show caller's ret addr (saved in 'panicpc') */
		strcpy( mbuf, "pc =" );
		cbdl( mbuf+strlen(mbuf), (long)panicpc, 1 );

		/* show threaded pgm cntr */
		strcat( mbuf, ", tpc os =" );
		cbdl( mbuf+strlen(mbuf), (long)(TPC - begmem), 1 );

		/* show it */
		iocpy( mbuf, strlen(mbuf) );
		iocpy("\n", 1);
		termout(); termflush();
		}


	PC.B = pcerr;		/* set PC to where error occurred */

	close(errfd);		/* close error and number file */
	errfd = IDLE;
	close(numfd);
	numfd = IDLE;

	if (pmdsw == TRUE) {
		pcheader.derror = TRUE;
		pcheader.dikey = FALSE;
		pcheader.dbreak = FALSE;
		pmdsw = FALSE;
		if (debugsw == TRUE) {
			pbreak(PC,SP);
			pmdsw = TRUE;
			return;
			} 
		else {
			pmdump(PC,SP,1);	/* do pmd */
			}
		pmdsw = TRUE;
		}

	if (bberrno != BESYS)
		pend();
	else {
		pexit(SYSER_XIT);		/* abort */
		}

	}
