/*************************************************************************
*
*
*	Name:  errchk.c
*
*	Description:
*			errxlt() - Translate system specific error to RDOS equivalent
*			errchk() - Checks to see if the numeric descriptor
*				passed is valid, if it is then it puts the error number
*				in it. Otherwise it forces an error to be captured
*				by the user. 
*			errxechk() - Translate error code in 'errno', then do errchk().
*
*
*	History:
*	Date		By		Comments
*
*	03/01/83	mas
*	07/22/83	waf		Use global var 'extblsiz' for error table size check.
*	11/10/83	waf		Panic if bad value of erno.
*	11/16/83	waf		Added errxechk().
*
*
*
*  This document contains confidential/proprietary information.
*
*  Copyright (c) 1983, 1984 by Digital Communications Assoc.
*
*************************************************************************
* BB/Xenix Runtime Module */




/*  Notes -


.SH*/

#include "/bb/include/ptype.h"
#include "/bb/include/pextern.h"
#include "/bb/include/syerms.h"
#include "/bb/include/bberms.h"

extern	int	errxtbl[];		/* error code xlat table for this sys */
extern	int	extblsiz;		/* size of error xlat table for this sys */


errxlt (erno)
int	erno;
{
	if ( (unsigned)erno > extblsiz )
		panic();		/* bad erno */

	return(errxtbl[erno]);
	}


errchk (numdesc,bberrno)

/*	Check for valid numeric descriptor to capture error
	if not valid do bberr()
*/
NUMDES	*numdesc;
int	bberrno;
{
	putvj(numdesc,bberrno);

	if (bberrno == NOERR)
		return;

	if (isvar(numdesc) == FALSE)
		bberr(bberrno);
	}

errxechk ( evptr )

/* Translate code in errno, then do errchk().
*/

NUMDES	*evptr;		/* ptr to err var desc */
{
	errchk( evptr, errxlt(errno) );
	}
