/*************************************************************************
*
*
*	Name:  break.c
*
*	Description:  Performs the BREAK p-code
*
*
*	History:
*	Date		By	Comments
*
*	03/23/83	mas
*	06/29/83	mas	changed to call bwait instead of wait
*					bwait handles interrupts 
*	07/14/83	mas	wait until the debugger dies before 
*					continuing
*	07/28/83	mas	changed to use pushstack for location in
*					push file
*	08/01/83	waf	Added conditional code for BB/PC.
*					BREAK stmt not supported - BEOPT error if executed.
*	09/02/83	waf	Return NORM_XIT exit status in pexit() call.
*	07/03/84	waf		M000: Use pushfd instead of literal '3' for push fd.
*
*
*
*  This document contains confidential/proprietary information.
*
*  Copyright 1983, 1984 by Digital Communications Assoc.
*
*************************************************************************
* BB/Xenix Runtime Module */




/*  Notes -

09/02/83	waf
  If the pmach is exited due to an 'ABORT' debugger command, the return
  status code is defined (arbitrarily) to be NORM_XIT.


*/

#include "/bb/include/ptype.h"
#include "/bb/include/pextern.h"
#include "/bb/include/bberms.h"
#include <signal.h>
#include "/bb/include/pexit.h"

extern	int	errno;
extern	long	lseek();

pbreak(PC,SP)
POINTER	PC,SP;
{
	int	i,pid,savdump,savdeb;
	long	l;
	int	(*savsig1)();
	int	(*savsig2)();
	int	(*savsig3)();


#if	BB_PC			/* BREAK not supported in BB/PC */

	bberr( BEOPT );

#endif


#if	BB_X86		/* BREAK stmt = execute debugger */

	l = pushstk[ust.pushcnt];		/* get push location */

	if (lseek(pushfd,l,0) < 0)		/* M000: */
		bberr(BESWP);				/* seek in push file */

	pcheader.dbreak = TRUE;			/* set up header for break */
	pcheader.derror = FALSE;
	pcheader.dikey  = FALSE;

	savdump = pmdsw;			/* save current dump setting */
	pmdump(PC,SP,2);			/* dump push with UST */
	pmdsw = savdump;			/* reset switch back */

	if (lseek(pushfd,l,0) < 0)	/* M000: */
		bberr(BESWP);			/* seek back in push file */

	savsig1 = signal(SIGINT,SIG_IGN); /* ignore ints */
	savsig2 = signal(SIGQUIT,SIG_DFL);
	savsig3 = signal(SIGALRM,SIG_IGN);

	pid = fork();				/* fork off process */

	if (pid == 0) {				/* is this the child? */
		termreset();			/* turn echo and stuff on */
		execl(xdebugger,xdebugger,0); 	/* yes - execute debugger */
		}

	while (bwait() != pid)		/* wait for debugger process to die*/
		;

	terminit();			/* re-init terminal after debugger */
	signal(SIGINT,savsig1); 	/* reset ints */
	signal(SIGQUIT,savsig2);
	signal(SIGALRM,savsig3);

	savdeb = debugsw;		/* save current debugsw setting */
	debugsw = FALSE;		/* prevent any more attempts to debug*/

	if (lseek(pushfd,l,0) < 0)	/* M000: */
		bberr(BESWP);		/* seek back in push file */

	/* read in the header
	   and global mem from header */
	readhd(pushfd);			/* M000: */

	if (lseek(pushfd,l,0) < 0)	/* M000: */
		bberr(BESWP);		/* seek back in push file */

	/* load pcode,line table,UST,stack */
	loadpc(pushfd,begmem);	/* M000: */

	debugsw = savdeb;		/* put debugsw back */

	if(pcheader.dpmdump == TRUE)	/* user requested pmd */
		pmdump(pcheader.pc,pcheader.sp,1);

	if(pcheader.dabortp == TRUE)
		pexit(NORM_XIT);		/* exit p-machine */

	if(pcheader.dabort == TRUE)	/* swap back to next lower program*/
		pend();
	else
		TPC = pcheader.pc.B;	/* continue where we stopped */

	TSP = pcheader.sp.B;		/* get SP */

	ust.stmtx.sxflag = pcheader.pcstmtx.sxflag;

#endif


	return;
	}

