/*************************************************************************
*
*
*	Name:  blockio.c
*
*	Description:	block i/o - str and array to file and common.
*					( blkrd, blkwr, blkrdd & blkwrd )
*
*
*	History:
*	Date		By	Comments
*
*	03/21/83    WEB	read & write of strs only
*	04/06/83	WEB	added array support
*	06/16/83	mas	memory and speed squeeze
*	10/06/83	waf	** Re-write -
*					Optimize code & combine str/array code.
*					Chk for error/ikey in read()/write() calls.
*					Use fills() for fills.
*	02/21/84	waf		New ioerr() functionality - must handle return.
*	03/13/84	waf		EOF bug fix - see notes.
*
*
*  This document contains confidential/proprietary information.
*
*  Copyright 1983, 1984 by Digital Communications Assoc.
*
*************************************************************************
* BB/Xenix Runtime Module */




/*  Notes -

Implementation notes -

  For string block io, only the maxlth and data ptr of the STACK descriptor
are used to determine how much to transfer and where to start.
This means that curlth info is ignored (e.g. may write garbage)
and that sub-strings can be used.
  If a block read hits EOF, the data not read in is padded with 0's.

  Blk reads and writes to file and common are swab'ed.

  Note that, if a read from a char device is ikey'ed, the results of the i/o
are undefined. For reads, the input data may be corrupted.

Modification Notes -

03/13/84	waf		EOF bug -
  Previously, whether or not EOF was hit during a read, the string var was
updated as if all all requested data had been read in. This was fixed so
that only the size of the data actually read in (in blocks, where the last,
partially filled, block is null filled), is used to determine the current
length of the target string.
  NOTE - there is still some question about whether the string length is
being correctly updated. The interpreter code does not call updcl(), it
operates on the parent descriptor directly (?).

*/


#include "/bb/include/ptype.h"
#include "/bb/include/pextern.h"
#include "/bb/include/bberms.h"
#include "/bb/include/syerms.h"
extern long lseek();


		/***  Block Read  ***/

blkrd (channel, blockno, str)		/**  Block Read into string  **/
int		channel;
long	blockno;
STRDES	str;
{
	blkread(channel, blockno, &str, STRING);
	}

blkrdd ( channel, blockno, array )	/**  Block Read into array  **/
int		channel;
long	blockno;
ARRDES	*array;
{
	blkread(channel, blockno, array, NUMERIC);
	}


static blkread ( chan, blkno, dptr, type )		/**  Generic block read  **/

int		chan;
long	blkno;
char	*dptr;		/* ptr to desc (str or array) */
int		type;		/* data type */
{
	register int	dasize;	/* size of data area */
	register int	n;
	char	*bptr;			/* ptr to data area */
	int		fd;

	/* get data area size */
	dasize = getdpar(dptr, &bptr, type);

	/* read it */
	if (chan == 16) {

		/**  read from common  **/
		n = 512 ;		/* common = 512 bytes */
		if ( type == STRING )
			movs(ust.common, bptr, n);
		else
			swab(ust.common, bptr, n);
		}

	else {

		/**  read from file  **/
		/* set up for read */
		if ( xlt2bchan(chan, &fd) == 1 )	/* get fd & chk write-only */
			bberr(BEWRM); 		/* write-only mode */
		lastfileno = chan;			/* save channel of last i/o */
		if (lseek(fd, blkno<<9, 0) < 0L)	/* position to blockno */
			bberr(ERSCP);

		/* read the file until EOF or len bytes read in */
		n = read(fd, bptr, dasize);
		if ( n < 0 ) {
			/* i/o error */
			ioerr() ;		/* report error / chk EINTR */
			return ;		/* EINTR error - abort the read */
			}
		else if (n != dasize) {
			/* EOF */
			/* set EOF flag */
			ust.ftab[chan].opmode |= EOF_FS;
			/* null fill rest of last block */
			fills((bptr+n), ((dasize-n)&511), 0);
			/* adjust dasize to # of blks read before EOF hit
			   (including partially filled last block) */
			dasize = n & (~511) ;	/* # full blks before EOF hit */
			if ( (n & 511) != 0 )	/* if EOF was within a block... */
				dasize += 512 ;		/*   count the partial block */
			}

		/* swab numeric */
		if ( type != STRING ) {
			swab(bptr, bptr, dasize);
			}
		}

	/* update string desc */
	if ( type == STRING ) {
		dptr->maxlth -= dasize ;
		dptr->data += dasize ;
		updcl(dptr);
		}
	}


		/***  Block Write  ***/


blkwr (channel, blockno, str)		/**  Block Write from string  **/
int		channel;
long	blockno;
STRDES	str;
{
	blkwrite(channel, blockno, &str, STRING);
	}

blkwrd ( channel, blockno, array )	/**  Block Write from array  **/
int		channel;
long	blockno;
ARRDES	*array;
{
	blkwrite(channel, blockno, array, NUMERIC);
	}

static blkwrite ( chan, blockno, dptr, type )	/** Generic Block Write **/

int		chan;			/* chan# */
long	blockno;		/* block# */
char	*dptr ;			/* str/array desc ptr */
int		type ;			/* str/array type */
{
	register int	dasize;
	register int	n;
	char	*bptr;
	int		fd;
	char	sbuf[512];		/* tmp buffer for swab'ing */

	/* get dasize and data ptr */
	dasize = getdpar(dptr, &bptr, type);

	/* write it */
	if (chan == 16)

		/** write to common **/
		if ( type == STRING )
			movs(bptr, ust.common, 512);
		else
			swab(bptr, ust.common, 512);

	else {

		/** write to file **/
		/* set up for write */
		wrset(chan);				/* check & set for writing */
		xltbchan(chan, &fd);			/* get file-descriptor */
		if (lseek(fd, blockno<<9, 0) < 0L)
			bberr(ERSCP);				/* position to blockno */

		if ( type == STRING ) {

			/* write string */
			if ( write(fd, bptr, dasize) < 0 ) {
				ioerr() ;		/* report error */
				return ;		/* EINTR error - abort */
				}
			}
		else {

			/* swab & write numeric */
			n = 512 ;		/* block size */
			while ( dasize > 0 ) {
				swab(bptr, sbuf, n);
				if ( write(fd, sbuf, n) < 0 ) {
					ioerr() ;		/* report error / chk EINTR */
					return ;		/* EINTR error - abort */
					}
				dasize -= n ;		/* dec dasize by 1 block */
				bptr += n ;			/* inc data ptr to next block */
				}
			}
		}
	}

static	getdpar ( dptr, ptradr, type )

/* get data ptr and data area size from string/array desc.
	Sets ptradr to data ptr and returns data area size. */

char	*dptr;		/* string/array desc addr */
char	**ptradr;	/* addr of data ptr var */
{
	register int	dasize;

	/* get dasize = (# bytes to be written) */
	dasize = (type==STRING)? (dptr->maxlth) : (dptr->amaxsiz);
	dasize &= (~511) ;		/* make even block size */
	if ( dasize == 0 )
		bberr(BEBIO);	/* must be at least 512 bytes */

	/* get data addr */
	*ptradr = (type==STRING)?
		(char *)(dptr->data) : (char *)(dptr->adata.l);

	return(dasize);
	}
