/*************************************************************************
*
*
*	Name:  debstmt.c
*
*	Description:  Debugger - stmt reference routines.
*
*
*	History:
*	Date		By		Comments
*
*	5/2/83		waf
*	5/23/83		waf		tostmt() (offset to stmt#) -
*					Any offset from os of stmt up to (os of next stmt) - 1
*					returns stmt# of 'stmt'.
*	7/20/83		waf		tostmt() - Fixed bug which returned bad if 1st stmt
*					in src program did not have stmt number (added initline()).
*	11/03/83	waf		stmt_os() - Allow '@'<offset> in stmt#.
*						stmt_os() - Inc scanner to token following <stmt#>.
*	11/04/83	waf		stmt_os() - Return meaningful ltix.
*						stmt_os() - add return flag arg.
*
*
*
*  This document contains confidential/proprietary information.
*
*  Copyright (c) 1983, 1984 by Digital Communications Assoc.
*
*************************************************************************
* BB/Xenix Runtime Module */




/*  Notes -

> A statement is identified by a line number label, optionally followed by
	statement offset, or by the pc offset of that statement.

	The first statement after a line# has offset = STMT1OS.
	Any stmts following the 1st statement, until another line# is reached,
	have incremental statement offsets.

	If the <stmt#> is preceeded by a '@', then the value following the
	'@' is assumed to be the pc offset of the stmt.

	Statement # syntax -

		statement # :=	<stmt#> | '@'<pc_offset>
		<stmt#>		:=	<line#> [+n]
		<line#>		:=	0 - 32K


.SH*/
#include	"debug.h"



stmt_os ( errtrap )

int	errtrap;	/* if <>0, trap bad stmt# errors */

/* Given <stmt#> ( in command line ), return pc offset.
	Assumes current token = first word of line number text.
	If errtrap is set, stmt#/pc_offset match must be exact,
		otherwise the offset of the next higher stmt is returned.

Return -
	Ret val	- offset of stmt#. 
	ltix -	if stmt found - ltix of stmt.
			if stmt not found - ltix of next higher stmt.
	Upon return, scanner is at token following <stmt#>.

Notes -
	If the stmt# is not found, an offset can not be used.
*/

{
	register struct lnrec	*ltptr;
	register int	n,i;
	int				os;		/* stmt offset */


	if ( token.str[0] == '@' ) {


		/** pc offset **/

		gettkn( PNUM );
		os = (int)token.nval ;	/* offset */
		gettkn( -1 );		/* inc scanner */

		/* get ltix for this offset */
		ltloop(0) {
			ltptr = &linetbl[ltix];
			if ( ltptr->pcoffset == os )
				return( os );		/* found it */
			if ( ltptr->pcoffset > os ) {
				/* passed it */
				os = ltptr->pcoffset ;	/* use offset of next stmt */
				goto lnerr;
				}
			}
		/* offset too big, use last entry */
		os = ltptr->pcoffset ;		/* use offset of last stmt */
		goto lnerr;
		}

	else {


		/** Statement number **/

		/* chk line table exists */
		if ( ltexists( 0 ) == FALSE )
			return( -1 );

		/** find line in line# table **/
		if ( token.typ != NUM )
			goto lnserr ;		/* bad input */
		n = (int)token.nval ;	/* stmt # */
		gettkn( -1 );		/* inc scanner */
		if ( n > LASTSTMT )
			lnserr ;		/* stmt# too big */
		ltloop( 0 ) {
			ltptr = &linetbl[ltix];
			os = ltptr->pcoffset ;	/* offset of this stmt */
			if ( ltptr->lineno == n ) {
				break;		/* found it */
				}
			if ( ltptr->lineno > n ) {
				goto lnerr;		/* line# not in table */
				}
			}

		/* chk for stmt offset */
		if ( token.str[0] == '+' ) {

			/** get unlabled statement **/
			gettkn( NUM );
			n = (int)token.nval;		/* offset */
			gettkn( -1 );		/* inc scanner */

			/* get to stmt os = n */
			for ( i = 0 ; i < n ; i++ ) {
				ltix++;		/* next entry */
				if ( ltix >= ltnent ) {
					ltix-- ;
					goto lnerr ;		/* not that many entries in table */
					}
				if ( linetbl[ltix].lineno != 0 )
					goto lnerr ;		/* not that many stmts in this line */
				}
			os = linetbl[ltix].pcoffset ;
			}
		}
	if (dbug)
		printf( "stmt_os: line entry # = %d\n", ltix );

	/* return offset */
	return( os );


lnserr:	/* syntax error while processing line# */
	error( "Line number syntax" );

lnerr:	/* stmt not found */
	if ( errtrap )
		error( "Statement not found" );
	else {
		if ( token.str[0] == '+' ) {
			/* can't use offset on stmt which was not found */
			errtrap = -1 ;
			goto lnerr ;		/* show error */
			}
		return( os );
		}

	}

os_stmt ( os )

/* given code offset, return stmt#

Ret -
	ret val	= line#
	linenum	= line#
	stmtos	= stmt offset ( 'STMT1OS' if first stmt on line ).
	stmtstr	= '<line#> + <stmtos>'
*/

int	os;
{
	return( tostmt( 0, os ) );
	}



lt_stmt ( ltptr )

/* Given line table index, return stmt#.
	( Version of os_stmt() for line table dump ). */

int	ltptr;
{
	return( tostmt( -1, ltptr ) );
	}


tostmt( flag, val )

int	flag;		/* -1 = val is line table entry number.
				    0 = val is pc offset of line#. */
int	val;

{
	register int	i,tos;

	if ( ltexists( 0 ) == FALSE ) {
		strcpy( stmtstr, "0" );		/* null stmt string */
		linenum = 0 ;
		stmtos = 0 ;
		return( -1 );
		}

	initline();		/* initialize line# & stmtos */

	ltloop( 0 ) {
		saveline( ltix );		/* record current line# & stmtos */
		if ( flag < 0 ) {	 /* val is line tbl ix */
			if ( ltix == val )  break ;
			}
		else {	 /* val is pc offset */
			i = linetbl[ltix].pcoffset ;	/* pc os of this stmt */
			if ( i == val )  break ;
			if ( i > val ) {	/* passed it */
				/* use previous stmt# */
				ltix-- ;
				break ;
				}
			}
		}
		/* if we get to here, use last line tbl entry */

	/* line# / entry#  found */
	if ( flag != -1 ) {

		/* skip empty stmts (REM, etc.) */
		tos = linetbl[ltix].pcoffset ;		/* save offset */
		ltix++ ;
		while ( ltix < ltnent ) {
			if ( linetbl[ltix].pcoffset != tos )
				break;
			saveline( ltix );
			ltix++;
			}
		}

	/** return values **/
	/* stmtstr */
	if ( stmtos == STMT1OS )		/* if first stmt on line */
		sprintf( stmtstr, "%04.d", linenum );		/* don't show stmtos */
	else
		sprintf( stmtstr, "%04.d+%2d", linenum, stmtos );

	if (0) printf(">> os_stmt: line#,stmt#,stmtstr = %d %d %s\n",
	linenum,stmtos,stmtstr );
	return( linenum);
	}


saveline ( ltptr )

/** record current line# and stmtos **/

int	ltptr;		/* line# table entry number */
{

	if ( linetbl[ltptr].lineno != 0 ) {

		/* this is a labeled line */
		linenum = linetbl[ltptr].lineno ;		/* record next line# */
		stmtos = STMT1OS ;					/* we're at 1st stmt on line */
		}
	else

		/* this is an unlabled line */
		stmtos++ ;							/* same line, next stmt */
	}


initline ()

/**  Initialize line# and stmtos globals  **/
/*   This must be done in case 1st stmt in program does not have a
	  line number.  */

{
	linenum = 0 ;
	stmtos = STMT1OS - 1 ;		/* ready for pre-inc */
	}
