/*************************************************************************
*
*
*	Name:		decls.c
*
*	Description:	Module declarations
*
*	History:
*	Date		By	Comments
*
*	12/02/83	jle
*
*
*
*  This document contains confidential/proprietary information.
*
*  Copyright 1983 by Digital Communications Associates, Inc.
*
*************************************************************************
* BB/Xenix Compiler Module */




/*  Notes -

*/

#include "tokens.h"
#include "opcodes.h"
#include "label.h"
#include "vartab.h"
#include "symbols.h"

extern unsigned pc;
extern unsigned bcdsize, bvrsize;
extern struct VTAB *flocal;

/* decls := eoln* %INTERFACE int-dec
	  | eoln* %OVERLAY over-dec
*/
decls()
{
   while (token == EOLN) nextline();
   switch (token) {
case TINTERFACE:
      gettoken();
      intdec();
      break;
case TOVERLAY:
      gettoken();
      overdec();
      break;
default:
      pstart(0);
      return;
   }
   if (token != EOLN) synerr("Statement does not end properly.");
   nextline();
}

/* int-dec := %INTERFACE ( codesz comma datasz )? eoln intspec*  %IMPLEMENTATION
   intspec := %GLOBAL varlist
	    | %ENTRY linelist
	    | %EXTERNAL linelist
*/
intdec()
{
   struct ENTEXT e;

   pstart(1);
   if (token != EOLN) {
      if (token == NUMLIT) {
	 bcdsize = value;
	 gettoken();
      } else synerr("Numeric constant expected.");
      if (token == COMMA) gettoken();
      else synerr(", expected.");
      if (token == NUMLIT) {
	 bvrsize = value;
	 gettoken();
      } else synerr("Numeric constant expected.");
   }
   nextline();
   while (token != EOFT) {
      switch (token) {
case TENTRY:
	 do {
	    gettoken();
	    if (token == NUMLIT) {
	       e.epc = pc;
	       e.eval = value;
	       e.etype = lentry;
	       addentext(&e);
	       labref(JMP,(int) value,lentry);
	       gettoken();
	    } else synerr("Statement number expected.");
	 } while (token == COMMA);
	 break;
case TEXTERNAL:
	 do {
	    gettoken();
	    if (token == NUMLIT) {
	       e.epc = pc;
	       e.eval = value;
	       e.etype = lextrn;
	       addentext(&e);
	       gettoken();
	    } else synerr("Statement number expected.");
	 } while (token == COMMA);
	 break;
case TGLOBAL:
	 do {
	    gettoken();
	    dumvar();
	 } while (token == COMMA);
	 flocal = nxtvtab;
	 break;
case TIMPLEMENTATION:
	 gettoken();
	 return;
case EOLN:
	 break;
default:
	 synerr("Illegal statement in Interface Section.");
	 break;
      }
      nextline();
   } /* end while */
}

overdec()
{
   if (token == TTO) gettoken();
   else synerr ("TO expected");
   if (token == STRLIT) bstart(symbol);
   else synerr ("String literal expected");
   gettoken();
   pstart(2);
   dumpent();
}
