: "
  CDC-114 XENIX R1.0

  10/20/82
  
  ser_pr.sh will add or delete serial printer ports.

"
:                    disable XENIX interrupt signal
trap "continue" 2

clear.sh
echo -n "
ADD/DELETE SERIAL PRINTER

Add or delete serial printer (a or d)? "
read flag

:                    exit if it is not a or d
if test "$flag" != "a" -a "$flag" != "d"
       then
            echo -n "
Serial printer will not be added/deleted. 
Press NEW LINE or RETURN to continue. "
            read nline
            exit
fi
echo -n "
Port number (2, 3, 4, 5, 6, 7 or 8)? "
read port

:                    exit if port number is not between 2 and 8
if test "$port" -gt "8" -o "$port" -lt "2"
       then
            echo -n "
Port number should between 2 and 8.
Serial printer will not be added/deleted.
Press NEW LINE or RETURN to continue. "
            read nline
            exit
fi


:                    add serial printer ... update /etc/ttys and /etc/con.file
if test "$flag" = "a"
       then
:                    check if port is dial-in port 
            junk=`sed -n -e "/10tty$port/p" /etc/ttys`
            if test -z "$junk"
            then
                 : okay
           else
                echo -n "Port $port is a dial-in port.
You have to delete the dial-in port before add serial printer on port $port
Press NEW LINE or RETURN to continue. "
                read nl
                exit
            fi



            while true
            do
            echo -n "
Printer Type
  1:  CDC 725-10 Matrix Printer
  2:  CDC 727-40 Letter Quality Printer
  3:  CDC 727-55 Letter Quality Printer
  4:  EPSON MX80 Matrix Printer

Please enter type (1, 2, 3 or 4): "
            read pr_no
            speed=9600
            sed -e "s/[012][012]tty$port/02tty$port/" /etc/ttys >temptty
            case $pr_no in
               1)  pr_type=CDC725-10 
                   break ;;
               2)  pr_type=CDC727-40 
                   speed="2400" 
                   echo -n "Please power on the CDC727-40 printer.
Press NEW LINE or RETURN to continue. "
                   read nl
                   stty $speed >/dev/tty$port
                   sed -e "s/[012][012]tty$port/12tty$port/" /etc/ttys >temptty
                   echo "
> /etc/spr/spr.L$port
stty $speed >/dev/tty$port
rm /etc/spr/spr.L$port  >/dev/null
"  > /etc/spr/spr$port

                   break ;;
               3)  pr_type=CDC727-55 
                   break ;;
               4)  pr_type=EPSON-MX80 
                   break ;;
               *)  echo "Printer type should between 1 and 4."
                   sleep 1
            esac
            done
            ed /etc/con.file >/dev/null <<!
/tty$port/
c
$port:tty$port (printer):$pr_type:$speed
.
w
q
!
            mv temptty /etc/ttys
            kill -2 1
            echo "
Serial printer port $port is added. "
           if test -f /bin/lpr
           then
                echo "Press NEW LINE or RETURN to continue. "
           else
                if test -f /etc/lpr
                then
                     echo -n "WARNING : Spooling device was not assigned.
Please enter CHANGE SPOOLED DEVICE menu to add spooling devicee if needed.
Press NEW LINE or RETURN to continue. "
                else
                     echo -n "WARNING : Spooler is not on the system !!!
Press NEW LINE or RETURN to continue. "
                fi
           fi
           read nline
           exit
       else

:                    delete serial printer port ... update /etc/ttys and /etc/con.file
            if test "$flag" = "d"
            then

:                    check if port is serial printer port before delete
                  sed -n -e "/tty$port/p" /etc/con.file |awk 'BEGIN {FS=":"}
                    {print $3 >"tempser"}'
                  pr_type="`cat tempser`"
                 if test "$pr_type" != "CDC725-10" -a "$pr_type" != "CDC727-40" -a "$pr_type" != "CDC727-55" -a "$pr_type" != "EPSON-MX80"
                 then
                      echo -n "
Port $port is not a serial printer port. 
Press NEW LINE or RETURN to continue. "
                      read nline
                      exit
                 fi
                 rm tempser


:                    check if port is spooled device port
            sed -n -e "/lp/p" /etc/con.file |awk 'BEGIN {FS=":"}
{print $1 >"templp"}'
            spool_lp=`cat templp`
            rm templp
            if test "$spool_lp" = "$port"
            then
                 echo -n "
WARNING : Spooling device is on port $port.
Do you still want to delete it (y or n)?"
                 read sp_flag
                 if test "$sp_flag" != "y"
                 then
                      echo -n "
Serial printer will not be deleted. 
Press NEW LINE or RETURN to continue. "
                      read nline
                      exit
                 else
                      rm /dev/lp
                      mv /bin/lpr /etc/lpr
                      ed /etc/con.file >/dev/null <<!
/lp/
c
:lp (not used)::
.
w
q
!
                 echo "Spooled device is deleted. "
                 fi
           fi


:                    check if the printer type is CDC727-40
                  if test "$pr_type" = "CDC727-40"
                  then
                       rm /etc/spr/spr$port >/dev/null
                  else

                       sed -e "s/02tty$port/12tty$port/" /etc/ttys >tempttys
                       mv tempttys /etc/ttys
                  fi
                 ed /etc/con.file >/dev/null <<!
/tty$port/
c
$port:tty$port:CDC722:9600
.
w
q
!
                  kill -2 1
                 echo -n "
Serial printer port $port is deleted. 
Press NEW LINE or RETURN to continue. "
                 read nline

            fi
fi
