/*
**
**   --- please read this ! ---
**
**  This source code is in "shrouded" form. It is distributed in this form
**  rather than as a library (.LIB) file because of the inconsistancies
**  between object files generated by different compilers. To support several
**  compilers would require a .LIB file for each compiler manufacturer, and
**  sometimes several versions of the .LIB file are needed for the different
**  versions of the same manufacturers compiler!
**
**  You can compile this code, but you will have to register with us in order
**  to get the normal (commented) C source code with normal variable names.
*/


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <conio.h>
#include "opcodes.h"
#include "si.h"
#include "pcl4c.h"
#include "term.h"
#include "term_io.h"
#include "modem_io.h"
#include "amodem.h"
#include "xymodem.h"
#include "zmodem.h"
#include "win_io.h"
#include "ascii.h"

#ifndef FALSE
#define FALSE 0
#define TRUE !FALSE
#endif

#define MARK 0x55
#define BYTE unsigned char

#define CODE_SIZE 1024
#define DATA_SIZE 1024
#define STACK_SIZE  32

#define BUFBLK_SIZE 1024

static int  V43 = 2;     
static BYTE V5 = 0;    
static int  V8 = 0;      
static int  V13 = 0;      
static int  V38 = 0;    
static char V25;         
static int  V26 = 1;    
static int  V29 = 540;   
static int  V27 = 5;     
static int  V24 = TRUE;  
static char V28 = 'X';  
static FILE *V3;     
static char V16[15];    
static BYTE V6[CODE_SIZE];   
static char V10[DATA_SIZE];   
static BYTE V37[STACK_SIZE]; 
static int  V2;
static int  V23;
static int  V11;
static int  V39;
static int  V15[10] =
  {0x180,0x0C0,0x060,0x030,0x018,0x00C,0x006,0x003,0x002,0x001};
static char V4[BUFBLK_SIZE];
static int  V40 = FALSE;
static char V41[80];

void SaySiErr(int Code)
{
 switch(Code)
   {case  SI_CANNOT_OPEN:
      WinPutString(SCR_WIN,"Cannot open script binary\n");
      break;
    case  SI_UNEXPECTED_EOF:
      WinPutString(SCR_WIN,"Unexpected EOF\n");
      break;
    case  SI_NOT_SCRIPT_BINARY:
      WinPutString(SCR_WIN,"Not script binary\n");
      break;
    case  SI_NOT_CURRENT_VERSION:
      WinPutString(SCR_WIN,"Incorrect script version\n");
      break;
    case  SI_CODE_LENGTH_OVERFLOW:
      WinPutString(SCR_WIN,"Code overflow\n");
      break;
    case  SI_DATA_LENGTH_OVERFLOW:
      WinPutString(SCR_WIN,"Data overflow\n");
      break;
    case  SI_BAD_OPCODE:
      WinPutString(SCR_WIN,"Bad opcode encountered\n");
      break;
    case  SI_USER_ABORTS:
      WinPutString(SCR_WIN,"User aborting...\n");
      break;
    case  SI_STACK_OVERFLOW:
      WinPutString(SCR_WIN,"Stack overflow\n");
      break;
    case  SI_STACK_UNDERFLOW:
      WinPutString(SCR_WIN,"Stack underflow\n");
      break;
    case  SI_BAD_CHECKSUM:
      WinPutString(SCR_WIN,"Bad checksum\n");
      break;
    default:
      sprintf(V41,"Script error %d\n",Code);
      WinPutString(SCR_WIN,V41);
      break;
   }
}

static int V18(void)
{int i, k;
 i = fgetc(V3);
 if(i==EOF) return(SI_UNEXPECTED_EOF);
 V5 ^= (BYTE)i;
 return((BYTE)i);
}

static int V33(int Item)
{V37[V38++] = Item;
 if(V38==STACK_SIZE) return(SI_STACK_OVERFLOW);
 return (0);
}

static int V30(void)
{if(V38==0) return(SI_STACK_UNDERFLOW);
 return (V37[--V38]);
}

static char V36(int Flag)
{char c;
 if(Flag) return('T');
 else return('F');
}


static int V17(int V14)
{int i;
 for(i=0;i<10;i++) if(V14==V15[i]) return i;
 return -1;
}



int si(int Port,char *FilePtr,int Debug)
{int i, k;
 int V35;
 char c;
 char *V32;
 int V21; 
 int V22;   
 int V1;   
 int V7;    
 int V12;    
 int V9;
 int V31;
 int V19;
 char V34 = '"';
 char V42[80];
 int V14;
 char NCGchar = 'C';
 
 V14 = SioGetDiv(Port);
 V2 = V17(V14);
 V31 = SioRead(Port,3);
 V11 = 0x03 & V31;
 V39 = 0x01 & (V31>>2);
 V23 = 0x07 & (V31>>3);
#if 0
 sprintf(V41,"Codes: Baud=%d Data=%d Stop=%d Parity=%d\n",
   V2,V11,V39,V23);
 WinPutString(SCR_WIN,V41);
#endif
 
 if(V2<=Baud19200) V40 = TRUE;
 else V40 = FALSE;
 
 for(i=0;i<CODE_SIZE;i++) V6[i] = OPC_HALT;
 for(i=0;i<DATA_SIZE;i++) V10[i] = 0;
 V5 = 0;
 V8 = 0;
 V13 = 0;
 V38 = 0;
 V25 = TRUE;
 V26 = 1;
 
 strncpy(V16,FilePtr,8);
 strcat(V16,".sb");
 
 V3 = fopen(V16,"rb");
 if(V3==NULL) return (SI_CANNOT_OPEN);
 
 if((V35=V18())<0) return(V35);
 if(V35!=MARK) return(SI_NOT_SCRIPT_BINARY);
 
 if((V35=V18())<0) return(V35);
 if(V35!=V43) return(SI_NOT_CURRENT_VERSION);
 
 if((V35=V18())<0) return(V35);
 V7 = 0x00ff & V35;
 if((V35=V18())<0) return(V35);
 V7 = 256*V7 + (0x00ff&V35);
#if 0
sprintf(V41,"Code Length = %d \n",V7)
WinPutString(SCR_WIN,V41);
#endif
 if(V7>=CODE_SIZE) return(SI_CODE_LENGTH_OVERFLOW);
 
 if((V35=V18())<0) return(V35);
 V12 = 0x00ff & V35;
 if((V35=V18())<0) return(V35);
 V12 = 256*V12 + (0x00ff&V35);
#if 0
sprintf(V41,"Data Length = %d \n",V12);
WinPutString(SCR_WIN,V41);
#endif
 if(V12>=DATA_SIZE) return(SI_DATA_LENGTH_OVERFLOW);
 
 for(i=0;i<V7;i++)
   {if((V35=V18())<0) return(V35);
#if 0
sprintf(Temp"%d: %d\n",i,0x003f&V35);
WinPutString(SCR_WIN,V41);
#endif
    V6[V8++] = (BYTE)V35;
   }
 
 if((V35=V18())<0) return(V35);
 if(V35!=MARK) return(SI_NOT_SCRIPT_BINARY);
 
 for(i=0;i<V12;i++)
   {if((V35=V18())<0) return(V35);
#if 0
sprintf(V41,"%d: %d\n",i,V35);
WinPutString(SCR_WIN,V41);
#endif
    V10[V13++] = (BYTE)V35;
   }
 
 if((V35=V18())<0) return(V35);
 if(V35!=MARK) return(SI_NOT_SCRIPT_BINARY);
 
 V9 = V5;
 if((V35=V18())<0) return(V35);

 if((BYTE)V35!=V9)
   {
#if 1
    sprintf(V41,"Received V5=%d\n",(BYTE)V35);
    WinPutString(SCR_WIN,V41);
    sprintf(V41,"Computed V5=%d\n",V9);
    WinPutString(SCR_WIN,V41);
#endif
    return(SI_BAD_CHECKSUM);
   }

 
 V8 = 0;
 while(1)
   {if(kbhit())
     {c = getch();
      if(c==ESC) return(SI_USER_ABORTS);
      else CharPut(Port,c);
     }
    
    k = V6[V8++];
    V21 = 0x003F & k;
    V22 = (0x00C0 & k) << 2;
    if(Debug)
      {V19 = MatchOpCode(V21);
       sprintf(V41,"@%d",V8);
       sprintf(V42,"[%4s: %s ",V41,GetOpText(V19));
       WinPutString(SCR_WIN,V42);
      }
    
    if(V21>=8)
      {V1 = V22 | (0x00ff & V6[V8++]);
       if(Debug) switch(GetOperType(V19))
         {case CODE_REF:
            sprintf(V41," %d]\n",V1);
            WinPutString(SCR_WIN,V41);
            break;
          case DATA_REF:
            sprintf(V41," %c%s%c]\n",V34,&V10[V1],V34);
            WinPutString(SCR_WIN,V41);
         }
      }
    
    switch(V21)
     {case OPC_HALT:
        return(0);
      case OPC_STATUS:
        sprintf(V41,"PgmChar=%c (%xH) Count=%d Wait=%d Pace=%d Case=%c Protocol=%c\n",
           V36(V25),V25,V26,V29,V27,V36(V24),
           V28);
        WinPutString(SCR_WIN,V41);
        sprintf(V41,"CodePC=%d V21=%d V1=%d V31=%xH BaudDiv=%xH\n",
           V8,V21,V1,SioRead(Port,3),SioGetDiv(Port));
        WinPutString(SCR_WIN,V41);
        ModemDump();
        break;
      case OPC_DELAY:
        SioDelay( (int) (18.2*atof(&V10[V1])) );
        break;
      case OPC_CALL:
        if((V35=V33(V8))<0) return V35;
        V8 = V1;
        break;
      case OPC_RETURN:
        V35 = V30();
        if(V35<0) return V35;
        V8 = V35;
        break;
      case OPC_BAUD:
        i = BaudMatch(&V10[V1]);
        if(V2==-1) V25 = FALSE;
        else
          {V2 = i;
           SioBaud(Port,V2);
           V25 = TRUE;
          }
        break;
      case OPC_DATABITS:
        i = (int) atoi(&V10[V1]);
        V25 = TRUE;
        switch(i)
          {case 7:
             V11 = WordLength7;
             break;
           case 8:
             V11 = WordLength8;
             break;
           default:
             V25 = FALSE;
             break;
          }
        if(V25) SioParms(Port,V23,V39,V11);
        break;
      case OPC_STOPBITS:
        i = (int) atoi(&V10[V1]);
        V25 = TRUE;
        switch(i)
          {case 1:
             V39 = OneStopBit;
             break;
           case 2:
             V39 = TwoStopBits;
             break;
           default:
             V25 = FALSE;
             break;
          }
        if(V25) SioParms(Port,V23,V39,V11);
        break;
      case OPC_PARITY:
        c = V10[V1];
        V25 = TRUE;
        switch(c)
          {case 'N':
             V23 = NoParity;
             break;
           case 'E':
             V23 = EvenParity;
             break;
           case 'O':
             V23 = OddParity;
             break;
           default:
             V25 = FALSE;
             break;
          }
        if(V25) SioParms(Port,V23,V39,V11);
        break;
      case OPC_REPLY:
        ModemSendTo(Port,V27,&V10[V1]);
        break;
      case OPC_SETCOUNT:
        V26 = atoi(&V10[V1]);
        break;
      case OPC_SETWAIT:
        V29 = (int) (18.2*atof(&V10[V1]));
        break;
      case OPC_LOOP:
        if(--V26>0) V8 = V1;
        break;
      case OPC_IFTRUE:
        if(V25) V8 = V1;
        break;
      case OPC_IFFALSE:
        if(!V25) V8 = V1;
        break;
      case OPC_IF:
        if(V25!=V10[V1]) V8 += 2;
        break;
      case OPC_IFNOT:
        if(V25==V10[V1]) V8 += 2;
        break;
      case OPC_GOTO:
        V8 = V1;
        break;
      case OPC_TEST:
        V25 = V10[V1];
        break;
      case OPC_ACCEPT:    
        WinGetString(SCR_WIN,&V10[V1],15);
        break;
      case OPC_SAY:
        V32 = &V10[V1];
        for(i=0;;i++)
          {c = *V32++;
           if(c=='\0') break;
           if(c=='^') c = ( *V32++ ) - '@';
           WinPutChar(SCR_WIN,c);
          }
        break;
      case OPC_WAITFOR:
        V25 = ModemWaitFor(Port,V29,V24,&V10[V1]);
        break;
      case OPC_NOP:
        break;
      case OPC_DEBUG:
        ModemDebug();
        break;
      case OPC_SETPACE:
        V27 = (int) (18.2*atof(&V10[V1]));
        break;
      case OPC_SETCASE:
        c = toupper(V10[V1]);
        if(c=='T') V24 = TRUE;
        if(c=='F') V24 = FALSE;
        break;
      case OPC_QUIET:
        ModemQuiet(Port, (int) (18.2*atof(&V10[V1])) );
        break;
      case OPC_HANGUP:
        ModemHangup(Port);
        break;
      case OPC_PROTOCOL:
        c = toupper(V10[V1]);
        if(c=='A') V28 = 'A';
        if(c=='X') V28 = 'X';
        if(c=='Y') V28 = 'Y';
        if(c=='Z') V28 = 'Z';
        break;
      case OPC_SEND:
        if(V28!='A') ModemEcho(Port,10);
        switch(V28)
          {case 'A':
             
             TxAscii(Port,&V10[V1],V4,BUFBLK_SIZE,FALSE,0,CAN,TRUE);
             break;
           case 'X':
             
             XmodemTx(Port,&V10[V1],V4,FALSE);
             break;
           case 'Y':
             
             YmodemTx(Port,&V10[V1],V4);
             break;
           case 'Z':
             
             ZmodemTx(Port,V16,V40);
             break;
          }
        break;
      case OPC_RECEIVE:
        if(V28!='A') ModemEcho(Port,10);
        switch(V28)
           {case 'A':
               
               RxAscii(Port,&V10[V1],V4,BUFBLK_SIZE,GetBufSize(),FALSE,
                       0x00,5,TRUE);
               break;
            case 'X':
               
               XmodemRx(Port,&V10[V1],V4,NCGchar);
               break;
            case 'Y':
               
               YmodemRx(Port,V4,NCGchar);
            case 'Z':
               
               ZmodemRx(Port,V40);
               break;
           }
        ModemSendTo(Port,V27,"!");
        break;
      case OPC_USER1:
      case OPC_USER2:
      case OPC_USER3:
      case OPC_USER4:
      case OPC_USER5:
      case OPC_USER6:
      case OPC_USER7:
      case OPC_USER8:
        break;
     }
   } 
} 
