/* opcodes.c */

#include <stdio.h>
#include "string.h"
#include "opcodes.h"

static char *RefText[3] = {"NONE", "CODE", "DATA"};

static struct
{WORD  Opcode;
 BYTE  OperType;
 char *Text;
} Opcodes[NBR_OPCODES] =
   {{OPC_HALT,    REF_HALT,    "HALT"},
    {OPC_STATUS,  REF_STATUS,  "STATUS"},
    {OPC_RETURN,  REF_RETURN,  "RETURN"},
    {OPC_NOP,     REF_NOP,     "NOP"},
    {OPC_DEBUG,   REF_DEBUG,   "DEBUG"},
    {OPC_XXX_5,   0,           NULL},
    {OPC_XXX_6,   0,           NULL},
    {OPC_XXX_7,   0,           NULL},
    {OPC_CALL,    REF_CALL,    "CALL"},
    {OPC_LOOP,    REF_LOOP,    "LOOP"},
    {OPC_IFTRUE,  REF_IFTRUE,  "IFTRUE"},
    {OPC_IFFALSE, REF_IFFALSE, "IFFALSE"},
    {OPC_GOTO,    REF_GOTO,    "GOTO"},
    {OPC_BAUD,    REF_BAUD,    "BAUD"},
    {OPC_DATABITS,REF_DATABITS,"DATABITS"},
    {OPC_STOPBITS,REF_STOPBITS,"STOPBITS"},
    {OPC_PARITY,  REF_PARITY,  "PARITY"},
    {OPC_QUIET,   REF_QUIET,   "QUIET"},
    {OPC_HANGUP,  REF_HANGUP,  "HANGUP"},
    {OPC_REPLY,   REF_REPLY,   "REPLY"},
    {OPC_DELAY,   REF_DELAY,   "DELAY"},
    {OPC_SETCOUNT,REF_SETCOUNT,"SETCOUNT"},
    {OPC_SETWAIT, REF_SETWAIT, "SETWAIT"},
    {OPC_SAY,     REF_SAY,     "SAY"},
    {OPC_WAITFOR, REF_WAITFOR, "WAITFOR"},
    {OPC_SETPACE, REF_SETPACE, "SETPACE"},
    {OPC_SETCASE, REF_SETCASE, "SETCASE"},
    {OPC_ACCEPT,  REF_ACCEPT,  "ACCEPT"},
    {OPC_PROTOCOL,REF_PROTOCOL,"PROTOCOL"},
    {OPC_SEND,    REF_SEND,    "SEND"},
    {OPC_RECEIVE, REF_RECEIVE, "RECEIVE"},
    {OPC_TEST,    REF_TEST,    "TEST"},
    {OPC_IF,      REF_IF,      "IF"},
    {OPC_IFNOT,   REF_IFNOT,   "IFNOT"},
    {OPC_XXX_34,   0,           NULL},
    {OPC_XXX_35,   0,           NULL},
    {OPC_XXX_36,   0,           NULL},
    {OPC_XXX_37,   0,           NULL},
    {OPC_XXX_38,   0,           NULL},
    {OPC_XXX_39,   0,           NULL},
    {OPC_XXX_40,   0,           NULL},
    {OPC_USER1,   REF_USER,   "USER1"},
    {OPC_USER2,   REF_USER,   "USER2"},
    {OPC_USER3,   REF_USER,   "USER3"},
    {OPC_USER4,   REF_USER,   "USER4"},
    {OPC_USER5,   REF_USER,   "USER5"},
    {OPC_USER6,   REF_USER,   "USER6"},
    {OPC_USER7,   REF_USER,   "USER7"},
    {OPC_USER8,   REF_USER,   "USER8"}
   };

int MatchOpCode(WORD Opcode)
{int i;
 for(i=0;i<NBR_OPCODES;i++)
   if(Opcodes[i].Opcode==Opcode) return(i);
 return (-1);
}

int MatchOpText(char *Text)
{int i;
 for(i=0;i<NBR_OPCODES;i++)
   if(strcmp(Opcodes[i].Text,Text)==0) return(i);
 return (-1);
}

int GetOpCode(WORD Index)
{if(Index<NBR_OPCODES) return (Opcodes[Index].Opcode);
 else return (-1);
}

char *GetOpText(WORD Index)
{if(Index<NBR_OPCODES) return (Opcodes[Index].Text);
 else return (NULL);
}

int GetOperType(WORD Index)
{if(Index<NBR_OPCODES) return (Opcodes[Index].OperType);
 else return (-1);
}

char *GetOperText(WORD Index)
{if(Index<=DATA_REF) return (RefText[Index]);
 else return NULL;
}