/* dir_io.h */

#include <stdio.h>
#include <dos.h>
#include <string.h>

#include "dir_io.h"

#define FALSE 0
#define TRUE !FALSE

#define BYTE unsigned char
#define WORD unsigned int

typedef struct DTAbufferType
{BYTE Reserved[21];
 BYTE Attribute;
 WORD Time;
 WORD Date;
 long Size;
 BYTE Name[13];
 BYTE Junk[85];
} DTAbufferType;

static DTAbufferType DTA1buffer;
static DTAbufferType DTA2buffer;

static void dosSetDTA(int which)
{union REGS reg;
 switch(which)
   {case 1:
      reg.x.dx = (WORD) (&DTA1buffer);
      break;
    case 2:
      reg.x.dx = (WORD) (&DTA2buffer);
      break;
   }
 reg.h.ah = 0x1A;
 int86(0x21, &reg, &reg);
}

static int dosFindFirst(char *FileSpec)
{union REGS reg;
 reg.x.dx = (WORD) FileSpec;
 reg.h.ah = 0x4e;
 reg.x.cx = 0;
 int86(0x21, &reg, &reg);
 if(reg.x.cflag) return FALSE;
 return TRUE;
}

static int dosFindNext(void)
{union REGS reg;
 reg.h.ah = 0x4f;
 int86(0x21, &reg, &reg);
 if(reg.x.cflag) return FALSE;
 return TRUE;
}

/*** PUBLIC [small memory model only] ***/

int FindFirst(char *Specifier,char *Name,long *Size)
{dosSetDTA(1);
 if(dosFindFirst(Specifier))
   {if(Name) strncpy(Name,DTA1buffer.Name,13);
    if(Size) *Size = DTA1buffer.Size;
    return TRUE;
   }
 return FALSE;
}

int FindNext(char *Name,long *Size)
{dosSetDTA(1);
 if(dosFindNext())
   {strncpy(Name,DTA1buffer.Name,13);
    if(Size) *Size = DTA1buffer.Size;
    return TRUE;
   }
 return FALSE;
}

int FileSDT(char *Name,long *Size,WORD *Date,WORD *Time)
{dosSetDTA(2);
 if(dosFindFirst(Name))
   {*Size = DTA2buffer.Size;
    *Date = DTA2buffer.Date;
    *Time = DTA2buffer.Time;
    return TRUE;
   }
 return FALSE;
}
