##### Module Macro #####
NAME    = pmclock

OBJS    =  $(NAME).obj


##### C7 Macro #####
C7      = 1

##### Library Macro #####
LIBS    = libw mlibcew 
##n for near w was for DLLs
MOD     = -AMn

##### Include Macro #####
INCLS   = $(NAME).h     

RCFILES = $(NAME).rc

#RCINCLS = 


##### DEBUG Defined #####
DEBUG   = 0

##### Build Option Macros #####
!if $(DEBUG)
DDEF    = -DDEBUG
CLOPT   = -Zid -Od
MOPT    = -Zi
LOPT    = /CO /LI /MAP
!else
DDEF    =
CLOPT   = -Os
LOPT    =
!endif

##### General Macros #####
DEF     = -DSTRICT=1

##### Tool Macros #####
ASM     = masm -Mx $(MOPT) $(DDEF) $(DEF)
CC      = cl -nologo -c $(MOD) -G2sw -Zp -W3 $(CLOPT) $(DDEF) $(DEF)
LINK    = link /NOD /NOE $(LOPT)
RC      = rc 
#RC = echo
HC      = hc

##### Inference Rules #####
.c.obj:
	 @echo Compiling $*.c
    $(CC) $*.c

.asm.obj:
    $(ASM) $*.asm;

.rc.res:
    @echo running rc on $*.rc
   $(RC) -r $*.rc

##### Main (default) Target #####
goal: $(NAME).exe

##### Dependents For Goal and Command Line #####
$(NAME).exe:   $(OBJS) $(NAME).res $(NAME).def 
    $(LINK) @<<
    $(OBJS)
    $(NAME).exe,
    $(NAME).map,
    $(LIBS),
    $(NAME).def
<<
    @echo link-rc $@
   $(RC) $(NAME).res $(NAME).exe
!if $(DEBUG)
!if !$(C7)
    cvpack -p $(NAME).exe
!endif
    mapsym $(NAME).map
!endif

##### Dependents For Inference Rules #####
$(NAME).res: $(INCLS) $(RCINCLS) $(RCFILES)
	$(RC) -r $(RCFILES)

##### Clean Directory #####
clean:
    -del *.obj
    -del msc\*.res
    -del *.res
    -del *.exe
    -del *.map
    -del *.sym
    -del $(NAME).exe
