//Bob's notes relating to Programming Windows 3.1 by Charles Petzold
//based on FREEMEM, p. 194 


//1) DLL static or outer variables are on DS
//2) DLL parameters and automatic variables are on SS
//3) DLL DS variables are maintained as a single copy across instances
//4) use far pointers to indicate both segment and address
//5) use local allocate/free, lock/unlock for local heap




#include <windows.h>
#include <time.h>
#include <stdio.h>

#define ID_TIMER 1

#define YEAR (datetime->tm_year % 100)
#define MONTH (datetime->tm_mon + 1)
#define MDAY (datetime->tm_mday)
#define WDAY (datetime->tm_wday)
#define HOUR (datetime->tm_hour)
#define MIN (datetime->tm_min)
#define SEC (datetime->tm_sec)
#define false 0
char sDate[2],sTime[2],sAMPM[2][5];
int  iDate, iTime;
HWND hPMwnd;

// long FAR PASCAL _export = WINAPI?

long FAR PASCAL _export WndProc (HWND,UINT,UINT,LONG);
void SetInternational(void);
void PostTime(int);

int PASCAL WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance,LPSTR lpszCmdLine,int nCmdShow)
{
static char szAppName[]="PMClock";
HWND hwnd;
WNDCLASS wndclass;
MSG msg;

if (hPrevInstance)
{
 return SendMessage(FindWindow("PMClock",0),WM_DESTROY,0,0L);
}
wndclass.style=CS_HREDRAW | CS_VREDRAW;
wndclass.lpfnWndProc = WndProc;
wndclass.cbClsExtra = 0;
wndclass.cbWndExtra = 0;
wndclass.hInstance = hInstance;
wndclass.hIcon = LoadIcon(hInstance,MAKEINTRESOURCE(1));
wndclass.hCursor = LoadCursor(NULL,IDC_ARROW);
wndclass.hbrBackground = GetStockObject(WHITE_BRUSH);
wndclass.lpszMenuName = NULL;
wndclass.lpszClassName = szAppName;

!RegisterClass (&wndclass);

hwnd = CreateWindow (szAppName, "PMClock",
   WS_OVERLAPPEDWINDOW,
   CW_USEDEFAULT, CW_USEDEFAULT,
   CW_USEDEFAULT, CW_USEDEFAULT,
   NULL,NULL,hInstance,NULL);

if (!SetTimer(hwnd,ID_TIMER,(UINT) 60000,NULL))
  {
  MessageBox (hwnd, "No timer available",szAppName, 
               MB_ICONEXCLAMATION | MB_OK);
  return FALSE;
  }

if(!(hPMwnd = FindWindow("PROGMAN",0)))
  {
  MessageBox(hwnd, "Couldn't find Program Manager", szAppName,
               MB_ICONEXCLAMATION | MB_OK);
  return FALSE;
  }
   SetInternational();
   PostTime(1);

ShowWindow (hwnd, SW_SHOWMINNOACTIVE);
UpdateWindow (hwnd);

while (GetMessage(&msg,NULL,0,0))
  {
  TranslateMessage (&msg);
  DispatchMessage(&msg);
  }
return msg.wParam;
}

void SetInternational(void)
{
 static char cName[]="intl";
 iDate=GetProfileInt(cName,"iDate",0);
 iTime=GetProfileInt(cName,"iTime",0);
 GetProfileString(cName,"sDate","/",sDate,2);
 GetProfileString(cName,"sTime",":",sTime,2);
 GetProfileString(cName,"s1159","AM",sAMPM[0],5);
 GetProfileString(cName,"s2359","PM",sAMPM[1],5); 
}

void PostTime(int Mode)
{
//Mode=1: show time; Mode=0 reset
static char szWday[]="Sun\0Mon\0Tue\0Wed\0Thu\0Fri\0Sat";
char cBuffer[40]; //Mon 12/24/96 12:34 AM
char PMName[200];
long lTime;
short nLength;
short i;
short nPMName;
short nMaxLength = 199;
struct tm *datetime;

nPMName = GetWindowText(hPMwnd,(LPSTR) PMName,nMaxLength);

for (i = 0; nPMName!=0 && PMName[i] != '\0' && PMName[i]!='('; i++);
if (PMName[i]=='(') i--;
PMName[i]='\0';
if (Mode == 0)
{
SetWindowText(hPMwnd,(LPSTR) PMName);
return;
}
time(&lTime);
datetime=localtime(&lTime);
nLength=wsprintf( cBuffer, "%s (%s %d%s%d%s%d",
	(LPSTR) PMName,
        (LPSTR) szWday + 4 * WDAY,
 	iDate==1 ? MDAY: iDate==2 ? YEAR: MONTH, 
        (LPSTR) sDate,
	iDate==1 ? MONTH: iDate==2 ? MONTH : MDAY,
	(LPSTR) sDate,
	iDate==1 ? YEAR: iDate==2? MDAY : YEAR );

if (iTime==1)
   nLength += wsprintf (cBuffer+nLength, "  %02d%s%02d)",
	HOUR, (LPSTR) sTime, MIN);
else
   nLength += wsprintf (cBuffer+nLength, "  %d%s%02d %s)",
	(HOUR % 12) ? (HOUR % 12):12, 
	(LPSTR) sTime, MIN,
	(LPSTR) sAMPM [HOUR / 12]);

SetWindowText(hPMwnd,(LPSTR) cBuffer);
}
   


long FAR PASCAL _export WndProc (HWND hwnd,UINT message, UINT wParam, LONG lParam)
{

switch (message)
 {
 case WM_CREATE:
   return 0;
 case WM_TIMER:
   PostTime(1);
   return 0;
// case WM_PAINT:
//generally BeginPaint,EndPaint

// case WM_SIZE:
//forget this
 case WM_QUERYOPEN:
   return 0;  
 case WM_DESTROY:
   KillTimer (hwnd,ID_TIMER);
   PostTime(0);
   PostQuitMessage(0);
   return 0;
 }
return DefWindowProc(hwnd,message,wParam,lParam);
}
