/* _kbmsdos.h -- low level MSDOS keyboard installaton
 * Copyright (C) 1995, 1996 Markus F.X.J. Oberhumer
 * For conditions of distribution and use, see copyright notice in kb.h 
 */

/* WARNING: this file should *not* be used by applications. It is
   part of the implementation of the keyboard library and is
   subject to change. Applications should only use kb.h.
 */



/***********************************************************************
//
************************************************************************/

void kb_update(void)
{
	if (!_kb_mode)
		return;
	
	/* Control-C check */
	if (_kb_flags & KB_FLAG_SIGINT)
	{
		if (KB_ANY_MASK(_kb_shift, KB_SHIFT_ANY_CONTROL) && _kb_key[KB_SCAN_C])
		{
#if !defined(_KB_NO_SIGNALS)
			raise(SIGINT);
#else
			kb_remove();
			exit(EXIT_SIG(SIGINT));		/* sorry, but what else ? */
#endif
		}
	}
}


/***********************************************************************
//
************************************************************************/

#if defined(__BORLANDC__)

static void (interrupt far *_oldkeyint) (void) = NULL;

static int _kb_install(void)
{
	_oldkeyint = getvect(9);
	setvect(9, _my_keyint);
	return _my_keyint == getvect(9) ? 0 : -1;
}

#pragma argsused
static void _kb_remove(int final)
{
	if (_oldkeyint)
		setvect(9, _oldkeyint);
}

#endif /* __BORLANDC__ */



/***********************************************************************
//
************************************************************************/

#if defined(__EMX__)

static int _kb_install(void)
{
	if (_osmode != DOS_MODE)
		return -1;

	/* sorry, no interrupt handler possible with emx */
	return -1;
}

static void _kb_remove(int final)
{
}

#endif /* __EMX__ */



/***********************************************************************
//
************************************************************************/

#if defined(__GO32__)

/* This code is taken from the Allegro library written by Shawn Hargreaves.
 */

static _go32_dpmi_seginfo _key_rm_oldint;	  /* original real mode key IRQ */
static _go32_dpmi_seginfo _key_rm_int;	/* real mode interrupt segment info */
static _go32_dpmi_seginfo _key_pm_oldint;	  /* original prot-mode key IRQ */
static _go32_dpmi_seginfo _key_pm_int;	/* prot-mode interrupt segment info */
static _go32_dpmi_registers _key_rm_regs;


static int _kb_install(void)
{
	/* pm handler */
	_key_pm_int.pm_offset = (int) _my_keyint;
	_go32_dpmi_allocate_iret_wrapper(&_key_pm_int);
	_key_pm_int.pm_selector = _go32_my_cs();
	_go32_dpmi_get_protected_mode_interrupt_vector(9, &_key_pm_oldint);
	_go32_dpmi_set_protected_mode_interrupt_vector(9, &_key_pm_int);

	/* rm handler */
	memset(&_key_rm_regs, 0, sizeof(_go32_dpmi_registers));
	_key_rm_int.pm_offset = (int) _my_keyint;
	_go32_dpmi_allocate_real_mode_callback_iret(&_key_rm_int, &_key_rm_regs);
	_go32_dpmi_get_real_mode_interrupt_vector(9, &_key_rm_oldint);
	_go32_dpmi_set_real_mode_interrupt_vector(9, &_key_rm_int);

	return 0;
}


static void _kb_remove(int final)
{
	_go32_dpmi_set_protected_mode_interrupt_vector(9, &_key_pm_oldint);
	_go32_dpmi_set_real_mode_interrupt_vector(9, &_key_rm_oldint);
	if (final)
	{
		_go32_dpmi_free_iret_wrapper(&_key_pm_int);
		_go32_dpmi_free_real_mode_callback(&_key_rm_int);
	}
}

#endif /* __GO32__ */


/***********************************************************************
//
************************************************************************/

#if defined(__WATCOMC__)

static void (__interrupt __far *_oldkeyint) () = NULL;

static int _kb_install(void)
{
	_oldkeyint = _dos_getvect(9);
	_dos_setvect(9, _my_keyint);
	return _my_keyint == _dos_getvect(9) ? 0 : -1;
}

static void _kb_remove(int final)
{
	if (_oldkeyint)
		_dos_setvect(9, _oldkeyint);
}

#endif /* __WATCOMC__ */



/*
vi:ts=4
*/

