//lfntest.c             simple demonstration of the LFN module's capabilities
//created 5-25-95       Matt Ginzton

//(c) 1995 Matt Ginzton, MaDdoG Software
//permission is granted to use and modify this code as long as attribution
//is given.  Questions?  Email mginzton@leland.stanford.edu, or via
//CompuServe, 75022,650.

//lfntest simulates a SIMPLE! DOS shell like command.com.  It only supports
//cd, dir, and x: (to change drives).  It doesn't look at any arguments to the
//dir command, either.
//
//But it does support long filenames under Windows 95, and runs fine happily
//with short filenames under other versions of Windows!

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <direct.h>
#include "lfn.h"
#include <dos.h>

int Interact (char * buf, int size);
void Dir(void);


void main (void)
{
    char buffer[200];
    
    _lfn_init ('C');
    
    while (Interact (buffer, sizeof(buffer)-1))
    {
        if (buffer[1]==':')
        {
            if (_chdrive (toupper(buffer[0])-'A'+1))
            {
                printf ("Can't change to drive %c.\n", buffer[0]);
                continue;   //error
            }
            _lfn_init (buffer[0]);
        }
        else if (!strnicmp (buffer, "cd", 2))
        {
            _lfn_chdir (buffer+3);
        }
        else if (!strnicmp (buffer, "dir", 3))
        {
            Dir();
        }
        else if (!strnicmp (buffer, "exit", 4))
        {
            break;
        }
        else
        {
            printf ("Unrecognized command.  Keep it simple, stupid!\n");
        }
    }
}


int Interact (char * buf, int size)
{
    _lfn_getcwd (buf, size);
    printf ("%s> ", buf);
    fgets (buf, size, stdin);
    *(buf+strlen(buf)-1)=0; //get rid of \n character
    if (!*buf)
        return 0;
    return 1;
}


void Dir (void)
{
    int err;
    _lfnfind_t fileinfo;

    err=_lfn_findfirst ("*.*", _A_NORMAL | _A_HIDDEN | _A_RDONLY | _A_ARCH | _A_SUBDIR, &fileinfo);
    while (!err)
    {
        printf (fileinfo.SFN.attrib & _A_SUBDIR ? "[%-38s]\t%lu\n" : "%-40s\t%lu\n", fileinfo.name, fileinfo.SFN.size);
        err=_lfn_findnext (&fileinfo);
    }
    _lfn_findclose (&fileinfo);
}
