//lfn.h             lfn-handling file functions for 16-bit apps
//created 5/25/95   Matt Ginzton

//(c) 1995 Matt Ginzton, MaDdoG Software
//permission is granted to use and modify this code as long as attribution
//is given.  Questions?  Email mginzton@leland.stanford.edu, or via
//CompuServe, 75022,650.


#ifndef _LFN_H_
#define _LFN_H_

#include <tchar.h>

#ifndef _INC_WINDOWS
typedef unsigned long DWORD;
#endif

#ifndef MAX_PATH
#define MAX_PATH    260
#endif

typedef struct _FILETIME { // ft  
    DWORD dwLowDateTime;
    DWORD dwHighDateTime;
} FILETIME;

//definition of _find_t -- straight out of dos.h
#ifndef _FIND_T_DEFINED
#pragma pack(2)

struct _find_t {
    char reserved[21];
    char attrib;
    unsigned wr_time;
    unsigned wr_date;
    long size;
    char name[13];
    };

#ifndef __STDC__
/* Non-ANSI name for compatibility */
#define find_t _find_t
#endif 

#pragma pack()
#define _FIND_T_DEFINED
#endif 

typedef struct _WIN32_FIND_DATA { // wfd  
    DWORD dwFileAttributes;
    FILETIME ftCreationTime;
    FILETIME ftLastAccessTime;
    FILETIME ftLastWriteTime;
    DWORD    nFileSizeHigh;
    DWORD    nFileSizeLow;
    DWORD    dwReserved0;
    DWORD    dwReserved1;
    TCHAR    cFileName[ MAX_PATH ];
    TCHAR    cAlternateFileName[ 14 ];
} WIN32_FIND_DATA;


typedef struct _lfnfind_t
{
    struct _find_t      SFN;
    WIN32_FIND_DATA     LFN;
    char *              name;       //since it could be in either
    int                 bIsLong;    //so client can tell if it needs to
    int                 Handle;     //win32 search handle
} _lfnfind_t;


int _lfn_init (char drive);
unsigned _lfn_findfirst( const char *filename, unsigned attrib, _lfnfind_t *fileinfo );
unsigned _lfn_findnext( _lfnfind_t *fileinfo );
void _lfn_findclose ( _lfnfind_t * fileinfo);
int _lfn_chdir ( const char * dirname);
char * _lfn_getdcwd( int drive, char *buffer, int maxlen );
char * _lfn_getcwd( char *buffer, int maxlen );
unsigned _lfn_open( const char *filename, unsigned mode, int *handle );
int _lfn_eof ( int handle );

#endif
