; STARTCW.ASM for ASM32CW - Copyright (C) 1994, 1995 Douglas Herr
;  all rights reserved

include	model.inc

includelib	asm32cw

public	$zerosel, $pspsel, $xferseg
public	zero_sel
IFNDEF	NEARMODEL
public	$aliassel
public	alias_code_sel
ENDIF

extrn	main32:near

include	dataseg.inc

get_info	dd get_system_data
zero_sel	dw ?		; 4G selector for linear address 0000:0000
psp_sel		dw ?		; 100h selector for PSP segment
xfer_buffer	dd ?		; size of transfer buffer (always < 64k)
xfer_seg	dw ?		; real-mode segment address of transfer buffer
xfer_sel	dw ?		; selector of transfer buffer
xfer_offset	dd ?		; offset of transfer buffer
system_flags	dd ?		; CW extender flags
IFNDEF	NEARMODEL
alias_code_sel	dw ?
ENDIF
@curseg	ends

include	codeseg.inc

start:
	mov	ax,_NEAR
	mov	ds,ax
	mov	es,ax
	mov	fs,ax
	mov	gs,ax

	call	get_system_data		; initialize ZERO_SEL, PSP_SEL, etc
	call	main32			; call your main program

	mov	ax,4C00h
	int	21h


; get CW-ASM system data using CW API

$zerosel:
	call	[get_info]
	mov	ax,zero_sel
	ret

$pspsel:
	call	[get_info]
	mov	ax,psp_sel
	ret

IFNDEF	NEARMODEL
$aliassel:
	call	[get_info]
	mov	ax,alias_code_sel
	ret
ENDIF

$xferseg:
	call	[get_info]
	mov	bx,xfer_seg	; real-mode segment address of buffer
	mov	eax,xfer_offset
	mov	ecx,xfer_buffer	; size of transfer buffer
	ret

get_system_data:
	pushad
	push	es

	sys	info		; API function to get CW extender data
	mov	zero_sel,ax
	mov	psp_sel,bx
	mov	xfer_buffer,ecx
	mov	xfer_seg,dx
	mov	xfer_offset,esi
	mov	xfer_sel,es
	mov	system_flags,edi
IFNDEF	NEARMODEL
	mov	bx,cs
	sys	AliasSel
	mov	alias_code_sel,ax
ENDIF
	pop	es
	popad
	mov	get_info,offset @curseg:exit
exit:
	ret

@curseg	ends
	end	start
