; SWITCH.ASM for E32 - Copyright (C) 1994 Douglas Herr
;  all rights reserved

include	model.inc

public	switch, swap_files, swapmode
public	window_row

extrn	showfkey:near
extrn	two_mon:near
extrn	file_data_len:abs, number_of_files:abs
extrn	swapb:near, pickstr:near, strlen:near
extrn	display_screen:near

include	dataseg.inc
extrn	file_data_ptr:dword
extrn	filesel:word, filesiz:dword, filename:dword, buffersiz:dword
extrn	dirty_bits:byte, no_file_name:byte
extrn	first_row:byte, cur_posn:word, saved_pos:dword
extrn	swapmode_prompt:byte
window_row	db 1
@curseg	ends

include	codeseg.inc
;
; change between 2- and 4-file modes
;
swapmode	proc	near
	xor	swapmode_prompt, '2' XOR '4'
	jmp	showfkey
swapmode	endp

;
; switch active files
;
switch:
	cmp	swapmode_prompt,'2'
	jne	short four_files

; 2-file mode active
; swap the files' data areas
	xor	ebx,ebx			; swap with first hidden file
	inc	ebx
	call	swap_files

	ret

; 4-file mode
; seach all file data areas for filename

name_list_ptr	equ	ebp

four_files:
	cld
	push	ebp

; make space available for all filenames
	mov	ebx,number_of_files
	shl	ebx,6			; *64
	inc	ebx
	sys	GetMemNear
	jc	short four_exit
	mov	name_list_ptr,esi	; save pointer to list of names

; build list of filenames for PICKSTR
	mov	ecx,number_of_files	; do for all files
	mov	edx,file_data_ptr
	mov	edi,name_list_ptr
	push	ds
	pop	es			; ES:[EDI] -> buffer

four0:	push	ecx
	mov	esi,[edx]		; point to filename
	mov	eax,edx			; point to file data
	add	edx,file_data_len	; point to other files
	cmp	word ptr [eax+4],0FFFFh	; file buffer allocated?
	je	short four1		;  skip if not

	cmp	byte ptr [esi],0	; len(filename) > 0?
	jne	short four2		;  skip if so
four1:	lea	esi,no_file_name
four2:	mov	ebx,esi
	call	strlen			; get length of string
	inc	ecx			; include the NUL
	rep	movsb			; copy to buffer
	pop	ecx
	loop	four0
	mov	al,cl
	stosb

	mov	dx,0707h
	mov	esi,name_list_ptr
	xor	ebx,ebx
	call	pickstr
	cmp	ax,27			; ESC key?
	je	short four9

	or	ebx,ebx
	jz	short four9
	call	swap_files
four9:
	mov	esi,name_list_ptr
	sys	RelMemNear		; release memory
four_exit:
	pop	ebp
	clc
	ret


swap_files:
	cld

; put hidden file at top of screen
	mov	dl,first_row
	dec	dl
	jz	short sw00

	pushad
	sub	byte ptr cur_posn+1,dl
	sub	first_row,dl
	or	dirty_bits,00100001b
	mov	saved_pos,-1
	call	display_screen
	popad
sw00:
	push	ds
	pop	es
	mov	eax,file_data_len
	mul	bx			; offset in stored file data
	movzx	eax,ax
	mov	esi,file_data_ptr	; DS:[ESI] -> active file's data
	mov	edi,esi
	add	edi,eax			; ES:[EDI] -> next file's data
	mov	ecx,file_data_len
	call	swapb

; see if memory buffer has been allocated
	cmp	filesel,0FFFFh
	jne	short sw01		; already allocted - skip
	mov	ecx,1024
	sys	GetMem32		; allocate new selector
	mov	filesel,bx
	mov	filesiz,0
	mov	buffersiz,1024

; allocate filename buffer
	mov	ebx,64
	sys	GetMemNear
	mov	filename,esi
	mov	byte ptr [esi],0	; start with NUL filename

sw01:
; move active file to active window
	mov	dl,window_row
	dec	dl
	add	first_row,dl
	add	byte ptr cur_posn+1,dl
	mov	fs,filesel
	or	dirty_bits,00100001b	; flag to update screen & top line
	push	ds
	pop	es
	ret

@curseg	ends
	end
