; SHOWFKEY.ASM for E32 - Copyright (C) 1994 Douglas Herr
;  all rights reserved

include	model.inc

public	showfkey
extrn	tputchr:near
extrn	strnlwr:near
extrn	strnupr:near
extrn	i4tostr:near

include	dataseg.inc
extrn	normal:byte, inverse:byte
extrn	rows:byte, columns:byte
extrn	cur_posn:word, left_margin:word
extrn	key_status:byte, file_row:dword
public	swapmode_prompt

	shiftkey equ 3
	ctrl	equ 4
	altb	equ 8

nbuff	db 12 dup(0)
fkey	db ' F'
keynum	db '1',0,0

altfkeys	db ' NEW ',0,'ROWS',0,'FFEED',0,'COPY',0,' DOS ',0
		db 'UCASE',0,'LOAD',0,'COLUMNS',0,'LCASE',0,' FIND',0
altfkey_len	equ $-altfkeys

; ctrl+Fkey prompts
ctrlfkeys	db '     ',0,'    ',0,'     ',0,'PUSH',0,'POP ',0
		db 'WINDOW',0,'SWAP',0
swapmode_prompt	db '2 files',0,'GO TO',0,' NEXT',0,0
ctrlfkey_len	equ $-ctrlfkeys

; shift+Fkey prompts
shiftfkeys	db  "SETUP",0,"     ",0,"     ",0
		db  "     ",0,"     ",0,"    ",0,"MERGE",0
		db  "    ",0,"     ",0,"REPLACE",0,0
shiftfkey_len	equ $-shiftfkeys

fkeys	db 'QUIT',0,'UNDO',0,'PRINT',0,'MARK',0,'CUT',0,'PASTE',0,'SAVE',0
	db 'DEL EOL',0,'DEL LINE',0,'UDEL L',0
fkey_len	equ $-fkeys
@curseg	ends

include	codeseg.inc
;
;   this displays the function key prompt and capslock state
;
case	dd strnlwr
	dd strnupr

showfkey	proc	near
	push	ebp
	mov	word ptr keynum,'1'

; select fkey display
	movzx	eax,key_status	; gonna use key_status some
				; so put it in AL for speed
; start with ALT test
	lea	ebx,altfkeys
	mov	ecx,altfkey_len
	test	al,altb
	jnz	short c

; test for CTRL key press
	add	ebx,ecx		; point to Ctrl+FKey prompts
	mov	cx,ctrlfkey_len
	test	al,ctrl
	jnz	short c

; test for Shift key press
	add	ebx,ecx		; point to shift+FKey prompts
	mov	cx,shiftfkey_len
	test	al,shiftkey
	jnz	short c

; no Alt, Ctrl or Shift
	add	ebx,ecx		; point to ordinary FKey prompts
	mov	cx,fkey_len

; make the function keys upper case or lower case, depending on
; CAPSLOCK status
c:
	and	al,64
	rol	al,4		; EAX either 0 or 4
	call	case[eax]	; EBX points to prompts, ECX = prompt length

	movzx	ebp,columns	; save number of columns
	mov	dh,rows		; put prompt at last row
	inc	dh
	xor	dl,dl		; column zero
	cmp	bp,40
	ja	short c3
	shl	ebp,1
c3:
	mov	ecx,10
	lea	esi,fkey+1	; start with the numeral

f01:	mov	ah,normal
	cmp	keynum,':'
	jne	short f02
	mov	word ptr keynum,'01'
f02:	call	print

	mov	ebx,esi		; save pointer to prompts
	lea	esi,fkey
	inc	keynum
	loop	f01

; clear the remainder of the row
	mov	al,' '		; space character
	mov	ah,normal
	mov	ecx,ebp
	sub	cl,dl
	jz	short f03
f02d:	call	tputchr
	inc	dl
	loop	f02d
f03:	pop	ebp
	ret

showfkey	endp

print:
	call	p0
	mov	esi,ebx		; point to prompts
	mov	ah,inverse
p0:	lodsb
	test	al,al
	jz	short p9
	call	tputchr
	inc	dl		; next column
	jmp	p0
p9:	ret

@curseg	ends
	end
