; SETUP.ASM for E32 - Copyright (C) 1994 Douglas Herr
;  all rights reserved

include	model.inc

public	setup
extrn	pickstr:near
extrn	tprintce:near
extrn	menuoption:near
extrn	pickcolor:near
extrn	ljsetup:near
extrn	strupr:near
extrn	strlwr:near
extrn	ucursoron:near, getkey:near
extrn	cursoroff:near
extrn	print_msg:near

public	window_mode
extrn	swap_files:near
extrn	display_screen:near

include	dataseg.inc
extrn	inverse:byte
extrn	nul:byte
extrn	display_mode:byte
extrn	dirty_bits:byte
extrn	saved_pos:dword

msg0	db 'Setup',0
setup_menu	label	byte
msg1		db 'Multi-file display',0
msg1a		db 'File display mode',0
msg2		db 'Screen colors',0
msg3		db 'Printer',0
		db 0

setup_dispatch	dd window_mode
		dd ascii_or_hex
		dd pick_color
		dd printer_setup

setup_msg	dd msg1
		dd msg1a
		dd msg2
		dd msg3

mode_menu	db 'ASCII display',0
		db 'Hex display',0
		db 0

printer_menu	label	byte
p0		db 'Clear',0
p1		db 'Landscape',0
p2		db 'Lines per inch: '
lpi_len		equ	$-p2
lpi		db '6',0
p3		db 'Compressed',0
		db 0

printer_msg	dd p0
		dd p1
		dd p2
		dd p3

lpi_prompt	db '1,2,3,4,6 or 8:',0
lpi_prompt_len	equ	$-lpi_prompt

;
; SCREEN COLORS
;

extrn	default_normal:byte
extrn	normal:byte, inverse:byte, warning:byte
extrn	rows:byte, dirty_bits:byte
extrn	window_row:byte

colors	label	byte
nmsg	db 'Normal text',0
pmsg	db 'Prompts and Marked blocks',0
wmsg	db 'Warnings and Error messages',0
	db 0
bgrnd	db 'background',0
fgrnd	db 'foreground',0

color_ptr	dd normal
		dd inverse
		dd warning

msg_ptr		dd nmsg
		dd pmsg
		dd wmsg

;
; WINDOW MODE
;
extrn	rows:byte, window_row:byte

choices	db 'Full screen',0
	db 'Split screen',0
	db 0
two	db 'Two screens',0
	db 0
@curseg	ends


include	codeseg.inc
setup	proc	near
	xor	ebx,ebx

next_setup:
	lea	esi,msg0
	call	print_msg
	lea	esi,setup_menu
	mov	dx,0808h
	call	pickstr
	jc	short setup_exit
	cmp	ax,27
	je	short setup_exit
	push	ebx
	movzx	ebx,bx
	shl	ebx,2
	mov	esi,setup_msg[ebx]
	call	print_msg
	call	setup_dispatch[ebx]
	pop	ebx
	test	dirty_bits,1
	jz	next_setup
	mov	saved_pos,-1
	call	display_screen
	jmp	next_setup
	
setup_exit:
	ret
setup	endp


;
; SCREEN COLORS
;

color_selection	equ	[ebp-2]

pick_color	proc	near
	enter	4,0
select:
	mov	dx,0909h
	xor	bx,bx
	lea	esi,colors
	call	pickstr
	jc	color_exit
	cmp	ax,27
	je	color_exit
	or	dirty_bits,00100000b
	shl	ebx,2
	mov	color_selection,bx
	movzx	ebx,bx
	mov	esi,msg_ptr[ebx]
	call	print_msg

; install trap
	lea	eax,color_message
	mov	ebx,8
	call	menuoption

	movzx	ebx,word ptr color_selection
	mov	ebx,color_ptr[ebx]
	mov	ah,[ebx]	; get selected color
	mov	dx,030Ah
	call	pickcolor

	push	eax
	lea	eax,nul
	mov	ebx,8
	call	menuoption
	mov	esi,eax
	mov	ah,inverse
	mov	dh,window_row
	dec	dh
	xor	dl,dl
	call	tprintce
	pop	eax

	cmp	al,27
	je	short color_exit
	movzx	ebx,word ptr color_selection
	mov	ebx,color_ptr[ebx]
	mov	[ebx],ah
	lea	esi,normal
	lea	edi,default_normal
	mov	ecx,3
	push	ds
	pop	es
	rep	movsb
	or	dirty_bits,1
	jmp	select


color_message:
	pushad
	lea	esi,bgrnd
	test	al,al
	jz	short show_msg
	lea	esi,fgrnd
show_msg:
	mov	dh,window_row
	dec	dh
	xor	dl,dl
	call	tprintce
	popad
	ret

color_exit:
	leave
	ret

pick_color	endp


;
; DISPLAY MODE
;
ascii_or_hex	proc	near
	lea	esi,mode_menu
	mov	dx,0909h
	movzx	ebx,display_mode	; default: current display mode
	shr	ebx,2
	call	pickstr
	cmp	ax,27			; ESC?
	je	short ascii_or_hex_exit
	shl	ebx,2
	mov	display_mode,bl
	or	dirty_bits,00100001b

ascii_or_hex_exit:
	ret
ascii_or_hex	endp



;
; WINDOW MODE
;

window_mode	proc	near
	lea	esi,choices
	mov	dx,0909h
	xor	ebx,ebx			; first choice
	call	pickstr
	cmp	ax,27			; ESC?
	je	short window_mode_exit	;  exit
	mov	al,1			; default: full screen
	cmp	bx,1			; split requested?
	movzx	ebx,al
	jb	short set_window_mode	;  no, keep full screen
	add	al,rows			;  else use rows/2
	shr	al,1

set_window_mode:
	mov	window_row,al
	push	ebx
	call	swap_files
	pop	ebx
	call	swap_files
	or	dirty_bits,00100001b
	push	ds
	pop	es

window_mode_exit:
	ret
window_mode	endp


printer_setup:
	xor	bx,bx

printer_setup0:
	lea	esi,printer_menu
	mov	dx,0909h
	call	pickstr
	cmp	ax,27
	je	printer_setup_exit

	cmp	bx,2			; lines per inch?
	jne	short p5
pf3:
	lea	esi,p2
	call	print_msg
	add	dl,lpi_len
	lea	esi,lpi_prompt
	call	tprintce
	add	dl,lpi_prompt_len
	call	ucursoron
	call	getkey
	call	cursoroff
	cmp	ax,27
	je	short p6
	cmp	ax,'1'
	jb	pf3
	cmp	ax,'5'
	jb	short p4
	je	pf3
	cmp	ax,'8'
	ja	pf3
	je	short p4
	cmp	ax,'7'
	je	pf3
p4:
	mov	lpi,al
	lea	esi,msg3
	call	print_msg
	mov	bx,2
p5:
	movzx	ebx,bx
	call	ljsetup

	or	ebx,ebx
	jnz	short printer_flag_on

; turn all flags off
	mov	ecx,4
	lea	esi,printer_msg

printer_flags_off:
	push	ecx
	mov	ebx,[esi]
	add	esi,4
	inc	ebx
	call	strlwr
	pop	ecx
	loop	printer_flags_off
	mov	lpi,'6'
	jmp	printer_setup

printer_flag_on:
	push	ebx
	mov	ebx,printer_msg[ebx*4]
	call	strupr
	pop	ebx
p6:
	jmp	printer_setup0

printer_setup_exit:
	ret

@curseg	ends
	end
