; SCRNDIM.ASM for E32 - Copyright (C) 1994 Douglas Herr
;  all rights reserved

; set specified screen dimensions
; call with AX = screen rows, BX = screen columns

include	model.inc

public	set_screen_dimensions
public	get_palette, restore_palette

extrn	get_screen_data:near

extrn	mode43:near, mode29:near, mode12:near
extrn	svga132:near, getcrt:near

include	dataseg.inc
extrn	rows:byte, columns:byte
color_dispatch	dd mode43
		dd mode29
		dd dummy
		dd mode12
@curseg	ends

include	codeseg.inc
set_screen_dimensions	proc	near
	call	get_palette
	cmp	bx,85		; separate 132-column modes from others
	ja	short evga132
	push	eax
	mov	ax,3
	cmp	bx,60		; separate 80- and 40-column modes
	ja	short set80
	mov	ax,1
set80:	int	10h		; set 40- or 80-column mode, 25 rows
	pop	eax
	xor	ebx,ebx
	cmp	ax,42
	adc	ebx,0		; BX = 1 if less than 43 rows
	cmp	ax,28
	adc	ebx,0		; BX = 2 if less than 32 rows
	cmp	ax,24
	adc	ebx,0		; BX = 3 if less than 25 rows
	call	color_dispatch[ebx*4]
	jmp	short exit

evga132:
; convert AX to SVGA132 index
	mov	ebx,eax
	xor	eax,eax
	sub	bx,26
	jc	short @svga9
	inc	eax
	sub	bx,(35-26)
	jc	short @svga9
	inc	eax
	sub	bx,(45-(33-26))
	jc	short @svga9
	inc	eax
	sub	bx,(55-(45-(33-26)))
	jc	short @svga9
	inc	eax

@svga9:	call	svga132
	jnc	short exit
	dec	eax
	jns	@svga9

exit:
	call	restore_palette
	call	get_screen_data	; update E32 data area
dummy:	clc
	ret

set_screen_dimensions	endp

pal	db 17 dup (0)
get_palette:
	push	eax
	push	edx
	mov	edx,offset pal
	mov	dword ptr [edx],-1
	call	getcrt
	cmp	al,3		; VGA color?
	je	short its_a_vga
	cmp	ah,3		; VGA mono?
	jne	short palette_exit
its_a_vga:
	push	ds
	pop	es
	mov	ax,1009h	; get palette
	int	10h
palette_exit:
	pop	edx
	pop	eax
	ret

restore_palette:
	push	eax
	push	ebx
	push	edx
	mov	ebx,offset pal
	push	ds
	pop	es
	cmp	dword ptr [ebx],-1
	je	short r9
	mov	edx,ebx
	mov	ax,1002h
	int	10h
r9:	pop	edx
	pop	ebx
	pop	eax
	ret

@curseg	ends
	end
