; READFILE.ASM for E32 - Copyright (C) 1994 Douglas Herr
;  all rights reserved

; call with DS:[EDX] -> ASCIIZ filename

include	model.inc

CR	equ	0Dh
LF	EQU	0Ah

public	readfile
extrn	fexist:near
extrn	working:near
extrn	mload:near
extrn	display_screen:near
extrn	display_hex:near

extrn	error:near

include	dataseg.inc

extrn	display_mode:byte
extrn	file_read_error:byte
extrn	filesel:word
extrn	filesiz:dword			; file size
extrn	buffersiz:dword
extrn	dirty_bits:byte
extrn	cur_posn:byte			; really a word
no_file		db 'file not found',0
@curseg	ends

include	codeseg.inc
readfile	proc	near
	call	working
	call	fexist
	jnc	short r0
	lea	edx,no_file
	jmp	short bad_exit
r0:
	call	mload
	jnc	short r1
	lea	edx,file_read_error
	jmp	short bad_exit
r1:
	xchg	bx,filesel		; get old selector in BX
	mov	filesiz,eax
	mov	buffersiz,eax
	sys	RelMem
	or	dirty_bits,00100000b
	call	is_it_hex
	sbb	eax,eax
	mov	ah,al
	inc	al
	not	ah
	shl	al,2
	mov	display_mode,al
	and	ah,10
	mov	cur_posn,ah
	clc
exit:
	ret

bad_exit:
	call	error
	ret

alphanum	equ	dword ptr [ebp-4]
notalpha	equ	dword ptr [ebp-8]

is_it_hex:
	enter	8,0
	push	es
	mov	ecx,100h
	cmp	filesiz,ecx
	jae	size_ok
	mov	ecx,filesiz
size_ok:
	jecxz	short end_test
	mov	es,filesel
	assume	es:nothing
	mov	edx,-1
	mov	ebx,filesiz
	push	ecx
	call	test_it
	pop	ecx
	jnc	end_test
	mov	ebx,edx			; EBX = -1
	neg	edx			; EDX = 1
	call	test_it

end_test:
	pop	es
	leave
	ret

test_it:
	xor	eax,eax
	mov	alphanum,eax
	mov	notalpha,eax
test_byte:
	add	ebx,edx
	mov	al,es:[ebx]
	cmp	al,'z'
	ja	short its_not_alpha
	cmp	al,0Dh
	je	short its_alpha
	cmp	al,0Ah
	je	short its_alpha
	cmp	al,' '
	jb	short its_not_alpha

its_alpha:
	inc	alphanum
	loop	test_byte
	jmp	short compare

its_not_alpha:
	inc	notalpha
	loop	test_byte

compare:
	mov	eax,notalpha
	cmp	eax,alphanum
	ret

readfile	endp

@curseg	ends
	end
