; MESSAGES.ASM for E32 - Copyright (C) 1994 Douglas Herr
;  all rights reserved

include	model.inc


; WORKING
;
;  prints 'Working' message at bottom of screen

public	working
extrn	tprintce:near

include	dataseg.inc
extrn	warning:byte, key_status:byte, rows:byte
public	file_read_error
file_read_error	db "can't read file",0

w		db ' Working',0
err_msg		db ' ERROR: ',0
err_msg_len	equ	$-err_msg

@curseg	ends


include	codeseg.inc
working	proc	near
	pushf
	pushad
	lea	esi,w
	mov	dh,rows
	inc	dh
	xor	dl,dl
	mov	ah,warning
	call	tprintce
	mov	key_status,0FFh	; force redraw of prompt line
	popad
	popf
	ret
working	endp

@curseg	ends


; YESNO_MESSAGE
;
;  This subroutine displays a message and asks for a Y/N response
;
;  call with [ESI] -> message, AH = color
;  Returns AL = key pressed

public	yesno_message
extrn	yesno:near
extrn	ucursoron:near

include	codeseg.inc
yesno_message	proc	near
	mov	dh,rows
	inc	dh
	xor	dl,dl
	call	tprintce
	mov	dl,cl
	call	ucursoron
	jmp	yesno

yesno_message	endp

@curseg	ends


; ERROR
;
;  print error message and wait for keystroke
;  call with EDX pointing to error message

public	error
extrn	clearkey:near, getkey:near

include	codeseg.inc
error	proc	near
	pushf
	pushad
	mov	key_status,0FFh	; flag to refresh prompt line
	call	clearkey	; clear keyboard buffer
	push	edx		; save pointer to error message
	lea	esi,err_msg
	mov	dh,rows
	inc	dh		; last row of screen
	xor	dl,dl
	mov	ah,warning
	call	tprintce	; print ' ERROR: '
	mov	dl,err_msg_len-1
	pop	esi		; restore pointer to error message
	call	tprintce	; print message
	call	getkey
	popad
	popf
	stc
	ret
error	endp

@curseg	ends
	end
