; CASE.ASM for E32 - Copyright (C) 1994 Douglas Herr
;  all rights reserved

include	model.inc

public	locase, upcase
extrn	advance:near, mark:near
extrn	working:near

extrn	strnlwr:near
extrn	strnupr:near
extrn	clearkey:near

include	dataseg.inc
extrn	cursor:dword
extrn	mark_mode:byte, mark_start:dword, mark_end:dword
extrn	dirty_bits:byte
@curseg	ends

include	codeseg.inc
;
;  locase converts the character at
;  the current position to lower case
;
locase	proc	near
	lea	eax,strnlwr
	jmp	short ul
;
;  UPCASE converts the character at
;  the current position to upper case
;
upcase	label	near
	lea	eax,strnupr
ul:	mov	ecx,1		; default: one character
	mov	ebx,cursor
	cmp	mark_mode,0	; mark mode OFF?
	je	short l0	;  yup, do one character

	mov	ecx,mark_end	; get end of mark region
	mov	ebx,mark_start	; get start of mark region
	sub	ecx,ebx		; number of bytes selected
	call	working

l0:	push	ds
	push	fs
	pop	ds
	call	eax
	pop	ds
	cmp	mark_mode,0	; is mark_mode on?
	jz	short exit	; nope - redraw line & advance cursor
	call	mark
	or	dirty_bits,11000000b
	ret
exit:	or	dirty_bits,4	; redraw line
	call	advance
	ret

locase	endp

@curseg	ends
	end
