/*
+------------------------------------------------------------------------------+
| F U N K Y  C H I C K E N  U T I L I T I E S  v1.00                           |
| (c) 1996 Michael Grundy                                                      |
|                                                                              |
|  Update History:            FILECRC.C                                        |
|  ---------------------------------------------------------------------       |
|  DATE:       AUTHOR:        Description of Change:                           |
|  ---------------------------------------------------------------------       |
|  01/02/96    M. Grundy      Created original version based on Mike Dumdei's  |
|                             32 bit CRC examples.                             |
+------------------------------------------------------------------------------+
| This program is not and will not be warrantied, guaranteed, or supported in  |
| any way. The Author (me) is not liable culpable or even going to feel bad if |
| this program doesn't work, destroys data, or makes fun of your shoes. In     |
| other words: whatever this does to you, it's not my fault. (Lawyers, sheesh) |
+------------------------------------------------------------------------------+
After you compile this link it with the 32CRCF module. I do the following:
CL /AT FILECRC.C 32CRCF_S
(Microsoft C v6)
*/

#include <stdio.h>
#include <io.h>
#include <stdlib.h>
#include <dos.h>
#include <string.h>
#include <fcntl.h>
#include <share.h>

unsigned long blk32crc(unsigned long *CrcIn, char *blk, int count);
unsigned long upd32crc(unsigned long *CrcIn, char databyte);
int get_file(char *file_spec, struct find_t *fileinfo);


char buf[20*1024];

void main(int argc, char *argv[])
{
       FILE *file_to_check;
       int i;
       unsigned long crc, length = 0;
       unsigned day, month, year, hour, minute, second;
       struct find_t source_finfo;        // File info for the source file
                                          // used by findfirst / findnext (FF/FN)
       char file_to_open[_MAX_PATH];      // fully qualified file name of file
       char drive[_MAX_DRIVE],dir[_MAX_DIR],fname[14],ext[14];

       if (argc != 2) {
              printf("Usage: FILECRC [filename]\n");
              exit (2);
              }

       // Break up the given argument into its basic pieces
       _splitpath(argv[1], drive, dir, fname, ext);

       // Print a directory qualifier if needed
       if (strlen(dir)){
              printf("Listing for %s%s\n", drive, dir);
              }

       // Debug
       printf("Name          Length      Date      Time      CRC-32\n");
       printf("------------  ----------  --------  --------  ----------\n"); 

       while (get_file(argv[1], &source_finfo)){

              // Make sure we fully qualify the path name to open the file
              strcpy(file_to_open,drive);
              strcat(file_to_open,dir);
              strcat(file_to_open,source_finfo.name);

              // Open up the file
              if ((file_to_check = fopen(file_to_open, "rb")) == NULL) {
                     printf("Can't open %s\n", source_finfo.name);
                     continue;
                     }

              // init crc out here
              crc = -1L;
              while (!feof(file_to_check)){

                     i = fread(buf, 1, sizeof(buf), file_to_check);

                     length += i;

                     // Block method, slightly faster than byte method
                     crc = blk32crc(&crc, buf, i);

                     } // End while we haven't reached the end of the file
       
              // Shuffle around the time info so we can print it out nice
              second = 2 * (source_finfo.wr_time & 0x1f);
              minute = (source_finfo.wr_time >> 5) & 0x3f;
              hour   = (source_finfo.wr_time >> 11) & 0x1f;
              day    = source_finfo.wr_date & 0x1f;
              month  = (source_finfo.wr_date >> 5) & 0xf;
              year   = ((source_finfo.wr_date >> 9) & 0x7f) + 80;

              // Print out our little report
              printf("%-12s  %10lu  ", source_finfo.name, length);
              printf("%02d-%02d-%02d  %02d:%02d.%02d  ", month, day, year,
                     hour, minute, second);
              printf("0x%08lX\n", ~crc);

              // Reset our length counter and close the file we just checked
              length = 0;
              fclose(file_to_check);
              } // end while there are files matching the command line

              exit (0);
}


//
//  Front ends the find first / find next functions so you only have to remember 
//  one function.
//
int get_file(char *file_spec, struct find_t *fileinfo)
{

// In case you forgot:
//
//     struct find_t {
// 	       char reserved[21];
//      	char attrib;
// 	       unsigned wr_time;
// 	       unsigned wr_date;
// 	       long size;
// 	       char name[13];
// 	       };

	static char stat = 0;
	
	if(stat) {
		
		if(_dos_findnext(fileinfo)){
			stat = 0;
			return(0);
			}
		else {
			return(1);
			}
			
		}
	
	else {
	
              // Use the _A_HIDDEN & _A_SYSTEM to find the little extras
		if(_dos_findfirst(file_spec, _A_HIDDEN | _A_SYSTEM, fileinfo))
			return(0);
		else {
			stat = 1;
			return(1);
			}
		
		}
		
		
}


