/* POV ray tracer image display script.  This script, when run under JoeView */
/* will display the indicated file as it is being generated.  You must have */
/* your pov program outputing to the Targa Format.  Also, pov uses too */
/* much CPU to allow JoeView to run in idle mode.  There is a bug with */
/* the combination of JoeView and this script, in that you cannot select */
/* stop script from JoeView.  If you need it to stop, you will need to */
/* shut down JoeView.  There are two parameters you will need to */
/* enter for this script, they are the file name, and the number of reads, */
/* both are below. */
Call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
Call SysLoadFuncs

/*  Change the variable TheFile to be your input file, include the path */
TheFile = 'D:\POV\data.TGA'

/* This value represents the approximate number of times you want the */
/* image to be rendered while it is being generated by POV */
NumberOfReads = 15

Call SysFileTree TheFile, 'fileinfo', 'F'
Parse Var fileinfo.1 garbage garbage filesize garbage

/* What we are doing here is waiting for the file to have    */
/* a minimum size, this just makes sure that the file's header */
/* is completely written.    */

Do Forever Until filesize > 1000
   Call SysSleep 2
   Call SysFileTree TheFile, 'fileinfo', 'F'
   Parse Var fileinfo.1 garbage garbage filesize garbage
End /* do */

oldfilesize = filesize

/* Telling JoeView to use the quick quantizing method.  Do this while */
/* you are just looking at the partial image.  Its the fastest way and */
/* pretty good.  */

"quantize quick"
"open_file" TheFile

/* Above we opened the file for the first time.  This will cause  the window to */
/* resize.  We now specify that the window will not resize during the following */
/* reads.  This allows you to manually resize the window to the size you want */
/* and it will stay that way.  While we are here, ask JoeView what the image */
/* dimensions are, ignore the rest of the information returned. */

"fixed_window_on"
"get_info"
Parse Var RC width height garbage

/* This size of the file is approximately 3 times the width times */
/* the height of the image.  The % operator is similar to division */
/* but the result is an integer.  The minimum increase calculated */
/* will tell us how much the file must grow before we should read */
/* it again. */
minimum_increase = (width * 3 * height) % NumberOfReads

Do Forever Until done = 0
   /* Attemp to open our file for output.  When we can ( a 0 is returned) */
   /* then the output from POV is done! */
   done = LINEOUT(TheFile,,1)
   Call SysFileTree TheFile, 'fileinfo', 'F'
   Parse Var fileinfo.1 garbage garbage filesize garbage
   If filesize > oldfilesize + minimum_increase then
      Do
         oldfilesize = filesize
         /* Tell JoeView to read the file again */
         "open_file" TheFile
      End
   /* Don't waste the CPU checking the file, let it sleep for awhile, value is seconds */
   Call SysSleep 5
End /* do */

/* POV is done so turn on the better quantizer and let the window resize */
/* and read in the file one more time. */
"quantize best"
"fixed_window_off"
"open_file" TheFile
Call Beep 392, 250
EXIT
