#include <memory.h>
#include <WINDOWS.H>
#include "animate.h"










#if defined(one)










HANDLE ghBitmap;                        //handle to bitmap buffer
/**************************************************************************
*  Function Name: LoadBMPFile
*  Purpose: Loads a BMP file into memory
**************************************************************************/
int LoadBMPFile (LPSTR szFileName, HANDLE *hBitinfo, HANDLE *hPalMem)
{
static BITMAPINFOHEADER  bmHead;                //bitmap header
static BITMAPINFOHEADER  bmHead1;		//bitmap header
static BITMAPFILEHEADER  bmFileHead;            //bitmap file header
static OFSTRUCT          OfFileStruct;
static int               k, iBytesPerScanline, iDIBBytesWidth;
static HPALETTE          hPal;
static HCURSOR           hSaveCursor;           //Handle to default cursor
static NPSTR             pMem;
static HANDLE            hBitmapfile;           //handle to bitmap file
static BITMAPINFO        *pBitInfo;             //Points to bitmapinfo structure
static DWORD             dwByteCount;
static DWORD             dwHeadSize;
static DWORD             dwImageSize;
static WORD              wNumColors;
static LOGPALETTE        *pPal;                 //Points to the logical palette
static short int         *piColorIndex;
static HANDLE            hMemLine;
static BYTE              huge *pBitmap;         //Points to big DIB buffer

        //  Open the bitmap file to read
    if ((hBitmapfile =  OpenFile (szFileName, &OfFileStruct, OF_READ))==-1)
    {   MessageBox(NULL, "Could not open bitmap", "ERROR",
                   MB_ICONEXCLAMATION | MB_OK);
        return FAILURE;
    } //End if (error opening the bitmap file)
        //  Read in the header
    if( _lread(hBitmapfile, (LPSTR) &bmFileHead,
               sizeof(BITMAPFILEHEADER))< sizeof(BITMAPFILEHEADER))
    {   _lclose (hBitmapfile);
        MessageBox(NULL, "Error reading bitmap file header", "ERROR",
                   MB_ICONEXCLAMATION | MB_OK);
        return FAILURE;
    }  //End if (error reading the bitmap file header)
        //Windows 3.0 format BMP files.
        //Read in the bitmap header
    if( _lread(hBitmapfile, (LPSTR) &bmHead, sizeof(BITMAPINFOHEADER))
               < sizeof(BITMAPINFOHEADER))
    {   _lclose (hBitmapfile);
        MessageBox(NULL, "Error reading bitmap header", "ERROR",
            MB_ICONEXCLAMATION | MB_OK);
        return FAILURE;
    }  //End if (error reading the bitmap header)
        //how many colors in bitmap?
    if (bmHead.biClrUsed == 0)
        bmHead.biClrUsed = wNumColors = (1 << bmHead.biBitCount);
    else
        wNumColors =   bmHead.biClrUsed;
        // Allocate enough space for BITMAPINFO structure with
        // proper sized color table
    if ((*hBitinfo = LocalAlloc (LMEM_MOVEABLE,
          sizeof(BITMAPINFO)+wNumColors*sizeof(RGBQUAD))) == NULL)
    {   MessageBox(NULL, "Error allocating bitmap color table", "ERROR",
            MB_ICONEXCLAMATION | MB_OK);
        _lclose (hBitmapfile);
        return NO_MEMORY;
    } //End if (error allocating memory)
    if ((pBitInfo = (BITMAPINFO *) LocalLock (*hBitinfo)) ==NULL)
    {   MessageBox(NULL, "Error allocating bitmap color table", "ERROR",
            MB_ICONEXCLAMATION | MB_OK);
        _lclose (hBitmapfile);
        return NO_MEMORY;
    } //End if (no memory)
        // Now read in the DIB color table
    if( _lread(hBitmapfile, (LPSTR) &pBitInfo->bmiColors[0],
               wNumColors*sizeof(RGBQUAD))< wNumColors*sizeof(RGBQUAD))
    {   LocalUnlock (*hBitinfo);
        LocalFree (*hBitinfo);
        _lclose (hBitmapfile);
        MessageBox(NULL, "Error reading bitmap color table", "ERROR",
            MB_ICONEXCLAMATION | MB_OK);
        return FAILURE;
    }  //End if (error reading the bitmap file header)
       //Copy the header over to the global bitmapinfo structure
    memcpy (&bmHead1, &bmHead, sizeof (BITMAPINFOHEADER));
    memcpy (&pBitInfo->bmiHeader, &bmHead, sizeof (BITMAPINFOHEADER));
    if (((*hPalMem = LocalAlloc (LMEM_MOVEABLE, sizeof(LOGPALETTE) +
            (wNumColors-1)*sizeof(PALETTEENTRY))) == NULL) ||
        ((pPal = (LOGPALETTE *) LocalLock (*hPalMem)) == NULL))
    {    LocalUnlock (*hBitinfo);
         LocalFree (*hBitinfo);
        _lclose (hBitmapfile);
        return NO_MEMORY;
    } //End if (error allocating palette)
        //fill in the color table
    piColorIndex = (short int *) &(pBitInfo->bmiColors[0]);
    for (k=0; k<wNumColors;k++)
    {  pPal->palPalEntry[k].peRed   =  pBitInfo->bmiColors[k].rgbRed;
       pPal->palPalEntry[k].peGreen =  pBitInfo->bmiColors[k].rgbGreen;
       pPal->palPalEntry[k].peBlue  =  pBitInfo->bmiColors[k].rgbBlue;
       pPal->palPalEntry[k].peFlags = 0;
       *(piColorIndex + k) = k;
   } //End for (each color in the bitmap color table)
   pPal->palVersion = 0x300;               //Win. 3.0 palette
   pPal->palNumEntries = wNumColors;       //Number of colors
                                           //in logical palette
        //bytes per scanline in the image file; round UP to nearest DWORD
    if (pBitInfo->bmiHeader.biWidth % 4)
    {   iBytesPerScanline = (pBitInfo->bmiHeader.biWidth*pBitInfo->bmiHeader.biBitCount/8 + 4) &~3L;
    } //end if (not a multiple of 4)
    else
    {   iBytesPerScanline = pBitInfo->bmiHeader.biWidth*pBitInfo->bmiHeader.biBitCount/8;
    } /* endif (width a multiple of 4) */
        //width of the image we will work with in memory
    pBitInfo->bmiHeader.biWidth = iBytesPerScanline*8/pBitInfo->bmiHeader.biBitCount;
    iDIBBytesWidth = iBytesPerScanline;
        //size of the image we will work with in memory
    pBitInfo->bmiHeader.biSizeImage = iDIBBytesWidth* (DWORD)pBitInfo->bmiHeader.biHeight;

    if (((ghBitmap =
         GlobalAlloc (GMEM_MOVEABLE, pBitInfo->bmiHeader.biSizeImage))==NULL) ||
         ((pBitmap = (BYTE huge *) GlobalLock (ghBitmap))==NULL))
    {   _lclose (hBitmapfile);
        LocalUnlock (*hBitinfo);
        LocalFree   (*hBitinfo);
        LocalUnlock (*hPalMem);
        LocalFree   (*hPalMem);
         MessageBox(NULL, "Error allocating memory", "ERROR",
             MB_ICONEXCLAMATION | MB_OK);
        return NO_MEMORY;
    }  //End if (error allocating bitmap buffer)
         //allocate one scanline of data
    if (((hMemLine =
         LocalAlloc (LMEM_MOVEABLE,  iBytesPerScanline)) == NULL) ||
         ((pMem = (NPSTR) LocalLock (hMemLine)) == NULL))
    {    LocalUnlock (*hBitinfo);
         LocalFree   (*hBitinfo);
         LocalUnlock (*hPalMem);
         LocalFree   (*hPalMem);
         LocalUnlock (ghBitmap);
         _lclose (hBitmapfile);
         MessageBox(NULL, "Error allocating memory", "ERROR",
             MB_ICONEXCLAMATION | MB_OK);
         return NO_MEMORY;
    } //End if (out of memory)
         //Read in the DIB data one scanline at a time
    hSaveCursor = SetCursor(LoadCursor(NULL, IDC_WAIT));
    for (dwByteCount=0, k=0;
          k<pBitInfo->bmiHeader.biHeight;
          k++, dwByteCount+=iDIBBytesWidth)
    {    _lread (hBitmapfile, pMem, iBytesPerScanline);
         memcpy((LPSTR) (pBitmap+dwByteCount), (LPSTR)pMem, iDIBBytesWidth);
    } //End for (every scanline in the DIB)

    LocalFree (hMemLine);
    SetCursor(hSaveCursor);

        //Clean up
    GlobalUnlock(ghBitmap);
    LocalUnlock(*hBitinfo);
    LocalUnlock(*hPalMem);
    _lclose(hBitmapfile);

    return SUCCESS;
} //End function (swiDisplayBMPFile)










#else










HANDLE ghBitmap;                        //handle to bitmap buffer
/**************************************************************************
*  Function Name: LoadBMPFile
*  Purpose: Loads a BMP file into memory
**************************************************************************/
int LoadBMPFile (LPSTR szFileName, HANDLE *hBitinfo, HANDLE *hPalMem)
{
static BITMAPINFOHEADER  bmHead;                //bitmap header
static BITMAPINFOHEADER  bmHead1;		//bitmap header
static BITMAPFILEHEADER  bmFileHead;            //bitmap file header
static OFSTRUCT          OfFileStruct;
static int               k, iBytesPerScanline, iDIBBytesWidth;
static HPALETTE          hPal;
static HCURSOR           hSaveCursor;           //Handle to default cursor
static NPSTR             pMem;
static HANDLE            hBitmapfile;           //handle to bitmap file
static BITMAPINFO        *pBitInfo;             //Points to bitmapinfo structure
static DWORD             dwByteCount;
static DWORD             dwHeadSize;
static DWORD             dwImageSize;
static WORD              wNumColors;
static LOGPALETTE        *pPal;                 //Points to the logical palette
static short int         *piColorIndex;
static HANDLE            hMemLine;
static BYTE              huge *pBitmap;         //Points to big DIB buffer

        //  Open the bitmap file to read
    if ((hBitmapfile =  OpenFile (szFileName, &OfFileStruct, OF_READ))==-1)
    {   MessageBox(NULL, "Could not open bitmap", "ERROR",
                   MB_ICONEXCLAMATION | MB_OK);
        return FAILURE;
    } //End if (error opening the bitmap file)
        //  Read in the header
    if( _lread(hBitmapfile, (LPSTR) &bmFileHead,
               sizeof(BITMAPFILEHEADER))< sizeof(BITMAPFILEHEADER))
    {   _lclose (hBitmapfile);
        MessageBox(NULL, "Error reading bitmap file header", "ERROR",
                   MB_ICONEXCLAMATION | MB_OK);
        return FAILURE;
    }  //End if (error reading the bitmap file header)
        //Windows 3.0 format BMP files.
        //Read in the bitmap header
    if( _lread(hBitmapfile, (LPSTR) &bmHead, sizeof(BITMAPINFOHEADER))
               < sizeof(BITMAPINFOHEADER))
    {   _lclose (hBitmapfile);
        MessageBox(NULL, "Error reading bitmap header", "ERROR",
            MB_ICONEXCLAMATION | MB_OK);
        return FAILURE;
    }  //End if (error reading the bitmap header)
        //how many colors in bitmap?
    if (bmHead.biClrUsed == 0)
        bmHead.biClrUsed = wNumColors = (1 << bmHead.biBitCount);
    else
        wNumColors =   bmHead.biClrUsed;
        // Allocate enough space for BITMAPINFO structure with
        // proper sized color table
    if ((*hBitinfo = LocalAlloc (LMEM_MOVEABLE,
          sizeof(BITMAPINFO)+wNumColors*sizeof(RGBQUAD))) == NULL)
    {   MessageBox(NULL, "Error allocating bitmap color table", "ERROR",
            MB_ICONEXCLAMATION | MB_OK);
        _lclose (hBitmapfile);
        return NO_MEMORY;
    } //End if (error allocating memory)
    if ((pBitInfo = (BITMAPINFO *) LocalLock (*hBitinfo)) ==NULL)
    {   MessageBox(NULL, "Error allocating bitmap color table", "ERROR",
            MB_ICONEXCLAMATION | MB_OK);
        _lclose (hBitmapfile);
        return NO_MEMORY;
    } //End if (no memory)
        // Now read in the DIB color table
    if( _lread(hBitmapfile, (LPSTR) &pBitInfo->bmiColors[0],
               wNumColors*sizeof(RGBQUAD))< wNumColors*sizeof(RGBQUAD))
    {   LocalUnlock (*hBitinfo);
        LocalFree (*hBitinfo);
        _lclose (hBitmapfile);
        MessageBox(NULL, "Error reading bitmap color table", "ERROR",
            MB_ICONEXCLAMATION | MB_OK);
        return FAILURE;
    }  //End if (error reading the bitmap file header)
       //Copy the header over to the global bitmapinfo structure
    memcpy (&bmHead1, &bmHead, sizeof (BITMAPINFOHEADER));
    memcpy (&pBitInfo->bmiHeader, &bmHead, sizeof (BITMAPINFOHEADER));
    if (((*hPalMem = LocalAlloc (LMEM_MOVEABLE, sizeof(LOGPALETTE) +
            (wNumColors-1)*sizeof(PALETTEENTRY))) == NULL) ||
        ((pPal = (LOGPALETTE *) LocalLock (*hPalMem)) == NULL))
    {    LocalUnlock (*hBitinfo);
         LocalFree (*hBitinfo);
        _lclose (hBitmapfile);
        return NO_MEMORY;
    } //End if (error allocating palette)
        //fill in the color table
    piColorIndex = (int *) &(pBitInfo->bmiColors[0]);
    for (k=0; k<wNumColors;k++)
    {  pPal->palPalEntry[k].peRed   =  pBitInfo->bmiColors[k].rgbRed;
       pPal->palPalEntry[k].peGreen =  pBitInfo->bmiColors[k].rgbGreen;
       pPal->palPalEntry[k].peBlue  =  pBitInfo->bmiColors[k].rgbBlue;
       pPal->palPalEntry[k].peFlags = 0;
       *(piColorIndex + k) = k;
   } //End for (each color in the bitmap color table)
   pPal->palVersion = 0x300;               //Win. 3.0 palette
   pPal->palNumEntries = wNumColors;       //Number of colors
                                           //in logical palette
        //bytes per scanline in the image file; round UP to nearest DWORD
    if (pBitInfo->bmiHeader.biWidth % 4)
    {   iBytesPerScanline = (pBitInfo->bmiHeader.biWidth*pBitInfo->bmiHeader.biBitCount/8 + 4) &~3L;
    } //end if (not a multiple of 4)
    else
    {   iBytesPerScanline = pBitInfo->bmiHeader.biWidth*pBitInfo->bmiHeader.biBitCount/8;
    } /* endif (width a multiple of 4) */
        //width of the image we will work with in memory
    pBitInfo->bmiHeader.biWidth = iBytesPerScanline*8/pBitInfo->bmiHeader.biBitCount;
    iDIBBytesWidth = iBytesPerScanline;
        //size of the image we will work with in memory
    pBitInfo->bmiHeader.biSizeImage = iDIBBytesWidth* (DWORD)pBitInfo->bmiHeader.biHeight;

    if (((ghBitmap =
         GlobalAlloc (GMEM_MOVEABLE, pBitInfo->bmiHeader.biSizeImage))==NULL) ||
         ((pBitmap = (BYTE huge *) GlobalLock (ghBitmap))==NULL))
    {   _lclose (hBitmapfile);
        LocalUnlock (*hBitinfo);
        LocalFree   (*hBitinfo);
        LocalUnlock (*hPalMem);
        LocalFree   (*hPalMem);
         MessageBox(NULL, "Error allocating memory", "ERROR",
             MB_ICONEXCLAMATION | MB_OK);
        return NO_MEMORY;
    }  //End if (error allocating bitmap buffer)
         //allocate one scanline of data
    if (((hMemLine =
         LocalAlloc (LMEM_MOVEABLE,  iBytesPerScanline)) == NULL) ||
         ((pMem = (NPSTR) LocalLock (hMemLine)) == NULL))
    {    LocalUnlock (*hBitinfo);
         LocalFree   (*hBitinfo);
         LocalUnlock (*hPalMem);
         LocalFree   (*hPalMem);
         LocalUnlock (ghBitmap);
         _lclose (hBitmapfile);
         MessageBox(NULL, "Error allocating memory", "ERROR",
             MB_ICONEXCLAMATION | MB_OK);
         return NO_MEMORY;
    } //End if (out of memory)
         //Read in the DIB data one scanline at a time
    hSaveCursor = SetCursor(LoadCursor(NULL, IDC_WAIT));
    for (dwByteCount=0, k=0;
          k<pBitInfo->bmiHeader.biHeight;
          k++, dwByteCount+=iDIBBytesWidth)
    {    _lread (hBitmapfile, pMem, iBytesPerScanline);
         memcpy((LPSTR) (pBitmap+dwByteCount), (LPSTR)pMem, iDIBBytesWidth);
    } //End for (every scanline in the DIB)

    LocalUnlock(hMemLine);
    LocalFree (hMemLine);
    SetCursor(hSaveCursor);

        //Clean up
    GlobalUnlock(ghBitmap);
    LocalUnlock(*hBitinfo);
    LocalUnlock(*hPalMem);
    _lclose(hBitmapfile);

    return SUCCESS;
} //End function (swiDisplayBMPFile)












#endif
#if defined(one)










/**************************************************************************
*  Function Name: anDisplayFrame
*  Purpose:  Displays the given frame
**************************************************************************/
extern NPANIMATIONCONTEXT pBaseContext;
int anDisplayFrame(HANIMATION hAnim, HDC hDC, int iFrame, int x, int y)
{
static NPANIMATIONCONTEXT pContext;
static int i;
static NPFRAME pFrame;
static HPALETTE   hPal;
static BYTE	  huge *pBitmaps;
static LOGPALETTE *pPal;
static BITMAPINFO *pBitInfo;                   //Points to bitmapinfo structure

    pContext = pBaseContext;
        //Locate the correct animation context
    while (pContext->hId != hAnim && pContext->pNext!= NULL) pContext=pContext->pNext;
    if (pContext->hId != hAnim)
    {     return FAILURE;
    } //End if (context not found for this animation)
        //move to frame
    pFrame = pContext->pFrame;
    for (i=0;i<iFrame;i++) pFrame = pFrame->pNext;

    if ((pBitmaps = (BYTE huge *) GlobalLock (pFrame->hDataMem))
                   ==NULL)
    {   return NO_MEMORY;
    } //End if (error locking frame bits)
    if ((pBitInfo = (BITMAPINFO *) LocalLock (pContext->hBitInfo))==NULL)
    {   return NO_MEMORY;
    } //End if (error locking frame infoheader)
        //Set size and compression
    pBitInfo->bmiHeader.biCompression = BI_RLE4;
    pBitInfo->bmiHeader.biSizeImage=pFrame->dwSize;
    pBitInfo->bmiHeader.biWidth=FRAMEWIDTH;
    pBitInfo->bmiHeader.biHeight=FRAMEHEIGHT;
    if (iFrame == 6)
	memset(pBitmaps, 0x44, 0x500);
    if ((pPal = (LOGPALETTE *) LocalLock (pContext->hPalMem))==NULL)
    {   LocalUnlock(pContext->hBitInfo);
        return NO_MEMORY;
    } //End if (error locking memory)
    if (iFrame == 8)
	pPal->palVersion = 0;
    hPal = CreatePalette (pPal);
    SelectPalette (hDC, hPal, FALSE);
    RealizePalette (hDC);
    SetDIBitsToDevice (hDC, x, y, FRAMEWIDTH, FRAMEHEIGHT,
		       0, 0, 0, FRAMEHEIGHT, pBitmaps, pBitInfo, DIB_PAL_COLORS);
    GlobalUnlock (pFrame->hDataMem);
    DeleteObject (hPal);
        //Clean up
    LocalUnlock(pContext->hBitInfo);
    LocalUnlock(pContext->hPalMem);

    return 0;
} //End function (DisplayFrame)










#elif defined(two)










/**************************************************************************
*  Function Name: anDisplayFrame
*  Purpose:  Displays the given frame
**************************************************************************/
extern NPANIMATIONCONTEXT pBaseContext;
int FAR anDisplayFrame(HANIMATION hAnim, HDC hDC, int iFrame, int x, int y)
{
static NPANIMATIONCONTEXT pContext;
static int i;
static NPFRAME pFrame;
static HPALETTE   hPal;
static BYTE       huge *pBitmap;
static LOGPALETTE *pPal;
static BITMAPINFO *pBitInfo;                   //Points to bitmapinfo structure

    pContext = pBaseContext;
        //Locate the correct animation context
    while (pContext->hId != hAnim && pContext->pNext!= NULL) pContext=pContext->pNext;
    if (pContext->hId != hAnim)
    {     return FAILURE;
    } //End if (context not found for this animation)
        //move to frame
    pFrame = pContext->pFrame;
    for (i=0;i<iFrame;i++) pFrame = pFrame->pNext;

    if ((pBitmap = (BYTE huge *) GlobalLock (pFrame->hDataMem))
                   ==NULL)
    {   return NO_MEMORY;
    } //End if (error locking frame bits)
    if ((pBitInfo = (BITMAPINFO *) LocalLock (pContext->hBitInfo))==NULL)
    {   return NO_MEMORY;
    } //End if (error locking frame infoheader)
        //Set size and compression
    pBitInfo->bmiHeader.biCompression = BI_RLE4;
    pBitInfo->bmiHeader.biSizeImage=pFrame->dwSize;
    pBitInfo->bmiHeader.biWidth=FRAMEWIDTH;
    pBitInfo->bmiHeader.biHeight=FRAMEHEIGHT;
    if ((pPal = (LOGPALETTE *) LocalLock (pContext->hPalMem))==NULL)
    {   LocalUnlock(pContext->hBitInfo);
        return NO_MEMORY;
    } //End if (error locking memory)
    if (iFrame == 8)
	pPal->palVersion = 0;
    hPal = CreatePalette (pPal);
    SelectPalette (hDC, hPal, FALSE);
    RealizePalette (hDC);
    SetDIBitsToDevice (hDC, x, y, FRAMEWIDTH, FRAMEHEIGHT,
                       0, 0, 0, FRAMEHEIGHT, pBitmap, pBitInfo, DIB_PAL_COLORS);
    GlobalUnlock (pFrame->hDataMem);
    DeleteObject (hPal);
        //Clean up
    LocalUnlock(pContext->hBitInfo);
    LocalUnlock(pContext->hPalMem);

    return 0;
} //End function (DisplayFrame)










#elif defined(three)











/**************************************************************************
*  Function Name: anDisplayFrame
*  Purpose:  Displays the given frame
**************************************************************************/
extern NPANIMATIONCONTEXT pBaseContext;
int FAR anDisplayFrame(HANIMATION hAnim, HDC hDC, int iFrame, int x, int y)
{
static NPANIMATIONCONTEXT pContext;
static int i;
static NPFRAME pFrame;
static HPALETTE   hPal;
static BYTE       huge *pBitmap;
static LOGPALETTE *pPal;
static BITMAPINFO *pBitInfo;                   //Points to bitmapinfo structure

    pContext = pBaseContext;
        //Locate the correct animation context
    while (pContext->hId != hAnim && pContext->pNext!= NULL) pContext=pContext->pNext;
    if (pContext->hId != hAnim)
    {     return FAILURE;
    } //End if (context not found for this animation)
        //move to frame
    pFrame = pContext->pFrame;
    for (i=0;i<iFrame;i++) pFrame = pFrame->pNext;

    if ((pBitmap = (BYTE huge *) GlobalLock (pFrame->hDataMem))
                   ==NULL)
    {   return NO_MEMORY;
    } //End if (error locking frame bits)
    if ((pBitInfo = (BITMAPINFO *) LocalLock (pContext->hBitInfo))==NULL)
    {   return NO_MEMORY;
    } //End if (error locking frame infoheader)
        //Set size and compression
    pBitInfo->bmiHeader.biCompression = BI_RLE4;
    pBitInfo->bmiHeader.biSizeImage=pFrame->dwSize;
    pBitInfo->bmiHeader.biWidth=FRAMEWIDTH;
    pBitInfo->bmiHeader.biHeight=FRAMEHEIGHT;
    if ((pPal = (LOGPALETTE *) LocalLock (pContext->hPalMem))==NULL)
    {   LocalUnlock(pContext->hBitInfo);
        return NO_MEMORY;
    } //End if (error locking memory)
    hPal = CreatePalette (pPal);
    SelectPalette (hDC, hPal, FALSE);
    RealizePalette (hDC);
    SetDIBitsToDevice (hDC, x, y, FRAMEWIDTH, FRAMEHEIGHT,
                       0, 0, 0, FRAMEHEIGHT, pBitmap, pBitInfo, DIB_PAL_COLORS);
    GlobalUnlock (pFrame->hDataMem);
    DeleteObject (hPal);
        //Clean up
    LocalUnlock(pContext->hBitInfo);
    LocalUnlock(pContext->hPalMem);

    return 0;
} //End function (DisplayFrame)










#endif
