Competitive Bidding

Introduction
Overcalls
  1NT Overcall
  Jump Overcalls
  Responding to Partner's Overcall
Takeout Double
  Double of 1NT
  Redoubles
  S.O.S. Redoubles and Penalty Redoubles
Bidding After a Preempt
Extending a Preempt
Strength-Showing Cue Bids
Revaluing Your Hand
Competing for Part Scores
Competing Beyond Game Level
Review
Bid Your System
Rules Governing Bidding
//

Introduction:

So far, we have looked mainly at deals in which only one side was bidding.

This makes it easy for that side to communicate and reach the optimum
contract.

Bridge, like life, is often not so neat and easy.

Your opponents may be trying to take the bid too.

Or they may just try to stick in bids to make things difficult for you (as you
should do to them).

In this course, you will learn how to bid when the opponents are bidding.
//

Overcalls:

[Bid,E]
1H
1S

[S]
A Q J x x x
K x x
x x
x x

An "overcall" is a bid made over an opponent's bid when your partner has not
bid.

The requirements are a good suit with 5 or more cards and usually less than
opening strength.

The hand shown is a good example. South has a good 6-card suit and no interest
in playing in the unbid suits.

The only real risk is that partner may think that you have a weaker hand than
this and may not compete for game. So with a stronger hand, you should make a
"takeout double" (covered next).

A benefit of jumping into the bidding is that if the other side wins the bid
and your partner has to lead first, he knows what your best suit is to lead.
//

[S]
Q J x x x x
x x x
-
K x x x

With a hand like this one, you should NOT make an overcall in Spades

Your hand is so weak that you risk going down a bunch.

And if the opponents take the bid in Hearts, you do NOT want partner to lead
Spades. You would rather have partner lead a Diamond so that you could ruff
it.

There is an exception to the above.

If West opens 1H and North and East both pass, you can bid 1S to keep the
opponents from getting the bid cheap.

With East passing out the hand at 1H, there is a good chance that your side
has about half the points and there is no reason not to compete for the bid.
//

[Bid,E]
1C
???

[S]
x x x
A x
K Q J x x
x x x

Q: What should South bid?

A: 1D. You have a good suit which you would either like to play or like
partner to lead if the opponents win the bid.

[Pause]
[S]
Q J T x x
A K x x
x x
x x

Q: What do you bid now?

A: Pass.
     Your Spade suit is not good enough to play.
     You do not want partner to lead Spades.
     Your Heart suit is not long enough to overcall.
//

  1NT Overcall:

[Bid,E]
1H
Pass
2H
2NT

[S]
K J x x
A Q J
K x
Q J T x

Bidding 1NT over an opening bid requires the same kind of hand it takes to
open 1NT:

- 16-18 points and
- stoppers in every suit.

You should have especially good stoppers in the opponent's suit, since you
know for sure that the opponents will attack that suit first.

If the opponents bid and raise a suit, you should have at least 2 solid
stoppers in the suit, although 1 will do if you can run enough tricks off the
top to make your bid. (Common sense always prevails.)
//

[Bid,W]
1H
Pass
Pass
???

[S]
K x x
K Q x x
x x x
Q J x

Making a 1NT bid in 4th chair after a bid and 2 passes or after 3 passes
indicates

- you want partner to bid with a good suit,
- you do not have a good suit to bid,
- you do not have a very strong hand,
- and if an opponent has bid, that you have a stopper in the opponent's suit,
although you may not have a stopper in other suits.

All you are trying to do is keep the opponent from buying the bid cheaply.

If you have a balanced hand with 16+ points, you have to bid something else
first and bid NT later. We will look at alternative bids later.
//

  Jump Overcalls:

[Bid,E]
1H
2S

[S]
K Q J x x x
x
K x x x
x x

A jump overcall is a preemptive bid made with a weak hand in order to rob the
opponents of bidding space.

You also should have a good 6+ card suit and little defensive strength.

In the bidding shown, if West does not like East's Hearts, he will have to bid
something else on the 3 level, thanks to South's preemptive bid.

Like an opening preempt bid, you can bid higher, but whatever you bid, you
should plan on going down no more that 3 tricks non-vulnerable, 2 tricks
vulnerable.
//

  Responding to Partner's Overcall:

[Bid,W]
1S
2H
Pass
???

[S]
x x
Q x x
A K x x x
K x x

In responding to partner's overcall, the thing to remember is that she does
not promise much strength.

If you have good trump support for partner but not a lot of points, you should
not get keep bidding just because of a good trump fit.

With this hand, you should pass. You have 13 points and partner has shown less
than opening strength, so it is unlikely that you have game.
//

[Bid,W]
1H
1S
Pass
???

[S]
Q x x
x x
A K x x x
K x x

With this hand, you should raise to 2S.

This discourages East from bidding again and it lets partner know that you
have support and some points.

With 15-17 points, you should raise to 3S, asking partner to bid game if she
is at the top of her range (10-12).

With 18+ points, you should jump to 4S.
//

[Bid,E]
1D
Pass
1H
1S
Pass
Pass
2D
Pass
Pass
???

[S]
K x x
A x x x
x x
Q x x x

Q: What should South bid?

A: 2S. This is a classic weak auction with points about evenly divided.

East probably has a 5-card Diamond suit and minimum opening strength since she
passed after North's 1S bid.

West probably has less than 10 points, a 4-card Heart suit (since he did not
rebid Hearts), and a 4-card Diamond suit, since his 2D bid is a minimum,
competing type bid.

You must also compete by raising partner's suit.

[Pause]
[Bid+S]
2S
Pass
Pass
3D
???

Q: Now what do you bid?

A: Pass. You have described your hand, so you can leave it up to partner now.
//

Takeout Double:

[Bid,E]
1S
???

[S]
K x
A Q J x x
K J x x
x x

If you were dealer and held South's cards, you would be happy to open 1H.

However, if East dealt and opened 1S, you can no longer bid 1H.

Most people play that you can overcall with a weak hand (less than 10 points)
and a good suit (at least 5 cards to good honors).

That being the case, partner won't know that you have game potential if you
overcall with a hand of opening strength.

Many people play that you have to make a quantitative bid to show when
you have opening strength. That quantitative bid is the Takeout Double.
//

If you have an opening strength hand and an opponent opens the bidding with 1
of a suit, you should normally Double.

A double of higher level contracts is usually made because you think that the
opponents have overbid and you want to collect bigger penalties.

A double of an opening bid of 1 of a suit is a "takeout double". Your partner
is REQUIRED to "take you out" of the double by bidding, even if she has 0
points.

The only exception would be that if your partner (North) has an armful of
Spades, she may pass your double and try to set East.

However, most of the time your partner will bid. She will usually bid her
longest suit; but, if you double an opening bid of a major, partner may bid
the other major with just 4 cards, expecting you to have the unbid major.
//

[Bid,W]
1S
Dbl.
Pass
???

[S]
x x
K J x x x
x x
A Q x x

Partner has doubled the opening 1S bid.

Since you are forced to bid opposite a takeout double, even with 0 points,
you have to bid more strongly if you have good points (9-11).

With the bidding shown, South should bid 3 Hearts, not 2.

There is a very good chance for N-S to make game with this holding.

In fact, if you were certain of North having enough Hearts, you could jump
straight to game. Since you are not certain, just bid 3.
//

[Bid,W]
1S
Dbl.
Pass
???

[S]
K x x x
J x x x
x x x x
x

Q: Bidding goes as shown. What do you bid with the South cards?

A: 2H.

This tells partner that you have less than 8 points and at least 4 Hearts.

If you had one more Club and one less Heart, you would have to bid 2D.
Although that is a rather distasteful bid, Diamonds would be your longest
suit.

Don't even think of leaving 1S doubled in.

It's pretty easy to make a 1 level bid and your King of Spades will probably
be finessed out of you by West, making your hand even more worthless.
//

[Bid,E]
1H
Dbl
Pass
1S
Pass
???

[S]
A K Q x x x
x
K x x
Q J x

If you make a takeout double and partner bids your long, strong suit, don't
go crazy and bid game.

Your partner was forced to bid and may have 0 points.

Normally, if partner makes a minimum bid and you can stand the suit she names,
you must pass unless you have a really strong hand.

If you cannot stand her suit and have a good one of your own, you can bid that
on a minimum level and expect partner to pass.

If you bid another suit and partner raises you, it means she was at the top
of her original bid range (ie: around 8 points) and likes your suit; she
wants you to bid game if you were also at the top of your bidding range.
//

[Bid,W]
1H
Dbl
2H
???

[S]
x x x x
x x x
x x
x x x x

With the bidding shown, South can pass with a very poor hand.

The doubler's partner is no longer forced to bid if the opponent between them
bids.

The reason you are forced to bid if the opponent before you passes is so
that partner's double doesn't get left in.

Once the opponent bids, that is no longer a danger.

If you DO bid after the opponent has bid, you are making a "free bid" and
must have the usual number of points.
//

  Double of 1NT:

[Bid,E]
1NT
Dbl.

[S]
A x
x x x
x x x
K Q J T x x

Unlike doubles of 1 of a suit, doubles of 1NT opening bids are mostly for
penalties, usually when the doubler has a suit that can be quickly set up to
run, like the one shown.
//

[S]
A Q x
K x x
A Q x
Q J T 9

Another time when South might want to double East's 1NT is if South also has a
NT strength hand.

With 34-36 of the total 40 points accounted for in East's and South's hands,
South knows that partner is unlikely to have enough points for game, so South
doubles and rakes in some juicy penalty points.

East's high cards are "under the hammer". If East leads the JS, South plays
the QS. If East leads the KS, South plays the AS. If East leads AH, South
plays low and his KH becomes the high card, etc.
//

[Bid,W]
1NT
Dbl
Pass
???

[S]
Q x x x
A x
Q x x x
x x x

Q: What should South bid?

A: Pass. A double of 1NT is mostly for penalties and you do not have a
biddable suit.

[S]
Q J T x x x
Q x
K x
x x x

Q: What should South bid?

A: 3S. Your hand may not be worth anything on defense.

If West and North both have 16-point hands, you have a good chance for game.

Although you may only have a total of 24 points, it is usually worth 1 or more
extra tricks when you know that all the outstanding points are in a particular
opponent's hand.
//

  Redoubles:

[S]
x
K Q x
A x x x x
x x x x

[Bid,N]
1H
Pass
2H
Double
Pass
Pass
???

A redouble quadruples the points scored if the redouble is left in. It is rare
for someone to redouble expecting to collect quadruple points. There is too
much that can go wrong.

In addition, by redoubling, you give the opponents a chance to correct what
may have been a mistake in leaving the double in.

For example, with the bidding shown, East probably made a mistake by
passing. It's unlikely that he can threaten your side's Heart suit.

If you pass, the bidding is over and you play 2H doubled and will make game
(2 of a major doubled = 4 of a major, which is enough for game).

If you get greedy and redouble, West gets another chance to bid and will
probably bid 2S.

//

[S]
x x x
A Q x
K x x x
Q x x

[Bid,N]
1S
Dbl.
Rdbl

Since redoubles should be rare, they are usually used for reasons other
than trying to collect more points.

One reason is for the opener's partner to show a strong hand (10+ points)
after the opponent makes a takeout double, such as the hand shown.

By redoubling, you communicate to partner that you have a good hand with trump
support.
//

[S]
x x x
x x x
K x x x x
Q x

[Bid,N]
1S
Dbl.
???

If your partner's opening bid is doubled and you have a very weak hand with
a 5-card or longer suit and poor trump support for partner, bid your suit.

With trump support (3+ in the majors, 5+ in the minors) and a very weak
hand, raise your partner one level.

Your goal in bidding with a weak hand is to try to raise the level of the
bidding before your opponents can bid.

With the hand shown, you should raise your partner to 2S rather than bid
your Diamond suit. For one thing, you have a known 5-3 (or better) fit in
Spades and your partner's Diamonds are an unknown.

For another thing, if you bid 2 Diamonds, the opponents can bid 2 Hearts.
If you bid 2 Spades, the opponents have to bid Hearts on the 3 level.
//

  S.O.S. Redoubles and Penalty Redoubles:

[S]
Q 6 2
K J 8 6 3
A 6
A Q T

[Bid,W]
1D
Pass
1H
1NT
Double
Pass
Pass
???

Another type of redouble is called the "S.O.S. Redouble".

If the bidding goes as shown, you do not really want to play 1NT doubled if
partner has a "bust" (a very bad hand) and you cannot bid your longest
suit, which East has already bid, so you redouble, telling partner to bid
his best suit.

All you can do now is hope that North has 5 Spades or 5 Clubs so that you
will have a 5-3 fit.

S.O.S. redoubles are normally made when a side has not agreed on a trump suit.

If your side has freely bid up to game or slam and partner redoubles the
doubled contract, it probably means that she has some feature (like a void)
that the opponents don't know about and also that she is not worried about the
opponents being able to run to another suit of their own.
//

[Bid,W]
1C
1NT
Dbl
Pass
Pass
Rdbl
Pass
???

[S]
Q x x x x
K x
x x x x
x x

Q: What should South bid?

A: 2S. Partner evidently is worried about making 1NT, so you must resuce to
your best suit.

[Pause]
[Bid,W]
1NT
4S
Pass
Pass
Dbl
Rdbl
Pass
???

[S]
x
x x x
K Q J x x x
x x x

Q: What should South bid?

A: Pass. North could have a freak hand like 8 Spades and 5 Hearts and fully
expect to make his bid.

At the same time, he knows that West has no place to run (ie: no suit to bid)
to get himself out of the redoubled contract.

If you "rescue" your partner to 5 Diamonds in this situation, you better have
a very mild-tempered partner.
//

Bidding After a Preempt:

[Bid,E]
3S
???

[S]
x
K J x x
A Q x x
A x x x

You have 16 points but you do not have a good suit to bid over East's preempt.

The proper bid is to double. Most people play that a double of a preempt is
"mostly" for takeout rather than penalties.

A weak-2 bid is a form of preempt and the same principles apply.

With fewer than 16 points, you should pass and give partner a chance to bid.

Since neither West nor North have bid yet, it is entirely possible that West
has half the remaining points in the deck (or more) and E-W might be able to
make the preemptive bid or set you in whatever your partner bids.
//

Responding to a Double of a Preempt -

[Erase]
If you are certain of being able to set the preempt and if you lack a good
suit, you can pass the double for penalties.

If you have less than 8 points, bid your best suit at the lowest level you
can.

If you have more than 8, you have to jump straight to game or partner will
pass your bid with the assumption that you were forced to bid and could have 0
points.
//

Extending a Preempt:

[Bid,N]
3D
Dbl
???

[S]
J x x x
Q J x x
K Q x x
x

If the opponents have strong hands, chances are that they will find a way to
enter the bidding over a preempt and may still get to slam.

For that reason, if your partner preempts and you have a very weak defensive
hand, you should "extend the preempt".

With the hand and bidding shown, you should bid 6D.

You have no sure defensive tricks (Aces or Kings outside of partner's suit)
and partner's bid indicates that she does not have any, so E-W look like they
have a sure slam coming.

After you bid 6D, all E-W can do is guess at a contract and suit to bid and
may easily go wrong.
//

[Erase]
[Bid]
3D
Pass
6D
#$&@!

[W]
9 7 6 4 3 2
J 5
A
7 6 4 2

[E]
A K
A K Q
6
A K Q J T 8 5

The hands shown are from actual play. East had little choice but to settle for
doubling 6D.

E-W had a lay-down grand slam in NT or Clubs and couldn't bid it.

If East had bid 7C over 6D and N-S held the Ace of Diamonds, he would have
been set and lost points.

By doubling, East was assured of setting N-S and getting SOME points, but far
less than he would have won by making 7NT or 7C.
//

Strength-Showing Cue Bids:

[Bid,E]
1D
2D

[S]
A K x x x
K Q J x
x
A x x

A strength-showing cue bid is a bid of your opponent's suit. It indicates that
you are at the top of whatever range your previous bids may have shown.

If you have not bid before but partner has, it indicates support for partner's
suit, interest in slam, and 1st or 2nd round control of the opponent's suit,
usually by way of a singleton or void.

If partner has not bid, a cue bid of the opponent's suit shows more strength
than a takeout double.

South has 19 total points and support for partner in both major suits.

A cue bid tells partner immediately that you have game with as few as 8-9
points from her.
//

[Bid,W]
1C
1H
2C
3C

[S]
A K x
K Q x x x
A x x x
x

South's 3C bid is not an Ace-showing cue bid because a suit has not been
agreed upon by N-S yet.

So the 3C cue bid has to be a strength-showing cue bid promising Heart
support, interest in slam, and 1st or 2nd round control of Clubs.
//

[Bid,E]
1S
Pass
Pass
Dbl
Pass
2S

[S]
x x x x
K x x
K Q x
K J x x

South did not make a takeout double of East's 1S opening bid because he does
not have a good suit, does not have 4 cards in the unbid major, and has a
pretty weak hand for having 12 HCP.

But when North makes a takeout double, South cue bids East's suit to indicate
that he has the maximum points he could have for a passed hand.

Because South IS a passed hand and N-S have not agreed on a trump suit, common
sense tells you that he cannot be expressing an interest in slam.

If North has 15-16 points, she will expect 11-12 points from South for this
bid and may press on to game. But if North was just doubling to keep the
bidding open and only has 11 or 12 points (or less), she may pull up short of
game.
//

Revaluing Your Hand:

In earlier courses, we talked about revaluing your hand when partner bids.

You should also revalue your hand when the opponents bid.

If West opens a weak 2S bid and you have counted 3 HCP for the King of Spades,
you need to downgrade your hand, since there is a good chance that West is
holding the A-Q of Spades over your King.

This means that there is no way your King can win a trick unless West is kind
enough to lead the Ace, which a good player will not do when holding the A-Q.

Always be alert to bids that affect the strength of your hand.
//

Competing for Part Scores:

[Bid]
Pass
Pass
1H
1S
2H
2S
Pass
Pass
???

[S]
x x
J x x x
K x x x
K x

In non-competitive bidding, you would not raise partner to the 3 level with
just 9 points unless partner has shown a strong hand. Partner might raise you
to game (or higher).

In competitive bidding, where it is clear that everyone has minimum hands and
that both sides are competing for a part score, you might go one more level.

Whether you bid on or not depends on the situation. If the opponents have a
40+ leg and 2S would make game for them, you would definitely bid on.

If your side is vulnerable and the opponents are not, you probably would not
bid on, since you could lose more by going set a trick than the opponents
would get for making their bid.
//

[+]
[N]
x x x
A K x x x
A x
Q x x

The fact that North passed after West's 2S bid does not mean that she thinks
your side cannot make 3H.

North's pass is actually a descriptive bid. It says
- North has a minimum opener,
- she has the expected number of defensive tricks for an opening bid (2+).

If North had opened with a distributional hand with no defensive values, she
would have bid again, not passed.

If South had a good defensive hand, he could double. With a highly
distributional hand, South could bid on. With an in-between hand, South might
pass.

Since North has adequately described her hand and does not know what kind of
hand South has, North passes the bidding around to South.
//

The moral is that if you are a beginner playing with a more experienced
player, don't lack the confidence to bid your hand.

When partner passes in an auction like this, don't think that automatically
means that you have to pass too.

Partner is RELYING on you to double or bid on when your hand justifies it.

Bid your system and use logic and common sense.

Notice that when competing for part scores, the side with the higher-ranking
suit has a great advantage, since the other side has to bid one level higher
to win the bid.
//

Competing Beyond Game Level:

[Vul]
Neither
[S]
x
A K Q x x x
K x x x x
K x

[Bid]
1H
1S
3H
4S
???

In non-competitive bidding, you would never bid beyond game level (3NT, 4S,
4H, 5D, 5C) unless interested in slam.

In competitive bidding, you might face the choice of bidding beyond game level
in order to take the bid, or doubling the opponents, or just letting the
opponents take the bid.

This is not much different from competing for part scores, except that you
should be more willing to overbid by two or three tricks to keep the opponents
from making game.

But if the opponent's are sacrificing against you, you do NOT want to overbid.

Bid on if you are pretty sure of game even at a higher level, but double
otherwise.
//

[+]
In this contract, the question is whether to bid 5H, to double, or to pass the
hand around to North to decide.

North's jump raise shows 11+ points and trump support. South has 18 points.
The total of 29+ points is 3+ more than need for a 26-point game in Hearts.

This tells you that you have enough to make 5H. Since partner has no way of
knowing that you have a strong hand, you must bid 5H instead of passing.

Even with 3 fewer points (take away the KC), you should bid 5H. It is likely
that one of your opponent's will be able to ruff your Heart honors if you pass
4S.

Your unsupported minor suit Kings cannot be counted on for tricks, so after
revaluing, you do not have the 2+ defensive tricks promised by an opening bid.
//

Review:

[N]
T 8 7 5 4
2
Q J 9 5
K 8 7

[S]
Q 6 2
K J 8 6 3
A 6
A J T

[W]
A J
Q 9 7
K T 3 2
Q 5 3 2

[E]
K 9 3
A T 5 4
8 7 4
9 6 4

This is a review of the points covered in this course. If you miss any of
the questions, go back and review the relevant lesson.

Q: How many total points does West have?

A: 13.

Q: If West is dealer, what should he bid?

A: 1D.

He doesn't have a 5-card major, so he bids his best minor.

Q: What should North bid after West opens 1D?

A: Pass.

North's hand is not strong enough to double and her longest suit is too
shabby to make an overcall with.
//

[+]
[Bid,W]
1D
Pass
???

Q: What should East bid in the auction shown?

A: 1H.

East cannot raise West's Diamonds. West might have as few as 3 and East has
only 3. By bidding Hearts, West might find a 4-4 Heart fit with West.

Q: How many High Card Points does South have?

A: 15.
//

[+]
[Bid+E]
1H
???

Q: What should South bid in the auction shown?

A: Pass. (Or 1NT.)

There's a lot to be said for passing. If you were first to bid, you would
have to open this hand, but with partner already passing and East bidding
your best suit (which could mean a misfit in all suits), your best bet may
be to sit back and watch E-W get into trouble.

You are 1 point shy of the 16 HCP needed for a 1NT overcall, but when there
are NO bids that fit neatly into your system, you have to fudge somewhere.

If you bid a NT and North has no HCP, you will get chewed up in NT. And if
West doubles your 1NT (for penalties), you have no place to run because
East has already bid your best suit.
//

[+]
[Bid+S]
1NT
Dbl.
Pass
Pass
???

Q: You stuck your neck out and bid 1NT and West doubled, North and East
passing. Now what do you bid?

A: Rdbl.

This is an S.O.S redouble telling partner to pick his best unbid suit.

Since you have 3 cards in each of the unbid suits, you are hoping for partner
to have 5 cards in one of them for a 5-3 fit.

In this case, you are fortunate because North will bid 2S.
//

[Erase]
[S]
J x x x
A Q J x x
A x x
x

[Bid,N]
1S
Pass
???

Q: What do you bid with the hand and bidding shown?

A: 2H.

Your hand is too strong for a simple raise. If partner has more than a
minimal opening hand, you may have a shot at slam, so bid your suit to show
both a good hand and a good suit.

If partner decides to try for slam when you raise her Spades later, she
will know that you have a good Heart suit that she may be able to discard
losers on, particularly if she has something like Kx of Hearts.

If you give an immediate jump raise in Spades, you will never be able to show
partner your good Heart suit.
//

[+]
[Bid+S]
2H
Pass
3C
Pass
???

Q: What do you bid now?

A: 4S.

If you bid 3S, it sounds like a weak bid telling partner which of her suits
you prefer.

That is a bid you would make with 10-12 points. (You would not have bid on the
2 level with less than 10 points.)

You have 15 total points, plus you should upgrade the value of your hand
for the long trump support (3 are "expected") and good side suit.
//

[+]
[Bid+S]
4S
Pass
4NT
Pass
???

Q: Partner bids 4NT. What do you respond?

A: 5H.

4NT in this situation is the Blackwood Convention asking for Aces.

You bid 5C with all or none, 5D with 1, 5H with 2, and 5S with 3 Aces.
//

[+]
[Bid+S]
5H
Pass
6S
Pass
???

Partner now bids 6 Spades.

Q: What do you bid?

A: Pass.

There are no additional features to your hand that you have not already
described

And you know that there is at least one Ace out, since partner did not bid 5NT
to ask for Kings, as she would have done if she knew your side had all the
Aces.

So there is no reason for you to press on.
//

[Erase]
[S]
Q x x x
A Q T x x x
x x
x

Q: You dealt. What do you bid with those cards?

A: Pass.

If partner has not bid yet, it is not a good idea to open a weak two (2H)
when you have 4 cards in the other major. You could easily be preempting
your partner out of a cold game in Spades.

[Bid,S]
Pass
1C
1S
3C
???

Q: What do you respond to the bidding shown?

A: 4S.

You already had 11 total points, and after partner bids Spades (showing at
least 5), you upgrade your hand more for your long Spades, your very good
side suit, and your singleton in the opponents' suit.

If you bid 3S, partner may pass and this is almost a cinch for game.
//

[Erase]
[S]
A x
K Q x
Q J x x
A x x x

Q: What do you bid with the cards shown?

A: 1NT.

You have 16 HCP (the 1NT range is 16-18) and no 5-card major suits and
stoppers in every suit - a classic notrump opener.

[Bid,S]
1NT
Pass
2S
Pass
???

Q: Partner responds 2S. Now what do you bid?

A: Pass.

Partner has a weak hand (6-8 points) and can't stand notrump, so she has
corrected the bid to her best suit.

Since you are at the bottom of the range of your opening bid, there is no
reason for you to bid on.
//

[Erase]
[S]
K J x x x
x x
A x x
Q x x

[Bid,N]
1NT
Pass
???

Q: What do you respond to partner's 1NT opening?

A: 3S.

A 2S response would be weak and adding your 10 HCP to partner's 16-18, you
are sure of a game, so you make a strong bid by jumping one level in your
suit.

[Bid+S]
3S
Pass
3NT
Pass
???

Q: Partner responds with 3NT. Now what?

A: Pass.

[Bid+S]
Pass

Partner probably has a hand like the one shown and doesn't want to be in a
5-2 Spade fit. You've told your story, so there is no reason to bid on.

[N]
A x
K Q x
Q J x x
A x x x

[S]
K J x x x
x x
A x x
Q x x

//

[Erase]
[S]
Q J T x x x x
Q x
x x x x
--

Q: Partner opens 1NT, what do you bid? (Hint: Use logic, not memory!)

A: 4S.

This type of hand was not actually covered in the lesson, but like so much
of bridge, once you know the basics you can figure some things out with
common sense.

First of all, your hand could be absolutely worthless in NT if partner is
not able to get to your hand after establishing Spades.

Add to that your void and 7-card spade suit, and you don't even want to
TALK to partner about NT, and it is highly unlikely that you have slam, so
just bid the game in Spades.
//

[Bid,S]
1H
Pass
1S
Pass
2H
Pass
4H
Pass
???

[S]
x x
A Q J x x x
K x x
Q J x

Q: What do you bid next?

A: Pass.

4 Hearts is game. There is no point in bidding more unless you think your side
can make slam.

Partner's jump to 4H is a "limit" type bid and does not show any super
strength.

Your hand is rather minimal, so a pass is in order.
//

[Bid,N]
1NT
Pass
???

[S]
A Q x x
K x
K Q x x
J x x

Q: Partner opens 1NT. What do you bid with the hand shown?

A: 4NT.

You have 15 HCP. If partner has 18 or a good 17, you want to be at slam.
If partner has a minimal NT opener, she will pass your 4NT bid.
//

[Bid,N]
2S
Pass
???

[S]
K
A K x x
A K J T x x
K x

Q: What do you bid?

A: 2NT.

This is a "feature asking" bid asking partner to bid any stoppers he has.
//

[Bid+S]
2NT
Pass
3S
Pass
???

Q: Partner rebids Spades. Now what do you bid?

A: 4S.

With 21 points in your hand you HAVE to have enough for game even if partner
is at a minimum.

Since partner denies honors for transportation in other suits, you have to
have Spades for trumps in order to make partner's Spades.

If you were to bid 3NT, you might never get to North's hand to make his
Spades and you do not have 9 sure tricks in your hand.

While an 8-card suit is preferred, a 6-1 fit is not all that much worse. In
this case, South has the King and North has promised no worse than 3 of the
top 5, so trumps should not be a problem.

[N]
Q J T x x x
J x x
x
J x x

//

[Erase]
[Vul]
E-W
[Bid,W]
2H
Dbl
4H
???

[S]
J T x x x x x
J x
x x
x x

Q: What should South bid?

A: 4S. But no thanks to North.

[Bid+S]
4S

[N]
A Q x
A
A K J x x
A K T x

This deal and bidding is from a computer bridge game, Bridge Baron V.
(Unfortunately, Bridge Baron is probably the "strongest" PC bridge game.)
;BB hand #1642998640

North had the cards shown and only doubled, despite having 25 HCP.

The only reason South bid was to "sacrifice" against E-W's vulnerable game in
Hearts, yet a slam in Spades is a virtual lay-down for N-S.

North should have cue bid with 3H instead of doubling. And after South has
made a free bid at the 4 level, North must explore for slam.
//

[Erase]
[Vul]
Neither
[Bid,W]
1D
Pass
1S
???

[S]
Q J x x x
A x
Q x
x x x x

;BB #1642998608
Q: What should South bid?

A: Pass.

When an opponent bids at a low level a suit in which you have 5+ cards, do NOT
double.

At best, you warn the opponents to look for another suit.

At worst, you tell the opponents that you have the trumps stacked and they may
be able to play around that fact and make their bid.

Worse yet, your partner will probably interpret a double as being for takeout
and bid some large number of Hearts, for which you have little support.
//

[Erase]
[Bid,N]
1S
Pass
???

[S]
-
x x x x
Q T x
A J x x x x

Q: What do you bid with South's cards?

A: 1NT.

This shows less than 3 Spades and less than 10 points.

You actually have 10 points counting distribution, but you cannot count the
points for a void when it is in your partner's suit.

If North rebids Spades, showing 6, you'll just have to grit your teeth and
pass, but a 6-0 fit is better than a 5-0 fit and you will have at least tried
for another suit.

(In the actual game, North bid 2D, South passed, and N-S played in a 5-3 fit
making 3D.)
//

[Erase]
[S]
A J x
T x x x x
A K
K x x

;#1642998642
Q: You (South) dealt. What do you bid?

A: 1H. Bid the 5-card major, no matter how weak looking.

[Bid,S]
1H
Pass
2D
Pass
???

Q: Now what?

A: 2NT.

You can't rebid such a poor Heart suit without 6+ of them.

You can't raise partner with just 2.

You don't have another suit to bid.
//

[+]
[Bid+S]
2NT
Pass
3D
Pass
???

Q: And now?

A: 4D.

Partner has to have at least 6 (and probably more, since she doesn't have the
A-K) Diamonds both to bid them unsupported on the 3 level and to pull you out
of NT into a minor suit.

She probably has 7 or 8 Diamonds.

Partner had to have 10+ to bid on the 2 level the first time around, although
the simple rebid of 3D limits her to the 12-14 point range.

Still, as many as 14 points added to your 15 are enough for game. Make the
invitation by bidding 4D. (If you feel bold, bid 5D.)
//

Bid Your System:

The bids described in these courses are not absolutes. However, they are
considered "standard" bids.

It is important to know the standard bids, but once you do, you can bid
anything you and your partner agree to.

The only catch is that if you use a non-standard bid, the bidder's partner
must alert the opponents (simply by saying "alert" when partner makes the bid)
and IF ASKED, explain what you think the bid means.

Many conventions and unusual bids are covered in the higher levels of
CardShark Bridge Tutor.

Once you and your partner agree what bids should indicate, it is extremely
important that you stick to those meanings.
//

As we have seen, your partner's bids depend on what your bids indicate about
your hand.

If you promise 16-18 points or a 5-card major or that you have stoppers in
every suit and partner overbids (or underbids) because you do not, it affects
not only the current hand, but the bidding on future hands because partner
cannot be sure your bids mean what they should.

When you register CSBTutor, you will receive a summary sheet that shows what
to bid with various holdings and point counts.

Since bidding is supposed to be open and above board, nobody should object to
your using this sheet during bidding while you are learning.

In addition, you should go through the CSBT courses until you are able to get
most, if not all, of the answers to questions right.
//

This is the last of the Level 1 courses covering bidding. There is a lot more
to bidding that is covered in the next Level.

There's an old line we used to quote in high school to try to get out of
homework:

"The more you study, the more you learn. The more you learn, the more you can
forget. The more you CAN forget, the more you WILL forget. The more you
forget, the less you know, so why study?"

There is some truth to that in bridge. If you try to learn everything at
once, you will probably end up forgetting everything. If you can remember
the essentials, you will probably do better than most of the people you
play with socially.
//

For example, it's helpful to know that you can open the bidding a little
differently after two people have passed than you can otherwise - and that
will be covered in the next Level.

But if you always bid normally and correctly in ANY position, you will usually
do quite well.

Three keys to bidding well are:
1. Count your points before doing anything and
      add the points indicated by partner's bidding
      to yours to determine your subsequent bids.
3. Bid your system, but use common sense as well.
4. Trust your partner.
//

Rules Governing Bidding:

If you do not hear a bid, you may ask for it to be repeated.

At your turn or after the final pass, you can ask that the whole bidding
sequence be repeated by asking for "a review of the bidding".

Comments and questions about bidding should never take place between partners.
Only an opponent may respond to a question.

If the opponent who is reciting the bidding makes an error, your partner may
correct him.

At your turn to play, you can ask an opponent how he interprets his partner's
bid.
//

You may change your bid if you do it immediately and without thinking.

In other words, you cannot say: "1S... Nooooo, wait a minute. I better pass."

If you change a bid from the original suit bid and the opponents take the bid,
declarer has the right to either prohibit or require your partner to lead the
suit you mentioned for as long as your partner maintains the lead.

If you change a bid from a non-suit bid, declare can prohibit your partner
from leading an one specified suit.

If you bid too little (eg: partner opens 1S and you reply 1H), you can correct
to a sufficient bid or a pass without penalty.
//

The rules governing bidding out of turn are complicated and it is highly
unlikely that the social player will remember them or that if you do, that
your friends will believe you. <grin>

You can either keep a rule book at hand when you play and look up the options
when someone bids out of turn, or you can just agree to a simple compromise.

Simple compromise:

1. If someone bids out of turn, bar them from bidding for the rest of the
auction.

2. Give declarer the same lead directing options as for changing a bid.
//

Cards Exposed During Bidding -

If a card is exposed to one or more players during bidding, it must be left
face up on the table.

When play begins, if the offender is on defense, the card becomes a penalty
card.

(Play of penalty cards will be discussed in the course on playing.)
//

[End]
