Introduction and Opening Bids

Introduction
The "Hardware"
The Game
Entering Answers to Questions
Choosing a Trump Suit
The Goal of Bidding
Relative Suit Rankings
Scoring
Bid To Communicate
Evaluating Your Hand
Distribution Points
Opening 1 Of A Suit
Opening Convenient Minors
Opening A Suit with 16+ Points
Notrump Openings
Opening A Suit With 22+ Points
Opening With 6-12 Points And A 6-Card Suit
Opening Weak Hands With 7+ Card Suits
Review Questions
Wrap-Up
//

Introduction:

Welcome to the CardShark Bridge Tutor. This is the first course in the
series. From this point, you can work through this entire course by
selecting Continue. When you move into a new lesson, the lesson name
flashes at the top of this window.

If text appears to be going off the bottom of this box, you can reduce the
font size by clicking above the top left corner of this text box. To
increase the font size, click above the top right corner.

You can go back to a prior screen by selecting Go Back. However, if the
prior screen was using a bridge hand from an earlier screen, the program will
back up to the first screen that displays the hand/bidding.

You can then click Continue to move to the desired screen. Lessons are rarely
more than 4-5 screens long.
//

Bridge is a game that tests your powers of logic, your memory, and your
ability to analyze situations and make deductions from what you hear and
see.

Bridge is a complex game that can take many years of study and experience to
master. Playing the game socially requires far less study; however, books on
bridge, even introductory ones, often mix intermediate and advanced topics in
with discussions of beginning level topics.

CardShark Bridge Tutor Level I is designed to teach the general concepts of
the game and the essentials needed to play the game.

After completing Level I, you should be able to perform acceptably in a
friendly game. You may not always make the optimum bid or play, but even
experts don't ALWAYS bid and play perfectly. If you try to learn too much at
once, you probably will not remember any of it.
//

Level I is divided into two sections, Bidding and Playing. The sections are
divided into courses, with each course being a separate disk file. The course
you are looking at now covers the introduction to bidding. Each course is
divided into lessons.

Level I is shareware, which means that the copy you got from a BBS or disk
vendor is for evaluation purposes only. To license the program for
continued use, click the Register button.

Higher levels cover bidding and playing systems which help you handle unusual
situations and communicate even more precisely during bidding.

Higher levels are NOT shareware and may only be ordered directly from
the author. Click "Register" for ordering information.
//

We will assume that you are familiar with regular playing cards and the
four suits, Clubs, Diamonds, Hearts, and Spades.

To save space, abbreviations are used in some places for cards and suits.
For example: TD = Ten of Diamonds, AS = Ace of Spades, 7C = 7 of Clubs, etc.
You can use the same abbreviations when responding to questions.

When asked a question, enter your responses in the box in the bottom left
corner of this window and press Enter when done.

To save time when setting up problem hands, cards of a value under 10 are
often indicated with an x, since their exact values are usually not
critical in arriving at the right bid. Example: Instead of "A K 9 8", we
will say "A K x x".
//

There are frequent questions to reinforce what you have read.

Many of the questions are about EXCEPTIONS to what you have just learned or
about hands that LOOK LIKE what you have just learned, but are different.

The point is to get you to think about what you have learned. If you can
understand not only the criteria for a bid, but also why a hand does not meet
that criteria, then you have a much deeper understanding of what you have
learned.

In this tutorial, genders are randomly mixed when referring to players for the
sake of equality. There is no significance to a player being referred to as
"he" or "she" (or both).
//

The "Hardware":

Bridge is a four-player game - two pairs of partners with the partners
sitting across the table from each other.

In Bridge writings, the player positions are referred to as North-South for
one team, East-West for the other.

On the left side of this window you see 4 boxes in a diamond pattern with a
larger box underneath. At times, the cards held by the different players
will be displayed in these boxes and bidding shown in the large box.

In Bridge writings, the suits are always displayed in this manner with
Spades on top, followed by Hearts, Diamonds and Clubs.
//

In Bridge, a standard deck of cards is used, excluding Jokers. The 52 cards
are shuffled, cut, and dealt clockwise, starting with the player on the
dealer's left. The turn to deal also moves around the table clockwise.

Two decks of cards are normally used and alternated for each deal in Bridge.
While your partner deals one deck, you shuffle the other. The cards should
have different designs or colors on their backs so that the decks to not
become intermixed.

When you are through shuffling, you place the deck on the corner of the table
to your right. Then for the next hand, the opponent on your right will deal
that deck while his partner shuffles the cards just played.

Before dealing the cards, the dealer pushes the deck over to the opponent on
his right for that opponent to cut.
//

When all the cards have been dealt, pick up your stack of cards and sort
them into suits.

Alternate the suits in the hand by color - black, red, black, red. If you put
two suits of the same color side-by-side, it makes it harder to differentiate
the two and leads to errors.

Sort the cards within each suit with the highest (Ace) on the left and the
lowest (the two or "deuce") on the right.

Bidding starts with the dealer and keeps going clockwise around the table -
possibly several times around - until three people in a row pass. In other
words, if you deal and bid and your opponents and partner pass, you cannot bid
again.

If all four players pass, the deal is thrown in.
//

The Game:

The game of Bridge is divided into two parts, each equally important:
Bidding and Playing. First you bid the number of winning cards you think you
and your partner can have, then you play and try to win at least that many.

Although the Bidding comes first, in order to understand what you are bidding
on, we'll briefly look at the mechanics of play.

When play commences, one person leads a card of his choice from his hand.
Everyone else must play a card of the same suit ("follow suit") if possible. If
you cannot follow suit, you can play any other card from your hand that you
wish.

The play of a card by each of the four players is called a "trick". Since
each hand has 13 cards, there are 13 tricks in a game. A trick is also
referred to as a "round" of play.
//

Normally, the high card played wins ("takes") the trick. The exception is that
if you cannot follow suit, you may win the trick by "trumping" it with a card
from the suit determined by the bidding to be the trump suit. If more than one
person trumps, the high trump card wins.

Each team wants trump to be the suit in which they have the most cards
(and preferably with the highest cards).

Getting the right to name the trump suit is the purpose of bidding. The
team that bids that they can make the most tricks if their suit is trump
wins the bid and their suit becomes trump.

(Throughout this tutorial, beginning on the next screen, you will be asked
questions to reinforce learning. Read each screen carefully before continuing
on to the questions.)
//

Entering Answers to Questions:

If answers are not entered in the Answer box exactly as the program has it,
you will be told the answer is wrong. If you know that you had it right, don't
worry about it, just continue.

When asked for a suit, just enter the first letter (eg: "S" or "s"). Enter "P"
for Pass, Dbl for Double, Rdbl for Redouble.

Enter more than one suit as follows: "S, H" or "D, C, NT".
Enter bids with no spaces (eg: "1S" or "1s").

Enter card values as one letter or number: "A", "T", "9". Enter ranges of
points like "6-10", "10+", and "<10".

Enter Yes or No with just the first letter: "Y" or "N".
//

Choosing a Trump Suit:

[S]
Q 6 2
K J 8 6 3
A 6
A J T

Q: In the deal shown, which suit do you think this player (South) would like
to have as trump?

A: H.

In just looking at his own hand, South would want Hearts for trumps because
that is his longest suit and it also has some high cards.

For example, after two rounds of Diamonds have been played, South could use
his small Hearts to trump Diamond tricks which East-West might otherwise
win.
//

[N]
T 8 7 5 4
2
Q J 9 5
K 8 7

[S]
Q 6 2
K J 8 6 3
A 6
A J T

[W]
A J
Q 9 7
K T 3 2
Q 5 3 2

[E]
K 9 3
A T 5 4
8 7 4
9 6 4

Q: Now, looking at the all four hands, which suit do you think North-South
would like for trumps?

A: S.

North-South would like Spades to be trumps because that is their longest
suit (combining both their hands). East-West own the Ace, King and Jack of
Spades, but once three rounds of Spades have been played, North's little 5
and 4 will win two tricks, since trumps beat any cards in any other suit.

If some other suit is trump, it's doubtful that the spade 4 or 5 would win any
tricks because after three rounds of Spades, somebody is sure to be
trumping the rest of them.
//

Even though South has as many Hearts as North has Spades, you almost always
want the longest COMBINED suit to be trumps.

The more trumps your opponents have, the more chances they have to use them
against you.

You rarely want to pick a suit for trumps that has a combined total of less
than 8 cards in it.

If your side just has 7 cards, the opponents have 6, which greatly reduces
your advantage in naming trumps.

And of course if you just have 6 or fewer trumps, your opponents have more
trumps than you do!
//

Q: Which suit do you think East-West would like to have as trumps?

A: H. -- if a "suit" must be picked.

If you picked Hearts because it has higher cards than the other three
7-card suits of the combined hands, you are right, but this was a trick
question. There is another option for when a team doesn't have any one long
suit: "notrump".

In notrump ("NT"), the high card in the suit led always wins the trick
because nobody can trump in.

With hands like East-West, since you do not have a long suit yourself, you
want to make sure that your opponents do not win tricks by trumping with
their long suits, so given the choice, you would opt for notrump.
//

The Goal of Bidding:

The goal of bidding is to make your team's best suit the trump suit or to play
the deal in notrump if that is best for you. The team that gets to pick the
trump suit is the one that bids the most tricks.

[N]
T 8 7 5 4
2
Q J 9 5
K 8 7

[S]
Q 6 2
K J 8 6 3
A 6
A J T

[W]
A J
Q 9 7
K T 3 2
Q 5 3 2

[E]
K 9 3
A T 5 4
8 7 4
9 6 4

In the deal shown, if Spades were trump, North-South should be able to win two
Club tricks with the Ace and King, at least two Diamond tricks, probably a
Heart trick, and a couple of Spades, for a total of at least seven tricks.
Since there are 13 tricks total, N-S can win more tricks than E-W if Spades
are trumps.

If East-West win the bid in notrump, they could win three Spades, at least two
Hearts, at least one Diamond, and possibly a Club, for a total of about seven
tricks. So if notrump is bid, E-W can win more tricks than N-S.
//

Since there are 13 tricks (52 cards divided into 4 hands), presumably the team
with the better hands will be able to take more tricks. At a minimum, they
will have to take 7 tricks to the opponent's 6.

Since you have to be able to take more than six tricks to beat your opponent
in a given trump suit or notrump, bidding is simplified by assuming that you
are bidding some number MORE than six tricks.

For example, if N-S bid "1 Spade", that means they expect to take at least 1
trick more than the 6 tricks assumed for any kind of bid, so they are really
bidding that they will take 7 tricks if Spades are trump.
//

Q: How many tricks are there in a deal?

A: 13.

The 52 cards are dealt equally to the four hands, 13 each. Each player
plays one card on each trick, so there are 13 tricks.

Q: If you want to bid that your team can take a total of 9 tricks if Spades are
trumps, what do you bid?

A: 3S.

Subtract 6 from the number of tricks you expect to take.
//

Relative Suit Rankings:

For purposes of bidding, the suits have different ranks. From high to low,
they are Spades, Hearts, Diamonds, and then Clubs.

This means that if someone bids one Heart, you can still bid one Spade because
FOR PURPOSES OF BIDDING, Spades are higher than Hearts. So if someone bids one
Spade and you like Hearts, you have to bid TWO Hearts.

For purposes of bidding, notrump outranks the suits; that is, you can bid
"1NT" over "1S", and you have to bid 2 of any suit over 1NT.

During play, the suit rankings have no effect on winning a trick.

//

Q: List the suits in bidding rank order from lowest to highest, including
notrump. (Just enter the first letter of each suit. Use NT for notrump.)

A: C, D, H, S, NT

Q: If someone bids 1 Heart and you like Diamonds, what is the least you can
bid?

A: 2D.

Diamonds rank lower than Hearts, so you have to bid higher.
//

Q: If someone bids 1 Club and you like Hearts, what do you bid?

A: 1H.

Hearts rank higher than Clubs, so you can still bid one.

Q: If someone bids 1 Spade and you like notrump, what do you bid?

A: 1NT.

Notrump ranks higher than the suits.
//

Scoring:

During play, if you take at least the number of tricks you bid, you get
points. If you do not make your bid, you "go set" and your opponent makes
points.

If your opponents think you have overbid and are pretty sure of being able to
keep you from making your bid (they can "set" you), they may "double". If you
go set, the opponents get twice the usual points. If you make a doubled
contract, you get twice the points plus "50 for the insult."

If you are confident of making a doubled bid, you can "redouble". In this
case, you (or your opponents) get 4 times the usual points.

The concept of doubling to try to double your winnings is pretty common.
Backgammon has the "doubling cube". Blackjack lets you "double down".
//

For purposes of scoring, if trumps are Clubs or Diamonds, each trick over 6
that you take is worth 20 points.

If trumps are Hearts or Spades, each trick over 6 that you take is worth 30
points.

In Notrump, the first trick over 6 is worth 40 points and the rest are worth
30 points each.

Because Hearts and Spades are worth more, they are referred to as the "Major
Suits" and Clubs and Diamonds are the "Minor Suits".
//

Q: N-S bid 3 Spades and took a total of 10 tricks. How many points do they get?

A: 120.
They get 30 points for each of the 4 tricks taken after the first 6.

Q: 4 Diamonds were bid and made. How many points are scored?

A: 80.
Twenty points for each trick bid and made.

Q: How many points are scored for making 3 Notrump?

A: 100.
Forty points for the 1st trick and 30 for each of the next two.
//

Q: Which two suits are known as the Majors? (Just enter the first letter of
each suit; eg: A, B)

A: H, S

Q: Sneak Review: If someone bids 1H and you like Diamonds, what do you have to
bid?

A: 2D.

Diamonds rank lower than Hearts so you have to bid on the next level to out
bid Hearts.
//

If that's all there were to the bidding and scoring, each team would always try
to make the lowest bid with which to win the bid, just like in a real auction.

However, in Bridge, the first team to get 100 points or more wins a game.

Only the tricks that you BID count towards the game total of 100 points.

On the following screens, the basics of scoring will be discussed.

This may seem dull or even confusing, but the scoring situation is often
critical to how you bid, so it is important to read through this section until
you understand it.
//

[BMP:SCORE1.BMP]
The picture on the left shows a Bridge score pad.

N-S scores are on one side and E-W scores, on the other.

Points won for tricks bid and made go below the horizontal line.

Points made for "overtricks" and for setting opponents go above the line.

Only points below the line count towards a game.

Sometimes a 100+ point game can be bid and made in one deal. Other times, it
can drag on a long time with teams going set or bidding only part-games.
//

Q: Where do points for tricks bid and made go?

A: Below the line.

Q: Where do points for extra tricks made go?

A: Above the line.

Q: How many points does it take below the line to make game?

A: 100.
//

If you can bid and make 4 of a Major (Hearts or Spades, remember?), you will get
120 points (4 x 30), which is more than enough for Game.

But if you only bid three, you only get 90 points "below the line" to count
towards game; the points for any extra tricks you take go above the line.

Notice that you have to bid FIVE of a Minor to make Game (5 x 20 = 100) and only
THREE notrump (40 for the first trick, 30 each for the next two).

This means you have to take 11 tricks (ie: you can only lose TWO tricks!) to
make game in a Minor, only 10 tricks to make game in a Major, and only 9
tricks in notrump.
//

Q: How much do you have to bid to make game in Spades?

A: 4. (4 * 30 = 120. Game is 100.)

Q: How much do you have to bid for game in Diamonds?

A: 5. (5 * 20)

Q: How much do you have to bid for game in Notrump?

A: 3. (40 for the first, 30 for each of the next 2.)

Q: How many TRICKS do you have to take to make game in Notrump?

A: 9. The 3 bid plus the first 6 which are assumed in the bidding.
//

It is more difficult to make game in notrump than in a suit since you must have
control of every suit in notrump, so it is fair and just that you should have to
take fewer tricks in notrump to make game.

But the Majors requiring one less trick to make game than a Minor suit is Just
The Way It Is.

There will be plenty of times when neither team has enough points to bid and
make game and will thus only get a part-score (ie: "part of a game") below the
line. This is referred to as a "leg".

Q: You bid 3 Spades and made 4. How many points do you get below the line?

A: 90. (30*3) You also get 30 above the line for the overtrick.
[BMP:SCORE2.BMP]
//

After one team reaches or passes 100 below the line, another line is drawn below
those scores.

If the other team had a leg, it has been "cut off" and the chase to 100 starts
over.

If you have a leg, it is important to keep that in mind when bidding. If you
have a 40 leg, for instance, once you get to 2 Spades in your bidding, you can
stop, even if you are sure of being able to make 4 Spade.

The goal is not to bid 4 Spades. The goal is to reach 100 points and 2 Spades
at 30 points a trick added to the 40 leg is 100.

The first team to win two games completes the "rubber". You can either stop
playing or get a fresh score sheet and start another rubber. The team that
completes the rubber gets a 700-point bonus if the other team did not win a
game, or 500 points if the other team won a game.
//

Q: The opponents bid and made 2 Clubs. How many points do they get below the
line?

A: 40.
[BMP:SCORE3.BMP]

Q: You and your partner have enough high cards to take 10 tricks in Spades.
With the score as shown, how many tricks do you need to bid for game?

A: 1. 30 points for 1S plus the 90 you already have is more than 100.
(You still get points for the extra tricks you take, but you do not need to
bid them to make game.)
[BMP:SCORE4.BMP]

Q: You bid and make 3NT, giving you a second 100-point game and ending the
rubber. How many points do you get for the rubber bonus?

A: 700. You won two games before the opponents won one.
[BMP:SCORE5.BMP]
//

If you frequently overbid and your opponents set you, they get points. It is
possible to be the first to win two games, but lose the rubber on points,
even after getting the rubber bonus.

The winner is NOT the first to win two games, it is the team with the highest
score after the rubber has been completed.

If you have a poor hand, you simply say "Pass" rather than bid.

When you bid 3 of something, you are saying that your partner and you can take
9 tricks. Sometimes your partner and you both have such weak hands that you
could not take even 7 tricks combined, even if you got to name the trump. That
means that you cannot even bid 1 of something and you just have to pass.
//

As we said, the first team to win two games wins the rubber. After a team wins
one game, they are said to be "vulnerable". Both teams can be vulnerable or
non-vulnerable.

If your side is "vulnerable", you lose substantially more points when you go
set. For this reason, a team that is vulnerable has to be much more cautious
in its bidding if the other team is not vulnerable (has not won a game).

For example, it may be worthwhile for a non-vulnerable team to purposely
overbid to keep a vulnerable team from making game and getting the rubber
bonus. This is called "sacrificing", but if you sacrifice too often or at too
high a level, it can cost you more in penalty points than you would have lost
by letting the opponents get the rubber bonus.
//

[BMP:DONE]
Q: How many points do you have to make for game?

A: 100.

Q: How much do you have to bid in Diamonds for game?

A: 5.  (5 x 20 points)

Q: How much do you have to bid in Notrump for game?

A: 3. (40 x 1 plus 30 x 2)

Q: How many tricks do you have to take in Spades for game?

A: 10. The first six (known as the "book") for which you get no points, and
the next four tricks at 30 points per trick.
//

Q: If you have a "60 leg", how many Notrump do you have to bid for game?

A: 1.

The first trick (over the book) in Notrump is worth 40. Added to your 60
leg, that is 100 points, which is game.

Always keep an eye on the score sheet when bidding.

There is no point in bidding 5 Diamonds for game if you already have an 80 leg
and 1 Diamond would do.
//

[Erase]
Q: How many games does one side have to make to end the rubber?

A: 2.

Q: If N-S have made 1 game and E-W none, which side is "vulnerable"?

A: N-S.

Q: Can both sides be vulnerable?

A: Yes.

A rubber ends when one side wins two games. It is possible for boths sides to
win one game before one side wins the second one.
//

Bid To Communicate:

[N]
T 8 7 5 4
2
Q J 9 5
K 8 7

[S]
Q 6 2
K J 8 6 3
A 6
A J T

[W]
A J
Q 9 7
K T 3 2
Q 5 3 2

[E]
K 9 3
A T 5 4
8 7 4
9 6 4

Knowing how many tricks you and your partner can take and knowing which suit
is best when your hands are taken together requires communication between you
and your partner during the bidding.

You have seen in the hand shown on the left that if South had to pick a trump
suit without knowing anything about what his partner has, he would have picked
Hearts while if you look at both hands, Spades is the best suit because of the
8-card fit.

However, since you cannot see each other's cards, you have to use the bidding
process to give each other information about what your hands are like.

When you bid 1 Spade, you are not just saying "I think we can take 7 tricks
if Spades are trumps." You are saying that you have a certain range of
points and a certain minimum number of Spades.

//

[+]
[Bid]
1H

To make the best bid, your partner may need to know more precisely how many
points and trump cards you have.

Bidding is not over until three people in a row have passed. That means
that you and your partner can keep bidding even if your opponents have
passed, so there is plenty of opportunity to describe your hand to your
partner. (Of course, your opponents are listening too.)

Let's walk through the bidding of a deal, just basing bids on common sense
evaluation of the hands.

South dealt this hand and so he gets to bid first. This is easy. He has a
pretty good number of high cards and a 5-card Heart suit, so he could open the
bidding at 1 Heart.
//

[+]
[Bid+W]
Pass

West is next to bid.

He also has some decent high cards, but he doesn't have a good suit to bid.

If he had a good enough hand, he could bid 1NT.

How good is "good enough"? We'll look at that later, but for right now, West
will pass.
//

[+]
Now it's North's turn.

She doesn't have many high cards, but there's a problem: she only has one card
in the suit her partner bid, Hearts.

A 5-1 fit in a trump suit is awful, since that would mean that your opponents
have more of that suit than you do!

North has 5 Spades, but her hand is too weak to bid above the 1 level.

North can only bid 1S if Spades is a higher ranking suit than Hearts.
//

[+]
Q: Which suit ranks higher in bidding, Spades or Hearts?

A: S.

[Bid+N]
1S

This means that North can still bid 1S.

If South had opened 1S and North's Hearts and Spades holdings were reversed,
she would have to bid on the two level to bid Hearts over Spades, and her hand
is too weak to go to the two level.

But since South opened a Heart and North has Spades, North can safely bid
1S.
//

[+]
[Bid+E]
Pass

East also has only a couple of high cards, plus his partner has passed, so
she knows that the two of their hands combined probably do not have enough
high cards to take part in the bidding, particularly at the two level. So
East will pass also.
//

[+]
[Bid+S]
1NT

Now it's South's turn to bid again. His choices are 1NT or 2 of a suit. Let's
check out South's suits first:

His opening Heart bid promised 5+ Hearts. If he bids Hearts again, it will
promise 6+ Hearts, so he cannot rebid Hearts.

He only has 3 Spades, and partner only promises 4 by bidding them on the 1
level. Since it generally takes at least 8 cards to make a good trump suit,
South does not want to raise his partner's Spade bid.

His Minor suits are also short, so he doesn't want to bid them either.

Fortunately, since he has high cards in the two Minor suits and he and his
partner have bid both of the Majors, South can safely bid 1 NoTrump.
//

[+]
[Bid+W]
Pass
Pass
Pass

West could jump back in the bidding if he so desired, but his hand hasn't
improved from staring at it, so he passes again.

Now North has a problem. She would rather be in a suit contract, because
with a single Heart, she should be able to trump some Hearts.

However, her hand is so weak (no Aces and only 1 King) that she really cannot
afford to bid any higher. So she will pass too.

East still cannot bid, so she passes. That is three passes in a row
following South's 1NT bid, so South wins the bid and now must try to win 7
tricks in Notrump.
//

Evaluating Your Hand:

In the previous analysis, we talked about having a "good number of high
cards" or "not very many high cards", but how do you know how many is a good
number and how few is not very many?

Well, over 50 years ago, a famous bridge expert by the name of Charles
Goren devised a system of evaluating hands. In that system, an Ace is worth
4 points; a King, 3; Queen, 2; and Jack, 1. This is a total of 10 High Card
Points ("HCP") in each suit, or 40 in the four suits combined.

If you count the points in your hand using these values and the total is more
than 10, then you have more than your share of high cards and usually should
bid.

(There is also something called "distributional points" which will be
discussed later.)
//

[Erase]
In GENERAL, it takes about 26 combined points (your points and partner's)
to make game in a Major or in Notrump and 29 to make game in a Minor.

Q: How many points is an Ace worth?

A: 4.

Q: How many points is a Queen worth?

A: 2.

[N]
T 8 7 5 4
2
Q J 9 5
K 8 7

[S]
Q 6 2
K J 8 6 3
A 6
A J T

[W]
A J
Q 9 7
K T 3 2
Q 5 3 2

[E]
K 9 3
A T 5 4
8 7 4
9 6 4

Q: In the hand shown, what are the total High Card Points ("HCP") for
South?

A: 15.  Q=2, K=3, J=1, A=4, A=4, J=1

Q: Should South open the bidding?

A: Yes.
//

[+]
Q: How many points does West have?

A: 12. A=4, J=1, Q=2, K=3, Q=2

Q: How many points does North have?

A: 6. Q=2, J=1, K=3

Q: How many points does it generally take to make game in a Major?

A: 26.
//

[+]
Q: How many points do North and South have combined?

A: 21.

Without some unusual feature, such as a long running suit, 21 points is not
enough to make game.

Out of the 40 total HCP in the deck, N-S have 21.

This means that E-W have 19, so the HCP's are pretty evenly split between the
teams.

In cases like this, either side could end up taking the bid.
//

[+]
The bidding can go around the table several times.

Most of the time your first bid is not your last and is not the final
contract.

So in Bridge, when you open 1 Heart, you are not, at this point, trying to win
the bid in Hearts.

You are describing your hand to your partner so that your partner can add what
she knows about your hand to what she can see in her hand and make an
intelligent bid.

For example, when South bids 1H, North knows that South has at least 5 Hearts
(most partnerships agree not to open 1 of a Major without at least 5 cards in
the suit) and at least 12 total points, normally.
//

[+]
[Bid]
1H
Pass
1S
Pass
1NT
Pass
Pass
Pass

When North bids one Spade, South knows that North has at least four Spades (you
are no longer "opening" the suit. You are naming a new suit while responding
to partner's opening bid, which you can do with as few as four).

South also knows that North has at least 6 points, because otherwise North
would have passed, but North could have a lot more than 6 points, South
cannot tell yet, but does not want to pass while the possibility of bidding
game still exists. So South bids 1NT, as discussed before.

Now North knows that South does not have four Spades. Since partners are always
looking for at least an 8-card "fit" (eg: 4 in one hand, 4 in the other, or 5-3,
6-2, etc), North knows that South would have bid 2 Spades rather than 1NT once
South was aware of a 4-4 fit in Spades. Since he did not, he must not have 4
Spades.
//

[+]
However, North's original 1S response only promised four Spades, and North has
five.

If South has 3 Spades, N-S could still have a 5-3 fit, so North could rebid
the Spades at the 2 level.

As we discussed before, North knows that N-S could have less than 20 points,
since South could have opened with as few as 10 or 11 HCP and North only has
6.

So North is justified in passing at this point.
//

Distribution Points:

We mentioned before that North would like to be in a suit contract because she
only has 1 Heart and could probably trump Hearts. In valuing your hand, you can
assign a value to such distribution strong points.

A "void" (no cards in a suit) is worth 3 points, a "singleton" (1 in a suit) is
worth 2, and a "doubleton" (2) is worth 1 point.

This is a good time to point out that assigning values to high cards and
distributional features is not an exact science.

Most of the time, counting points can lead you to the best contract, but you
must always be alert to what other people's bids mean in relation to your
hand.
//

[Erase]
[Bid]
1H
Pass
1S
Pass
1NT
Pass
2H

For example, if you have one Spade, the King, you could count 3 points for the
King and 2 points for the doubleton, for a total of 5 points.

But if the opponent on your left opens 1 Spade, there is a good chance that he
has the Ace of Spades, making the your lone King worthless.

In contrast, if E-W keep passing and the bidding between N-S goes as shown on
the left, then your lone King of Spades is probably worth its full value
because your partner probably has some high cards in Spades to go with it.
//

[Erase]
[S]
T 6
K 3 2
A K Q 9 5 4
9 7

Q: How many High Card Points does South have?

A: 12. KH=3, AD=4, KD=3, QD=2

Q: How many distributional points does the hand have?

A: 2. Two doubletons.

Q: If South were dealer, what, if anything, would you bid.

A: 1D.

With 14 total points and an excellent 6-card suit, you must bid.
//

Opening 1 Of A Suit:

Q: Review: What is the minimum number of Spades your partner must have to open
1 Spade?

A: 5.

Most people play that you have to have 5 of a Major to open it. A small
percentage of people will open 4 of a Major, so be sure to ask both your
partner before play begins. You can ask your opponents during play.

In fact, in Bridge, it is against the rules to make a bid that has a secret
meaning that your partner understands and your opponents do not. So it is
quite proper to ask a bidder's partner (NEVER ASK THE BIDDER) how he
interprets his partner's bid.

YOU cannot, however, ask YOUR partner what a bid means. You should get your
bidding options straight with your partner BEFORE the game begins.

//

[Erase]
[Bid]
1H
Pass
1NT
Pass
2S
Pass
3H

[N]
x
Q T
K x x x x x
T x x x

[S]
A Q J x x
K Q x x x x
J
x

If you have 5 Spades and 6 Hearts, you should open with 1 Spade even though
you have more Hearts (unless you have a very strong hand).

The reason lies not with this turn at bidding, but what you will bid the next
time.

The bidding at left shows that if you bid the lower of two suits first, you
force your partner to the 3 level to choose between them.

With only 5 HCP, North is too weak to bid her own suits above the 1 level. Her
first 1NT bid denies Spades.

South's response of 2S tells her that South has a two-suited hand and that
North is required to choose between Spades and Hearts, which she does, even
though she hates being forced to bid at the 3 level.
//

[+]
[Bid]
1S
Pass
1NT
Pass
2H
Pass
Pass

Now look what happens when South bids the higher ranked suit first and then
the lower suit on the 2 level:

If partner prefers Hearts, she can just pass now, as shown on the left.

If North's Hearts and Spades were reversed, instead of Passing 2H, she would
have bid 2S.

Either way, the contract remains on the 2 level.
//

[Erase]
[S]
9 4
Q J T 7 3
8 7 2
A K T

Q: How many total points in this hand?

A: 11. QH=2, JH=1, AC=4, KC=3, doubleton=1

Q: If you were dealer, what if anything would you bid with this hand?

A: 1H.

You have a 5-card suit and 11 points. This is a minimum opening bid, but if
you do not open such hands, you will lose out on a lot of part scores and even
games.

This hand and the opening bid of 1H are from an actual deal played by experts.
Of course, experts have the playing skills to back up such bids.

If you open 11-points hands and find that you are getting set a lot, you and
your partner should agree not to open marginal hands.
//

Opening Convenient Minors:

[S]
A T 8 3
K J 6 5
A 9 2
Q T

Sometimes you may have a hand like the one shown. You will not have a 5-card
Major, but you do not have a good Minor suit to bid either, nor is your hand
strong enough to bid notrump.

You have 14 HCP plus a doubleton point, so you MUST open something. In this
case, you must bid your longest Minor, Diamonds.

You have absolutely no desire for Diamonds to be trump, unless your partner has
a ton of them, so all you are saying with a 1D or 1C bid is "I have opening
strength and I may or may not have a Diamond/Club suit."

What you are really hoping with this particular hand is that partner can bid 1
Heart or 1 Spade, which you will happily raise.
//

[Bid]
1S
Pass
2H
Pass
3D
Pass
3H
Pass
4D
Pass
5D

[N]
9
K Q T 9 8 3
Q 3 2
A Q 5

[S]
A Q T 5 2
-
K J 9 8 7 6
K 7

Let's stress again that it is substantially easier to make game in 4 of
a Major than 5 of a Minor, so preference should always be given to the
Majors or to notrump if you have a choice.

With South's hand, even though you have 6 Diamonds and only 5 Spades, you
should open the bidding (you have 17 total points) with 1S, not 1D.

If your partner bids Hearts (which you should expect with this holding), you
can bid Diamonds on your next turn to show that suit.

If North holds the cards shown, bidding could go as shown on the left.

As you can see, the contract ends up in 5 Diamonds. You should show a
preference for the Majors, but don't be afraid to bid game in a Minor if that
is what your hands are best suited for.

//

Opening A Suit with 16+ Points:

[S]
A K x x x x
A Q J x x
x
x

Q: How many total points does South have?

A: 18.

When you have a hand with more than the normal 11-15 point range for opening 1
of a suit, you can still open 1, but you bid the lower suit first.

In the lesson "Opening 1 of a Suit", we said that you should bid the higher of
two suits first to allow partner to pick one of the two suits at a lower
level.

So bidding the lower suit first is bidding them in reverse of the normal order
and is referred to as bidding a "reverse".

Since your hand is so strong, you don't mind forcing your partner to bid on
the three level if necessary. But more importantly, bidding a reverse is a way
of telling partner you have a strong hand.

//

[S]
A Q J x x
K x x x
A K x
x

Q: What do you bid with South's cards?

A: 1S.

You would like to bid a reverse to show your 19 total points by bidding Hearts
before Spades, but you cannot open a 4-card Major.

You can always make an exception to the "5-card Major" rule if your 4 cards
are something like AKQT, but not with the poor holding shown.
//

[S]
T x
A Q x x x
-
A K x x x x

Q: What do you open with the hand shown?

A: 1H.

Bid your 5-card Major first. Even with a very strong hand, we bid the 5-card
Major first.

If partner responds with 1S or 1NT, we would jump in Clubs to the 3 level to
show a strong 2-suited hand.

If partner responds with 2D over 1H, we would jump to 4 Clubs. Your partner
obviously does not have even 4 Spades (or she would have bid 1S over 1H), so
Spades are out. You can't stand Diamonds, so you are going to force partner to
bid game in either Clubs or Hearts.
//

Notrump Openings:

One requirement for opening with 1 NoTrump is a "stopper" in every suit.

The opponent to the left of declarer leads on the first trick. If N-S do not
have a "stopper" in every suit, E-W could rip off a bunch of tricks in one
suit before N-S ever win a trick.

An Ace is always a stopper. "K x" is a stopper if the opponent on your left
is leading because you are the last to play.

If either opponent plays the Ace, you simply play low and then your King is
high.

If the opponents do not play an Ace, then your King can win the trick.
//

If the opponent on your right leads low, your King may not be a stopper.

If you play the King, the opponent on your left may be able to take it
with the Ace.

Likewise, a Queen and two small cards or a Jack and three small cards may or
may not be stoppers.

However, when deciding whether or not to bid NT, you can consider those
holdings to be potential stoppers.

If your partner likes NT too, she may have help in some of the suits you are
weak in, so it is all right to open 1NT with just potential stoppers in some
suits.
//

Another requirement for bidding 1NT is a specific range of points.

Most people play that a 1NT bid shows 16-18 points, but some partnerships open
"weak notrumps".

If playing with a new partner, check this before the game starts. If playing
new opponents, you can ask the opener's partner during the bidding.

Only High Card Points are counted when bidding NT. Distributional points are
ignored, since you obviously cannot win tricks by trumping in your short
suits.

However, if you have a long running suit (eg: AKQJxx) or a lot of Tens and
Nines, you can consider them later in the auction when deciding whether or not
to push on to game or slam after partner responds.
//

The last requirement for opening 1NT is a balanced hand (no singletons, no
voids, no 5-card Majors). Distribution like 4-3-3-3 or 4-4-3-2 qualifies.

With 5-3-3-2 distribution and 16-18 points, you would NOT open 1NT. You would
open with your 5-card Spade suit instead. (Some people play that you DO open 1
NT with a 5-card Major if your hand otherwise qualifies. Check with your
partner first.)

With 2-3-3-5, most people would open 1NT rather than 1C because to bid game in
NT, you only have to take 9 tricks versus 11 tricks in Clubs. For this reason,
some people would even open 1NT with 2-2-4-5 distribution with solid stoppers
in the Majors, although other people will not open 1NT with two doubletons.
//

[Erase]
[S]
A K x x
A x x
K Q x
K x x x

Q: What do you open with the cards shown?

A: 1C.

This hand has 19 HCP. You only open 1NT with 16-18 points. Since you do not
have a 5-card Major, you bid your longer Minor.

[Pause]
[S]
Q x x x
K x x
A J x
A K x

Q: What do you open with South's cards?

A: 1NT. This is a classic 1NT holding.

[Pause]
[S]
x x
A x x
K Q x
A K Q x x

Q: What do you open with this hand?

A: 1C.

You have neither a stopper nor length in Spades. If you changed the King of
Clubs to the king of Spades, you could bid 1NT.

//

[S]
Q x x x
K x
A J x x
K Q x

Q: What do you open?

A: 1D.

You only have 15 HCP. You cannot count the doubleton point when bidding NT.
//

[Erase]
Bidding Stronger Notrump Hands -

If you have 22-24 points, a balanced hand, and a stopper in every suit,
open 2NT, or with 25-27 points, open 3NT.

Note that you bid 1NT with 16-18 and 2NT with 22-24 - there is a gap between
the points required for 1NT and 2NT.

If you have between 19-21, inclusive, you open 1 of a suit and show your
strength later in the bidding.
//

Opening A Suit With 22+ Points:

We have talked about game being 100+ points made by bidding and making a total
9 tricks at Notrump, 10 tricks in a Major, or 11 tricks in a Minor.

But if you can bid and make 12 or 13 tricks in any suit or in notrump, you
have made a "slam".

Bidding to take 12 tricks (in other words, bidding 6 of something) is called a
"small slam" and 13 tricks, a "grand slam".

Bidding slams usually requires a certain number of combined partnership points
- around 33 for a small slam and 37 for a grand slam.

However, when bidding slams, adding up your points is rarely enough.
//

[S]
A Q J 7 6 5 4
A
K Q J 2
8

When you have a very strong, distributional hand (one with singletons or
voids), forget counting points.

Instead, count your losing cards, under the assumption that your partner has
no help for you other than a couple of small trumps.

In the hand shown, you have two losers in Diamonds (you will probably have to
play the King to force the Ace, then your 2 will eventually lose to a higher
card), a loser in Clubs, and a possible loser in Spades.

With only 4 losers, you are only 1 trick away from being able to make game
without any help from partner. If partner has as little as the Ten of
Diamonds, you can make game.
//

[+]
If you open 1S, partner may pass with less than 6 points and you may miss
game. If you open 4S to make sure you don't miss game, partner may pass even
with enough points for you to have made slam.

So a special bidding system has been devised for such strong hands. The system
starts with opener bidding 2 Clubs. Partner realizes that this bid does not
mean that you like Clubs, but that you have a hand strong enough to make game
in some suit (not notrump).

Some partnerships bid "strong twos", meaning that instead of 2 Clubs, they
will bid 2 of their best suit - 2 Spades, in this example.

Bidding 2 Clubs to show a strong hand is called bidding "weak twos" because
2D, 2H, and 2S are used to show weak, distributional hands in those suits.
//

Opening With 6-12 Points And A 6-Card Suit:

[S]
A Q x x x x
Q x
x x x
x x

In the previous lesson, we mentioned that with very strong hands, you open 2C
no matter what your best suit is and save 2D, 2H and 2S for weak hands with
good suits.

The purpose of opening a weak two is to accurately describe your hand to
partner and at the same time to deprive your opponents of bidding space.

If South opens 2S with the cards shown, the opponents will have to start
bidding their suits at the 3 level, which can be risky.

Meanwhile, you have very accurately described your hand to your partner: a
6-card suit with 2 of the top 3 cards or 3 of the top 5 cards, and 6-12 HCP.
//

[S]
Q J x x x x
A x x
x x
x x

Q: What do you bid with South's cards?

A: P. You do not have 2 of the top 3, nor 3 of the top 5 Spades.

[Pause]
[S]
K Q x x x x
Q x x x
x
x x

Q: What do you bid with these cards?

A: P. Don't open a weak 2 if you have a four-card Major. You may miss game
if partner also has 4+ cards in the same suit and a good hand. If partner has
already passed, go ahead and open 2S.

[Pause]
[S]
Q x x
K Q x x x x x
x
x x

Q: What do you bid with South's cards?

A: P. (Or see the section on preemptive bids.) You have a 7-card, not a
6-card suit.
//

[S]
Q x x
x x
x x
K Q x x x x

Q: Now what do you bid?

A: P.

You cannot open 2C because that shows a very strong hand. You can only bid
weak twos in Spades, Hearts, or Diamonds.

[Pause]
[S]
Q J T
K Q x x x x
x x
x x

Q: Now what do you bid?

A: 2H. This is a classic weak two holding.
//

Opening Weak Hands With 7+ Card Suits:

If you have a weak hand with a very long suit, you may be able to steal a bid
that rightfully belongs to the opponents by bidding your suit on a high level
(3 or higher) instead of passing or bidding 1 (which you should be too weak to
do anyway).

This is known as "preempting". You do not expect to make the bid, you are
trying to keep the opponents from making game by depriving them of a lot of
bidding space.

If you are not vulnerable (see "Scoring"), you can afford to go down 3 tricks
doubled. If you are vulnerable, you can only afford to go down 2 tricks
doubled.

This assumes that your opponents could make game. If you preempt and go down
when the opponents could NOT have made game anyway, that is derisively
referred to as a "phantom sacrifice".
//

To make a preempt, you should have at least 7 cards in your suit and no
defensive values (A or KQ) in other suits.

[S]
K Q J T xxxx
x x
x x
x

Q: Your side is vulnerable. What do you bid? (Hint: Count your trump tricks.)

A: 3S.

You should win 7 of your 8 Spades. There are only 5 Spades not in your hand.
Normally they will be divided evenly among your two opponents and your
partner, which means that two hands will normally have 2 each and one hand
will have 1.

Even if they are divided abnormally and one hand had 4 of the 5, you can force
out the Ace with your king and draw the rest of the trumps with the Q, J, Ten.
//

[+]
Then the rest of your trumps are winners, meaning you win 7 of your 8 trump
tricks.

If you bid 3 Spades, you are contracting to win 9 tricks (3 bid plus the
6-book).

If you take 7 tricks, you only go down 2, even if partner cannot take a single
trick.

That is a good sacrifice even when doubled and vulnerable if your opponents
had a sure game.
//

[+]
Q: Your side is not vulnerable. What do you bid with the same cards?

A: 4S.

You can afford to sacrifice one more when not vulnerable.

[Pause]
[S]
K Q J x x x x
A x x
x x
x

Q: You are not vulnerable. What do you bid with this hand?

A: 1S.

You have 10 HCP and 3 distribution points. This is strong enough to open on
the one level.
//

[S]
K Q xxx xxx
Q x
x x x
-

Q: Your side is vulnerable. What do you bid?

A: P.

You have at least 1 Spade loser, 2 in Hearts, and 3 in Diamonds. That is down
at least 3 if you preempt at the 3 level.
//

[Erase]
[Bid]
3C
Pass
???

[N]
A K J x x
A K T x x
K x
x

[S]
-
x x x x
Q x
K Q x x x x x

If you bid before your partner, you should be wary of preempting your partner
out of a game, particularly if you have a 4-card Major.

Once South opens with a preempt of 3C, it is virtually impossible for N-S to
find their game in Hearts.

If South had two Spades and two less Hearts, this would have been a good hand
for preempting since it less likely that partner has a fit.
//

Review Questions:

[Erase]
Q: What are the Major Suits? (eg: D, C or H, D or S, H)

A: S, H

Q: In a Diamond or Club contract, how many points is each trick bid and made
worth?

A: 20.

Q: You bid 4 Diamonds and make 11 tricks. How many points do you get below the
line?

A: 80. (4 * 20)

Q: And how many above the line?

A: 20. You made one overtrick.
//

Q: You bid and made 2NT. How many points do you get below the line?

A: 70. (40 for the first trick, 30 for the second)

Q: You bid 7NT and made 3. How many points do you get?

A: 0. If you go set, you do not get any points. Your opponents get points for
setting you.

Q: You bid and make 3NT, with your opponents taking 4 tricks. How many points
do they get for their 4 tricks?

A: 0. The defense only scores if they set the bidder.
//

[Erase]
[S]
A Q x x
K x x x
K Q x
A x

Q: How many points does South have?

A: 19. (18 HCP and 1 for the doubleton.)

Q: What is the point range required for opening 1 NT?

A: 16-18.

Q: What should South open with this hand?

A: 1NT. South has 18 HCP points (don't count distribution points when
counting for NT), a stopper in every suit, and no singletons or voids.
//

[S]
A x x x
K x x x
K Q x
J x

Q: How many total points does South have?

A: 14. - 13 HCP plus 1 for the doubleton.

Q: What should South bid?

A: 1D. South MUST bid with 14 points and cannot bid a Major of less than
5 cards, so he opens a "convenient Minor".

Q: If South also had the Ace of Hearts instead of a little Heart, could he
open this hand with 1NT?

A: No. "J x" in Clubs does not represent even a potential stopper.
//

[+]
Q: If South had the Ace of Clubs instead of the Jack, could he open this hand
1NT?

A: Yes. South would have 16 HCP and a balanced hand (only one doubleton).
//

[S]
Q J x x x
A K x x x
x x
x

Q: How many total points does South have?

A: 13. Ten HCP, 1 for the doubleton, 2 for the singleton.

Q: What should South bid?

A: 1S. With less than 16 HCP, open the higher suit first. Then bid
the lower suit at your next turn.
//

[S]
A K x x x x
K Q x x x
A x
-

Q: How many distributional points does South have?

A: 4. Three for the void and one for the doubleton.

Q: What should South bid?

A: 1H. With 16 HCP and 4 distributional points, South is strong enough to bid
a "reverse" by bidding the lower suit first.

When a hand is this strong (20+ points), you should count the losers to see if
you should make a forcing 2C bid.

In a contract of 4S, South could have a couple of Spade losers, a couple of
Heart losers, and a Diamond loser. That's at least 5 losers and you can only
afford to lose 3 when bidding game, so this hand is not quite strong enough
to make a forcing opening bid.
//

[S]
A K Q J x x
K Q x x x
A x
-

Q: How many points does South have?

A: 23. He has 19 HCP plus 4 for distribution.

Q: How many probable losers does South have?

A: 4.

South has no Spade losers (if the 7 out are divided no worse than 4-0-3,
South's AKQJ will pull in all the Spades), maybe three Heart losers (if the 8
other Hearts are divided no worse than 4-0-4), and 1 Diamond loser.

Q: What should South Bid?

A: 2C. South is close enough to game to make a "strong, artificial, forcing"
bid of 2 Clubs.
//

[S]
A K x x
A Q J
A x x
K x x

Q: What should South bid with this holding?

A: 1D.

With 21 HCP, South is 1 point shy of the 22-24 required to open 2NT and is too
strong to open 1NT.

Without a 5-card Major, South must bid his best Minor suit.
//

[S]
x x
A Q x x x x
K x x x
x

Q: What should South bid?

A: 2H. The requirements are 6-12 points, a 6-card suit with 2 of the top 3 or
3 of the top 5 cards, and no other 4-card Major.

[Pause]
[S]
x x
A Q x x x x x
K x x
x

Q: With one more Heart and one less Diamond, what should South bid?

A: 3H. - if not vulnerable, pass if vulnerable. Requirements are 7+ cards
in your suit, and little or no defensive values.

You should also be able to limit your losses to down 3 if not vulnerable and
down 2 vulnerable. (You should always assume that if you have mucked things up
for the opponents with your preempt so that they cannot bid their suit, they
will at least double your bid.)
//

Wrap-Up:

[Erase]
This is the end of the course covering an Introduction to Bridge and Opening
Bids.

The next course in Level I covers Responding To Opening Bids, Rebids by
Bidder, and Competitive Bidding.

Return to the Index and load L1-BID2.CSC.

Please remember that this program is shareware and the author of the program
relies on your support. If you like what you have seen so far, click the
Register button on the Index screen.
//

[End]
