/*
Programmic interface to WSFTPDLL.DLL.
Copyright (C) 1996, 1997, 1998 Ipswitch, Inc.  
All rights reserved.

Permission to redistribute WSFTPDLL.DLL is prohibited
and unlawful without express written permission from
Ipswitch, Inc.
*/

/*
This is the user portion of the CINFO structure.  Note
the structure is considerably larger than this. Anything
beyond what is provided here is not constant and may be
changed at any time.
*/

#ifndef _WSFTPINFODEFINED

#define _WSFTPINFODEFINED

#ifndef WIN32
#ifndef LPCTSTR
#define LPCTSTR LPCSTR
#endif
#endif

typedef struct _WSFTPTAGCINFO
{
  int nErr;        // winsock error codes
  int nHostType;   // 6000 or higher
  DWORD nReserved1;  // do not change value found here
  int nFlags;      // usage will be specified in the future
  BOOL bAborted;   // set if function was aborted
  BOOL bCancel;    // set to 1 if a cancel is requested
  BOOL bPassive;   // 1 if passive mode requested
  BOOL bHash;      // 1 if transfer window should be displayed
  BOOL bBell;      // 1 if bell sounds after file send/receive
  // do not change the following!
  LPCTSTR pLastMsg;  // pointer to last DLL message
  LPCTSTR pLastLine; // pointer to last line received from host
  LPVOID pUser1;     // user defined
  LPVOID pUser2;     // user defined
  DWORD dwUser1;     // user defined
  DWORD dwUser2;     // user defined
  LPCTSTR pHostName; // pointer to hostname
} FAR * LPCINFO;

typedef struct _WSFTPTAGFILEINFO
{
  LPVOID pOwner;          // pointer to directory info structure
  LPVOID pNext;           // pointer to next file info structure
  char szFileName[256];
  int nYear;
  int nMonth;
  int nDay;
  int nHour;
  int nMinute;
  int nSecond;
  DWORD dwSize;
  int nAttrib;            // NA for many host types
  int nFlags;
  int nType;              // 1=file 2=dir 3=link 0=unknown
  LPVOID pDInfo;          // pointer to directory info structure
  int nUser1;             // user defined
  int nUser2;             // user defined
  int nUser3;             // user defined
} WSFTPFINFO, FAR * LPWSFTPFINFO;

typedef struct _WSFTPTAGDIRINFO
{
  char szHostName[256];
  char szDirName[256];
  LPVOID pFirstFile;
  int nFiles;
  int nDirs;
  int nLinks;
  int nUser1;             // user defined
  int nUser2;             // user defined
  int nUser3;             // user defined
} WSFTPDINFO, FAR * LPWSFTPDINFO;

typedef struct _WSFTPTAGUSERINFO
{
  LPCINFO pCINFO;
  LPWSFTPDINFO pDINFO;
  LPWSFTPFINFO pFINFO;
  char szDirName[256];
} WSFTPUINFO, FAR * LPWSFTPUINFO;

#ifdef __cplusplus
extern "C" {
#else

#ifndef LPCTSTR
// some languages may need this, C++ doesn't like it
#define LPCTSTR LPCSTR
#endif
#ifndef LPTSTR
#define LPTSTR LPSTR
#endif
#endif /* __cplusplus */


#ifndef BOOL
#define BOOL int
#endif

BOOL WINAPI WSFTP_GetFile(
    LPCTSTR pHost,         // name of host
    LPCTSTR pUser,         // userid 
    LPCTSTR pPass,         // password
    LPCTSTR pRemoteFile,   // full path of file to retrieve
    LPCTSTR pLocalFile,    // full path of destination file
    BOOL bBinary,          // 1=binary  0=ascii
    BOOL bInitWinsock,     // 1 normally, 0 if WSAStartUp has
                           // already been called.
    LPCTSTR pErrMsg,       // area to store error message or NULL
                           // should be 128 or more bytes long
    HWND hEditWnd          // multi-line edit window to receive
                           // conversation or NULL
);

BOOL WINAPI WSFTP_PutFile(
    LPCTSTR pHost,         // name of host
    LPCTSTR pUser,         // userid
    LPCTSTR pPass,         // password
    LPCTSTR pLocalFile,    // full path of source file
    LPCTSTR pRemoteFile,   // full path of destination file
    BOOL bBinary,          // 1=binary  0=ascii
    BOOL bInitWinsock,     // 1 normally, 0 if WSAStartUp has
                           // already been called.
    LPCTSTR pErrMsg,       // area to store error message or NULL
                           // should be 128 or more bytes long
    HWND hEditWnd          // multi-line edit window to receive
                           // conversation or NULL
);

void WINAPI WSFTP_SetDebugLog(BOOL bDoLog,LPCSTR pFileName);

/*
LPCINFO WINAPI WSFTP_InitCINFO(HWND hWnd,HWND hMsgWnd,int nFlag);

WSFTP_InitCINFO MUST be called ONCE before any WSFTP 
  functions can be used.  The value returned by 
  WSFTP_InitCINFO must be saved and used as the first 
  parameter of ALL subsequent calls.  The structure
  returned by WSFTP_InitCINFO must be destroyed using
  WSFTP_FreeCINFO before program exit.  This routine
  is responsible for initializing the Winsock DLL IF the
  nFlag field contains WSFTPF_INITWINSOCK (4) otherwise
  it is a user function to initialize the winsock interface.
  Only ONE call to WSFTP_InitCINFO can contain the value
  to initialize Winsock.  Subsequent calls while the first
  pCINFO exists should call with nFlag=0.

hWnd    = top level owner window (required)
hMsgWnd = NULL or edit window where messages are
          sent
*/
LPCINFO WINAPI WSFTP_InitCINFO(HWND hWnd,HWND hMsgWnd,UINT nXferMsg,int nFlag);
#define WSFTPF_INITWINSOCK 0x0004


/*
LPVOID WINAPI WSFTP_FreeCINFO(LPVOID pCINFO);

WSFTP_FreeCINFO MUST be called ONCE immediately
  before your program exits.
pCINFO  = pointer returned by WSFTP_InitCINFO
*/
LPCINFO WINAPI WSFTP_FreeCINFO(LPCINFO pCINFO);

/*
int WINAPI WSFTP_Connect(
     LPVOID pCINFO,         // pointer to connection info
     LPCTSTR pHost,           // pointer to host name
     WORD wPort,            // remote port number (should be 21)
     LPCTSTR pUserID,         // userid for remote host or NULL
     LPCTSTR pPassword);      // password for remote host or NULL

WSFTP_Connect establishes a TCP connection to the host
  and port specified.  If a userid and password are
  specified, an FTP connection is assumed and the DLL
  will establish a valid control circuit with the 
  designated host and the host type will be determined.

Return value will be the value found at the beginning of
  the last line read or 500 for an error.
*/
int WINAPI WSFTP_Connect(LPCINFO pCINFO,LPCTSTR pHost,WORD wPort,
                                    LPCTSTR pUserID,LPCTSTR pPassword);


/*
BOOL WINAPI WSFTP_ConnectAsync(
     LPVOID pCINFO,         // pointer to connection info
     LPSTR pHost,           // pointer to host name
     WORD wPort,            // remote port number (should be 21)
     LPSTR pUserID,         // userid for remote host or NULL
     LPSTR pPassword,       // password for remote host or NULL
     UINT msg);             // callback message when connected

	 Alternate form of connect
*/
BOOL WINAPI WSFTP_ConnectAsync(LPCINFO pCINFO,LPSTR pHost,WORD wPort,
                              LPSTR pUserID,LPSTR pPassword,UINT nMsg);

/*
int WINAPI WSFTP_AutoDetectSyst(LPCINFO pCINFO);
   Attempts to auto detect the hosttype of a connection.
	 Note that this is done automatically on a connect IF
	 a userid and password is provided in the connect call.
	 This call only needs to be performed if you manually
	 walk through a connection or possibly if you've setup
	 a firewall connection.
*/
int WINAPI WSFTP_AutoDetectSyst(LPCINFO pCINFO);

int WINAPI WSFTP_CloseConnect(LPCINFO pCINFO,int nFlag);

/*
int WSFTP_SendCommand(
     LPCINFO pCINFO,  // pointer returned by WSFTP_InitCINFO
     LPSTR pCommand); // formatted FTP command string to send

     Executes the specified RFC compliant FTP command.  Note
     that FTP commands that require a data socket cannot be
     executed in this manner (NLST, LIST, STOR, STOU, RETR).

     returns 0 if successful, otherwise returns -1 and
     pCINFO->nErr is set to a Winsock error code
*/
int WINAPI WSFTP_SendCommand(LPCINFO pCINFO,LPCTSTR pCommand);
int WINAPI WSFTP_SendCommandAsync(LPCINFO pCINFO,LPCTSTR pStr,UINT msg);

int WINAPI WSFTP_RecvResponse(LPCINFO pCINFO);
int WINAPI WSFTP_RecvResponseAsync(LPCINFO pCINFO,UINT msg);

int WINAPI WSFTP_StopAsync(LPCINFO pCINFO);

/*
int WINAPI WSFTP_DoCmd(
     LPCINFO pCINFO,
     LPCTSTR pCmd,       // pointer to RFC FTP command string
     LPCTSTR pArg);      // pointer to arguments or NULL

Executes the specified RFC compliant FTP command.  Note
  that FTP commands that require a data socket cannot be
  executed in this manner (NLST, LIST, STOR, STOU, RETR).

Return value will be the value found at the beginning of
  the last line read or 500 for an error.

*/
int WINAPI WSFTP_DoCmd(LPCINFO pCINFO,LPCTSTR pCmd,LPCTSTR pArg);

/*
  Three methods of sending files are provided. 
  WSFTP_SendFile       - blocking, doesn't return until complete or error
  WSFTP_SendFileAsync  - async, returns an error or sends "msg" to hWnd when complete or error
  WSFTP_SendFileThread - threaded, returns an error or sends "msg" to hWnd when complete or error

  msg = should be WM_USER + x
        wParam = response code     200 for success or ftp error code
        lParam = bytes transfered
*/
int WINAPI WSFTP_SendFile(LPCINFO pCINFO,LPCTSTR pLocalName,LPCTSTR pRemoteName,BOOL bBinary);
int WINAPI WSFTP_SendFileAsync(LPCINFO pCINFO,LPCTSTR pLocalName,LPCTSTR pRemoteName,BOOL bBinary,UINT msg);
int WINAPI WSFTP_SendFileThread(LPCINFO pCINFO,LPCTSTR pLocalName,LPCTSTR pRemoteName,BOOL bBinary,UINT msg);

/*
  Three methods of receiving files are provided. 
  WSFTP_RecvFile       - blocking, doesn't return until complete or error
  WSFTP_RecvFileAsync  - async, returns an error or sends "msg" to hWnd when complete or error
  WSFTP_RecvFileThread - threaded, returns an error or sends "msg" to hWnd when complete or error

  msg = should be WM_USER + x
        wParam = response code     200 for success or ftp error code
        lParam = bytes transfered
*/
int WINAPI WSFTP_RecvFile(LPCINFO pCINFO,LPCTSTR pRemoteName,LPCTSTR pLocalName,BOOL bBinary);
int WINAPI WSFTP_RecvFileAsync(LPCINFO pCINFO,LPCTSTR pRemoteName,LPCTSTR pLocalName,BOOL bBinary,UINT msg);
int WINAPI WSFTP_RecvFileThread(LPCINFO pCINFO,LPCTSTR pRemoteName,LPCTSTR pLocalName,BOOL bBinary,UINT msg);

/*
 WSFTP_TransferFile is a blocking call allowing host
 to host transfers.  pDSTCINFO->pLastMsg is where 
 error messages go to.  if either pSRCCINFO or
 pDSTCINFO are NULL it is treated as a RecvFile
 or SendFile call with the local side being the
 NULL side.
 returning 200-500
*/
int WINAPI WSFTP_TransferFile(
       LPCINFO pSRCCINFO,
       LPCTSTR pSrcName,
       LPCINFO pDSTCINFO,
       LPCTSTR pDstName,
       BOOL bBinary);

int WINAPI WSFTP_TransferFileThread(
       LPCINFO pSRCCINFO,
       LPSTR pSrcName,
       LPCINFO pDSTCINFO,
       LPSTR pDstName,
       BOOL bBinary,
       HWND hWnd,
       UINT msg);

/*
int WINAPI WSFTP_RecvDsp(LPCINFO pCINFO,HWND hWnd,LPCTSTR pCmd,LPCTSTR pArg);

This routine will execute the command specified and
will return the output from the remote host to the
window handle specified in hWnd.  Valid commands that 
can be sent here are LIST, NLST, and RETR.  Any other 
command execution is not supported.
*/
int WINAPI WSFTP_RecvDsp(LPCINFO pCINFO,HWND hWnd,LPCTSTR pCmd,LPCTSTR pArg);

LPWSFTPDINFO WINAPI WSFTP_GetDirectory(LPCINFO,LPCTSTR);
int WINAPI WSFTP_GetDirectoryAsync(LPCINFO pCINFO,LPCTSTR pAdd,UINT msg);
LPWSFTPDINFO WINAPI WSFTP_FreeDirectory(LPWSFTPDINFO);
LPWSFTPDINFO WINAPI WSFTP_GetLocalDirectory(LPCINFO pCINFO,LPCTSTR pMask);

int WINAPI WSFTP_CancelAction(LPCINFO pCINFO);

// returns error string associated with Winsock error nErr
// copies it to lpszBuf if supplied.  lpszBuf should be at
// least 80 characters.
LPTSTR WINAPI WSFTP_ReturnErrorString(UINT nErr,LPCTSTR lpszBuf);

LPSTR WINAPI WSFTP_ReturnLastErrorString(LPCINFO pCINFO);
LPSTR WINAPI WSFTP_ReturnLastLineString(LPCINFO pCINFO);
int   WINAPI WSFTP_ReturnLastErrorInt(LPCINFO pCINFO);
LPSTR WINAPI WSFTP_ReturnCurrentHostString(LPCINFO pCINFO);
LPSTR WINAPI WSFTP_ReturnCurrentUserIDString(LPCINFO pCINFO);
int   WINAPI WSFTP_ReturnCurrentHostTypeInt(LPCINFO pCINFO);
LPSTR WINAPI WSFTP_ReturnCurrentHostTypeString(LPCINFO pCINFO);

// support routines, use not recommend by external routines
void WINAPI WSFTP_AddTextToWindow(HWND hWnd,LPCTSTR pBuf);
// void CDECL WSFTP_DoPrintf(HWND hWnd,LPCTSTR szFormat,...);

#define WSFTP_ChangeDirectory(pCINFO,pDirName) WSFTP_DoCmd(pCINFO,"CWD",pDirName)
#define WSFTP_CreateDirectory(pCINFO,pDirName) WSFTP_DoCmd(pCINFO,"MKD",pDirName)
#define WSFTP_DeleteDirectory(pCINFO,pDirName) WSFTP_DoCmd(pCINFO,"RMD",pDirName)
#define WSFTP_DeleteFile(pCINFO,pFileName) WSFTP_DoCmd(pCINFO,"DELE",pFileName)

/////////////////////////////////////////////////////////////////
// following routines requires version 5.0 of FTPPRO16/32.DLL

int WINAPI WSFTP_AddHostTypesToListBox(HWND hListBox,BOOL bIsComboBox);

int WINAPI WSFTP_ConnectFirewall(
           LPCINFO pCINFO,LPSTR pHost,WORD wPort,
                          LPSTR pUserID,LPSTR pPassword,LPSTR pAccount,
           int nFireType, LPSTR pFireHost,WORD wFirePort,
                          LPSTR pFireUserID,LPSTR pFirePassword,LPSTR pFireAccount);

// major=HIBYTE(WSFTP_GetDllVersion())
// minor=LOBYTE(WSFTP_GetDllVersion())
WORD WINAPI WSFTP_GetDllVersion();

int WINAPI WSFTP_HTTPRetrieve(LPCINFO pCINFO,
       BOOL bHTTP,LPCSTR pHost,WORD wPort,
       LPCSTR pSrcFile,LPCSTR pDestFile,int nDir);

int WINAPI WSFTP_ParseLine(LPCINFO pCINFO,LPWSFTPDINFO pDInfo,LPWSFTPFINFO pFInfo,LPSTR pLine);

int WINAPI WSFTP_ReRecvFile(LPCINFO pCINFO,LPSTR pRemoteName,LPSTR pLocalName,BOOL bBinary);

LPCSTR WINAPI WSFTP_ReturnHostTypeName(int nHostType);

void WINAPI WSFTP_SetDebugLog(BOOL bDoLog,LPCSTR pFileName);

int WINAPI WSFTP_SetHTTPProxy(LPCINFO pCINFO,LPSTR pHost,WORD wPort,
                         LPSTR pUserID,LPSTR pPassword);

#define FIRE_TYPE_NONE 0
#define FIRE_TYPE_SITE  1
#define FIRE_TYPE_USERAFTERLOGIN 2
#define FIRE_TYPE_USERNOLOGON 3
#define FIRE_TYPE_PROXYOPEN 4
#define FIRE_TYPE_USER_REMOTEID_REMOTEHOST_FIREID 5
#define FIRE_TYPE_USER_FIREID_REMOTEHOST 6
#define FIRE_TYPE_TRANSPARENT 7
#define FIRE_TYPE_USER_REMOTEID_FIREID_REMOTEHOST 8
// end of 5.0 insert
////////////////////////////////////////////////////////////////////

#ifdef __cplusplus
}
#endif  /* __cplusplus */

/*
Following host types are shared with all versions of
WS_FTP and are provided here for possible program use.
*/

#define HOST_TYPE_AUTO                  6000
#define HOST_TYPE_CHAMELEON             6001
#define HOST_TYPE_PCTCP                 6002
#define HOST_TYPE_IBM_TCP               6003
#define HOST_TYPE_IBM_VM                6004
#define HOST_TYPE_NOS                   6005
#define HOST_TYPE_NCSA                  6006
#define HOST_TYPE_SINTFTPD              6007
#define HOST_TYPE_SUPER                 6008
#define HOST_TYPE_U5000                 6009
#define HOST_TYPE_UNIX                  6010
#define HOST_TYPE_VMS_MULTINET          6011
#define HOST_TYPE_VMS_UCX               6012
#define HOST_TYPE_QVT                   6013
#define HOST_TYPE_MAC_NCSA              6014
#define HOST_TYPE_MAC_PS                6015
#define HOST_TYPE_WINNT                 6016
#define HOST_TYPE_IBM_AS400             6017
#define HOST_TYPE_IBM_MVS               6018
#define HOST_TYPE_PDP_RSX11             6019
#define HOST_TYPE_SOLARIS               6020
#define HOST_TYPE_OS9                   6021
#define HOST_TYPE_PIPERIP               6022
#define HOST_TYPE_GCOS                  6023
#define HOST_TYPE_KNET_MVS              6024
#define HOST_TYPE_AMIGA                 6025
#define HOST_TYPE_CYBER                 6026
#define HOST_TYPE_R1000                 6027
#define HOST_TYPE_BULL                  6028
#define HOST_TYPE_IBM_SPARTACUS_KNET    6029
#define HOST_TYPE_TANDEM                6030
#define HOST_TYPE_STRATUS_VOS           6031
#define HOST_TYPE_HP3000                6032
#define HOST_TYPE_SERVU                 6033
#define HOST_TYPE_WFTPD                 6034
#define HOST_TYPE_NOVELL4               6035
#define HOST_TYPE_PCNFSPRO              6036
#define HOST_TYPE_WIN_MULTINET          6037
#define HOST_TYPE_PCTCP30               6038
#define HOST_TYPE_QVT40                 6039
#define HOST_TYPE_VERSATERM             6040
#define HOST_TYPE_HELLSOFT              6041
#define HOST_TYPE_IBM_WARP              6042
#define HOST_TYPE_PRIMOS                6043
#define HOST_TYPE_OS2200                6044
#define HOST_TYPE_UNITREE               6045
#define HOST_TYPE_QNX2                  6046
#define HOST_TYPE_WARFTPD               6047
#define HOST_TYPE_IBMBROOKS             6048
#define HOST_TYPE_MUSIC                 6049
#define HOST_TYPE_AOSVS                 6050
#define HOST_TYPE_PASSPORT_160          6051

// the number of host types in the list
#define MAXTYPES 52

#endif /* _WSFTPINFODEFINED */

