@echo off

setlocal
 
rem ----------------------------------------------------------------------
rem     Uninstall script for Surf Spy
rem
rem ----------------------------------------------------------------------

rem ----------------------------------------------------------------------
rem CONFIGURE START

set FILES_TO_DELETE=
set FILES_TO_DELETE=%FILES_TO_DELETE% surfspy.exe
set FILES_TO_DELETE=%FILES_TO_DELETE% surfspyconfig.cfg
set FILES_TO_DELETE=%FILES_TO_DELETE% manual.txt

rem CONFIGURE END
rem ----------------------------------------------------------------------

set CHOICE_EXECUTABLE=CHOICE.COM
set FILES_TO_DELETE=%FILES_TO_DELETE% %CHOICE_EXECUTABLE%

set LOG_FILE_NAME=logfile.html


echo -----------------------------------------
echo This is the uninstall script for Surf Spy
echo -----------------------------------------

if not exist %CHOICE_EXECUTABLE% goto choicedoesnotexist

choice "Are you sure you'd like to uninstall Surf Spy " /c:YN

if ERRORLEVEL 2 goto dontunistall
if ERRORLEVEL 1 goto uninstall

:dontunistall
        echo Exiting.
        goto end

:uninstall
        echo Shutting down Surf Spy if it is running.
        surfspy -kill
        echo Success
        echo Removing registry keys.
        surfspy -unreg
        echo Success
        del %FILES_TO_DELETE%
                rem echo %LOG_FILE_NAME% and %0 file was
                rem echo not deleted. If you don't want to keep them,
                rem echo just delete them.
        echo The Surf Spy was successfully unistalled!
        goto end

:choicedoesnotexist
        echo ERROR! Cannot find the choice.com executable.
        goto end        

:end

endlocal
@echo on
